/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.graphic;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.sequencediagram.graphic.Segment;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.SimpleContext2D;
import net.sourceforge.plantuml.ugraphic.UGraphic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SegmentColored {
    private final Segment segment;
    private final HtmlColor backcolor;
    private final boolean shadowing;

    SegmentColored(double d, double d2, HtmlColor htmlColor, boolean bl) {
        this(new Segment(d, d2), htmlColor, bl);
    }

    private SegmentColored(Segment segment, HtmlColor htmlColor, boolean bl) {
        this.segment = segment;
        this.backcolor = htmlColor;
        this.shadowing = bl;
    }

    public HtmlColor getSpecificBackColor() {
        return this.backcolor;
    }

    public boolean equals(Object object) {
        SegmentColored segmentColored = (SegmentColored)object;
        return this.segment.equals(segmentColored.segment);
    }

    public int hashCode() {
        return this.segment.hashCode();
    }

    public String toString() {
        return this.segment.toString();
    }

    public void drawU(UGraphic uGraphic, Component component, int n) {
        double d = uGraphic.getTranslateX();
        double d2 = uGraphic.getTranslateY();
        StringBounder stringBounder = uGraphic.getStringBounder();
        uGraphic.translate((double)(n - 1) * component.getPreferredWidth(stringBounder) / 2.0, this.segment.getPos1());
        Dimension2DDouble dimension2DDouble = new Dimension2DDouble(component.getPreferredWidth(stringBounder), this.segment.getPos2() - this.segment.getPos1());
        component.drawU(uGraphic, new Area(dimension2DDouble), new SimpleContext2D(false));
        uGraphic.setTranslate(d, d2);
    }

    public Collection<SegmentColored> cutSegmentIfNeed(Collection<Segment> collection) {
        return new Coll2(this.segment.cutSegmentIfNeed(collection));
    }

    public SegmentColored merge(SegmentColored segmentColored) {
        return new SegmentColored(this.segment.merge(segmentColored.segment), this.backcolor, this.shadowing);
    }

    public final Segment getSegment() {
        return this.segment;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Coll2
    extends AbstractCollection<SegmentColored> {
        private final Collection<Segment> col;

        public Coll2(Collection<Segment> collection) {
            this.col = collection;
        }

        @Override
        public Iterator<SegmentColored> iterator() {
            return new Iterator2(this.col.iterator());
        }

        @Override
        public int size() {
            return this.col.size();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class Iterator2
    implements Iterator<SegmentColored> {
        private final Iterator<Segment> it;

        public Iterator2(Iterator<Segment> iterator) {
            this.it = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public SegmentColored next() {
            return new SegmentColored(this.it.next(), SegmentColored.this.backcolor, SegmentColored.this.shadowing);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

