/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.graphic;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.sequencediagram.AbstractMessage;
import net.sourceforge.plantuml.sequencediagram.LifeEvent;
import net.sourceforge.plantuml.sequencediagram.LifeEventType;
import net.sourceforge.plantuml.sequencediagram.MessageNumber;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.graphic.Arrow;
import net.sourceforge.plantuml.sequencediagram.graphic.ConstraintSet;
import net.sourceforge.plantuml.sequencediagram.graphic.DrawableSet;
import net.sourceforge.plantuml.sequencediagram.graphic.Frontier;
import net.sourceforge.plantuml.sequencediagram.graphic.InGroupablesStack;
import net.sourceforge.plantuml.sequencediagram.graphic.LifeDestroy;
import net.sourceforge.plantuml.sequencediagram.graphic.LifeLine;
import net.sourceforge.plantuml.sequencediagram.graphic.LifeSegmentVariation;
import net.sourceforge.plantuml.sequencediagram.graphic.LivingParticipantBox;
import net.sourceforge.plantuml.sequencediagram.graphic.MessageSelfArrow;
import net.sourceforge.plantuml.sequencediagram.graphic.NoteBox;
import net.sourceforge.plantuml.sequencediagram.graphic.ParticipantRange;
import net.sourceforge.plantuml.skin.ArrowConfiguration;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class Step1Abstract {
    private final StringBounder stringBounder;
    private final DrawableSet drawingSet;
    private final AbstractMessage message;
    private Frontier freeY2;
    private ArrowConfiguration config;
    private Component note;
    private ParticipantRange range;

    Step1Abstract(ParticipantRange participantRange, StringBounder stringBounder, AbstractMessage abstractMessage, DrawableSet drawableSet, Frontier frontier) {
        if (frontier == null) {
            throw new IllegalArgumentException();
        }
        this.range = participantRange;
        this.stringBounder = stringBounder;
        this.message = abstractMessage;
        this.freeY2 = frontier;
        this.drawingSet = drawableSet;
    }

    protected final ParticipantRange getParticipantRange() {
        return this.range;
    }

    abstract Frontier prepareMessage(ConstraintSet var1, InGroupablesStack var2);

    protected final List<? extends CharSequence> getLabelOfMessage(AbstractMessage abstractMessage) {
        if (abstractMessage.getMessageNumber() == null) {
            return abstractMessage.getLabel();
        }
        ArrayList<CharSequence> arrayList = new ArrayList<CharSequence>();
        arrayList.add(new MessageNumber(abstractMessage.getMessageNumber()));
        arrayList.addAll(abstractMessage.getLabel());
        return arrayList;
    }

    protected final void beforeMessage(LifeEvent lifeEvent, double d) {
        Participant participant = lifeEvent.getParticipant();
        LifeLine lifeLine = this.drawingSet.getLivingParticipantBox(participant).getLifeLine();
        if (lifeEvent.getType() != LifeEventType.ACTIVATE) {
            return;
        }
        assert (lifeEvent.getType() == LifeEventType.ACTIVATE);
        int n = 0;
        if (this.message.isCreate()) {
            n += 10;
        }
        lifeLine.addSegmentVariation(LifeSegmentVariation.LARGER, d + (double)n, lifeEvent.getSpecificBackColor());
    }

    protected final void afterMessage(StringBounder stringBounder, LifeEvent lifeEvent, double d) {
        Participant participant = lifeEvent.getParticipant();
        LifeLine lifeLine = this.drawingSet.getLivingParticipantBox(participant).getLifeLine();
        if (lifeEvent.getType() == LifeEventType.ACTIVATE || lifeEvent.getType() == LifeEventType.CREATE) {
            return;
        }
        if (lifeEvent.getType() == LifeEventType.DESTROY) {
            Component component = this.drawingSet.getSkin().createComponent(ComponentType.DESTROY, null, this.drawingSet.getSkinParam(), null);
            double d2 = component.getPreferredHeight(stringBounder) / 2.0;
            LifeDestroy lifeDestroy = new LifeDestroy(d - d2, this.drawingSet.getLivingParticipantBox(participant).getParticipantBox(), component);
            if (this.lifelineAfterDestroy()) {
                lifeLine.setDestroy(d);
            }
            this.drawingSet.addEvent(lifeEvent, lifeDestroy);
        } else if (lifeEvent.getType() != LifeEventType.DEACTIVATE) {
            throw new IllegalStateException();
        }
        lifeLine.addSegmentVariation(LifeSegmentVariation.SMALLER, d, lifeEvent.getSpecificBackColor());
    }

    private boolean lifelineAfterDestroy() {
        String string = this.drawingSet.getSkinParam().getValue("lifelineafterdestroy");
        return false;
    }

    protected final ArrowConfiguration getConfig() {
        return this.config;
    }

    protected final void setConfig(ArrowConfiguration arrowConfiguration) {
        this.config = arrowConfiguration;
    }

    protected final Component getNote() {
        return this.note;
    }

    protected final void setNote(Component component) {
        this.note = component;
    }

    protected final StringBounder getStringBounder() {
        return this.stringBounder;
    }

    protected final AbstractMessage getMessage() {
        return this.message;
    }

    protected final DrawableSet getDrawingSet() {
        return this.drawingSet;
    }

    protected final Frontier getFreeY() {
        return this.freeY2;
    }

    protected final void incFreeY(double d) {
        this.freeY2 = this.freeY2.add(d, this.range);
    }

    protected final NoteBox createNoteBox(StringBounder stringBounder, Arrow arrow, Component component, NotePosition notePosition, Url url) {
        LivingParticipantBox livingParticipantBox = arrow.getParticipantAt(stringBounder, notePosition);
        NoteBox noteBox = new NoteBox(arrow.getStartingY(), component, livingParticipantBox, null, notePosition, url);
        if (arrow instanceof MessageSelfArrow && notePosition == NotePosition.RIGHT) {
            noteBox.pushToRight(arrow.getPreferredWidth(stringBounder));
        }
        return noteBox;
    }
}

