/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.graphic;

import java.util.Arrays;
import net.sourceforge.plantuml.SkinParamBackcolored;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.sequencediagram.InGroupable;
import net.sourceforge.plantuml.sequencediagram.LifeEvent;
import net.sourceforge.plantuml.sequencediagram.Message;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.graphic.Arrow;
import net.sourceforge.plantuml.sequencediagram.graphic.ArrowAndNoteBox;
import net.sourceforge.plantuml.sequencediagram.graphic.ArrowAndParticipant;
import net.sourceforge.plantuml.sequencediagram.graphic.ConstraintSet;
import net.sourceforge.plantuml.sequencediagram.graphic.DrawableSet;
import net.sourceforge.plantuml.sequencediagram.graphic.Frontier;
import net.sourceforge.plantuml.sequencediagram.graphic.GraphicalElement;
import net.sourceforge.plantuml.sequencediagram.graphic.InGroupablesStack;
import net.sourceforge.plantuml.sequencediagram.graphic.LivingParticipantBox;
import net.sourceforge.plantuml.sequencediagram.graphic.MessageArrow;
import net.sourceforge.plantuml.sequencediagram.graphic.MessageSelfArrow;
import net.sourceforge.plantuml.sequencediagram.graphic.NoteBox;
import net.sourceforge.plantuml.sequencediagram.graphic.ParticipantBox;
import net.sourceforge.plantuml.sequencediagram.graphic.ParticipantRange;
import net.sourceforge.plantuml.sequencediagram.graphic.Step1Abstract;
import net.sourceforge.plantuml.skin.ArrowConfiguration;
import net.sourceforge.plantuml.skin.ArrowDirection;
import net.sourceforge.plantuml.skin.ArrowHead;
import net.sourceforge.plantuml.skin.ComponentType;

class Step1Message
extends Step1Abstract {
    private final MessageArrow messageArrow;

    Step1Message(ParticipantRange participantRange, StringBounder stringBounder, Message message, DrawableSet drawableSet, Frontier frontier) {
        super(participantRange, stringBounder, message, drawableSet, frontier);
        double d = this.getParticipantBox1().getCenterX(stringBounder);
        double d2 = this.getParticipantBox2().getCenterX(stringBounder);
        this.setConfig(this.isSelfMessage() ? this.getSelfArrowType(message) : this.getArrowType(message, d, d2));
        this.messageArrow = this.isSelfMessage() ? null : new MessageArrow(frontier.getFreeY(participantRange), drawableSet.getSkin(), drawableSet.getSkin().createComponent(ComponentType.ARROW, this.getConfig(), drawableSet.getSkinParam(), this.getLabelOfMessage(message)), this.getLivingParticipantBox1(), this.getLivingParticipantBox2(), message.getUrl());
        if (message.getNote() != null) {
            SkinParamBackcolored skinParamBackcolored = new SkinParamBackcolored(drawableSet.getSkinParam(), message.getSpecificBackColor());
            this.setNote(drawableSet.getSkin().createComponent(ComponentType.NOTE, null, skinParamBackcolored, message.getNote()));
        }
    }

    Frontier prepareMessage(ConstraintSet constraintSet, InGroupablesStack inGroupablesStack) {
        Arrow arrow = this.createArrow();
        double d = arrow.getArrowYStartLevel(this.getStringBounder());
        double d2 = arrow.getArrowYEndLevel(this.getStringBounder());
        for (LifeEvent lifeEvent : this.getMessage().getLiveEvents()) {
            this.beforeMessage(lifeEvent, d + 0.0);
        }
        double d3 = this.isSelfMessage() ? arrow.getArrowOnlyWidth(this.getStringBounder()) + this.getLivingParticipantBox1().getLiveThicknessAt(this.getStringBounder(), d).getSegment().getLength() : arrow.getArrowOnlyWidth(this.getStringBounder()) + this.getLivingParticipantBox(NotePosition.LEFT).getLifeLine().getRightShift(d) + this.getLivingParticipantBox(NotePosition.RIGHT).getLifeLine().getLeftShift(d);
        this.incFreeY(arrow.getPreferredHeight(this.getStringBounder()));
        double d4 = 0.0;
        if (this.getMessage().isActivateAndDeactive()) {
            d4 = 30.0;
            this.incFreeY(d4);
        }
        this.getDrawingSet().addEvent(this.getMessage(), arrow);
        if (this.isSelfMessage()) {
            constraintSet.getConstraintAfter(this.getParticipantBox1()).ensureValue(d3);
        } else {
            constraintSet.getConstraint(this.getParticipantBox1(), this.getParticipantBox2()).ensureValue(d3);
        }
        for (LifeEvent lifeEvent : this.getMessage().getLiveEvents()) {
            this.afterMessage(this.getStringBounder(), lifeEvent, d2 + d4 - 0.0);
        }
        assert (arrow instanceof InGroupable);
        if (arrow instanceof InGroupable) {
            inGroupablesStack.addElement(arrow);
            inGroupablesStack.addElement(this.getLivingParticipantBox1());
            if (!this.isSelfMessage()) {
                inGroupablesStack.addElement(this.getLivingParticipantBox2());
            }
        }
        return this.getFreeY();
    }

    private boolean isSelfMessage() {
        return this.getParticipantBox1().equals(this.getParticipantBox2());
    }

    private ParticipantBox getParticipantBox1() {
        return this.getLivingParticipantBox1().getParticipantBox();
    }

    private ParticipantBox getParticipantBox2() {
        return this.getLivingParticipantBox2().getParticipantBox();
    }

    private LivingParticipantBox getLivingParticipantBox1() {
        return this.getDrawingSet().getLivingParticipantBox(((Message)this.getMessage()).getParticipant1());
    }

    private LivingParticipantBox getLivingParticipantBox2() {
        return this.getDrawingSet().getLivingParticipantBox(((Message)this.getMessage()).getParticipant2());
    }

    private LivingParticipantBox getLivingParticipantBox(NotePosition notePosition) {
        if (this.isSelfMessage()) {
            throw new IllegalStateException();
        }
        return this.messageArrow.getParticipantAt(this.getStringBounder(), notePosition);
    }

    private Arrow createArrow() {
        if (this.getMessage().isCreate()) {
            return this.createArrowCreate();
        }
        if (this.getMessage().getNote() != null && this.isSelfMessage()) {
            MessageSelfArrow messageSelfArrow = this.createMessageSelfArrow();
            NoteBox noteBox = this.createNoteBox(this.getStringBounder(), messageSelfArrow, this.getNote(), this.getMessage().getNotePosition(), this.getMessage().getUrlNote());
            return new ArrowAndNoteBox(this.getStringBounder(), messageSelfArrow, noteBox);
        }
        if (this.getMessage().getNote() != null) {
            NoteBox noteBox = this.createNoteBox(this.getStringBounder(), this.messageArrow, this.getNote(), this.getMessage().getNotePosition(), this.getMessage().getUrlNote());
            return new ArrowAndNoteBox(this.getStringBounder(), this.messageArrow, noteBox);
        }
        if (this.isSelfMessage()) {
            return this.createMessageSelfArrow();
        }
        return this.messageArrow;
    }

    private MessageSelfArrow createMessageSelfArrow() {
        double d = this.getFreeY().getFreeY(this.getParticipantRange());
        double d2 = 0.0;
        if (this.getMessage().isActivate()) {
            d2 -= this.getHalfLifeWidth();
        }
        if (this.getMessage().isDeactivate()) {
            d2 += this.getHalfLifeWidth();
        }
        return new MessageSelfArrow(d, this.getDrawingSet().getSkin(), this.getDrawingSet().getSkin().createComponent(ComponentType.ARROW, this.getConfig(), this.getDrawingSet().getSkinParam(), this.getLabelOfMessage(this.getMessage())), this.getLivingParticipantBox1(), d2, this.getMessage().getUrl());
    }

    private double getHalfLifeWidth() {
        return this.getDrawingSet().getSkin().createComponent(ComponentType.ALIVE_BOX_OPEN_OPEN, null, this.getDrawingSet().getSkinParam(), Arrays.asList("")).getPreferredWidth(null) / 2.0;
    }

    private Arrow createArrowCreate() {
        if (this.messageArrow == null) {
            throw new IllegalStateException();
        }
        Arrow arrow = new ArrowAndParticipant(this.getStringBounder(), this.messageArrow, this.getParticipantBox2());
        if (this.getMessage().getNote() != null) {
            NoteBox noteBox = this.createNoteBox(this.getStringBounder(), arrow, this.getNote(), this.getMessage().getNotePosition(), this.getMessage().getUrlNote());
            if (this.getMessage().getNotePosition() == NotePosition.RIGHT) {
                noteBox.pushToRight(this.getParticipantBox2().getPreferredWidth(this.getStringBounder()) / 2.0);
            }
            arrow = new ArrowAndNoteBox(this.getStringBounder(), arrow, noteBox);
        }
        this.getLivingParticipantBox2().create(this.getFreeY().getFreeY(this.getParticipantRange()) + ((GraphicalElement)arrow).getPreferredHeight(this.getStringBounder()) / 2.0);
        return arrow;
    }

    private ArrowConfiguration getSelfArrowType(Message message) {
        ArrowConfiguration arrowConfiguration = ArrowConfiguration.withDirection(ArrowDirection.SELF);
        if (message.getArrowConfiguration().isDotted()) {
            arrowConfiguration = arrowConfiguration.withDotted();
        }
        if (message.getArrowConfiguration().getHead() == ArrowHead.ASYNC) {
            arrowConfiguration = arrowConfiguration.withHead(ArrowHead.ASYNC);
        }
        arrowConfiguration = arrowConfiguration.withPart(message.getArrowConfiguration().getPart());
        return arrowConfiguration;
    }

    private ArrowConfiguration getArrowType(Message message, double d, double d2) {
        if (d2 > d) {
            return message.getArrowConfiguration();
        }
        return message.getArrowConfiguration().reverse();
    }
}

