/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.bluemodern;

import java.util.List;
import net.sourceforge.plantuml.SpriteContainer;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.skin.AbstractTextualComponent;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.bluemodern.FillRoundShape;
import net.sourceforge.plantuml.skin.bluemodern.ShadowShape;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentBlueModernParticipant
extends AbstractTextualComponent {
    private final int shadowview = 3;
    private final HtmlColor blue1;
    private final HtmlColor blue2;

    public ComponentBlueModernParticipant(HtmlColor htmlColor, HtmlColor htmlColor2, HtmlColor htmlColor3, UFont uFont, List<? extends CharSequence> list, SpriteContainer spriteContainer) {
        super(list, htmlColor3, uFont, HorizontalAlignement.CENTER, 7, 7, 7, spriteContainer);
        this.blue1 = htmlColor;
        this.blue2 = htmlColor2;
    }

    @Override
    protected void drawInternalU(UGraphic uGraphic, Area area) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        ShadowShape shadowShape = new ShadowShape(this.getTextWidth(stringBounder), this.getTextHeight(stringBounder), 10.0);
        uGraphic.translate(3.0, 3.0);
        uGraphic.getParam().setColor(null);
        shadowShape.drawU(uGraphic);
        uGraphic.translate(-3.0, -3.0);
        FillRoundShape fillRoundShape = new FillRoundShape(this.getTextWidth(stringBounder), this.getTextHeight(stringBounder), this.blue1, this.blue2, 10.0);
        fillRoundShape.drawU(uGraphic);
        this.getTextBlock().drawU(uGraphic, this.getMarginX1(), this.getMarginY());
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return this.getTextHeight(stringBounder) + 3.0;
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return this.getTextWidth(stringBounder);
    }
}

