/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.rose;

import java.util.List;
import net.sourceforge.plantuml.SpriteContainer;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.skin.AbstractTextualComponent;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.StickMan;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentRoseActor
extends AbstractTextualComponent {
    private final StickMan stickman;
    private final boolean head;

    public ComponentRoseActor(HtmlColor htmlColor, HtmlColor htmlColor2, HtmlColor htmlColor3, UFont uFont, List<? extends CharSequence> list, boolean bl, SpriteContainer spriteContainer, double d) {
        super(list, htmlColor3, uFont, HorizontalAlignement.CENTER, 3, 3, 0, spriteContainer);
        this.head = bl;
        this.stickman = new StickMan(htmlColor, htmlColor2);
        if (d > 0.0) {
            this.stickman.setDeltaShadow(d);
        }
    }

    @Override
    protected void drawInternalU(UGraphic uGraphic, Area area) {
        uGraphic.getParam().setColor(this.getFontColor());
        TextBlock textBlock = this.getTextBlock();
        StringBounder stringBounder = uGraphic.getStringBounder();
        double d = (this.getPreferredWidth(stringBounder) - this.stickman.getPreferredWidth(stringBounder)) / 2.0;
        if (this.head) {
            textBlock.drawU(uGraphic, this.getTextMiddlePostion(stringBounder), this.stickman.getPreferredHeight(stringBounder));
            uGraphic.translate(d, 0.0);
        } else {
            textBlock.drawU(uGraphic, this.getTextMiddlePostion(stringBounder), 0.0);
            uGraphic.translate(d, this.getTextHeight(stringBounder));
        }
        this.stickman.drawU(uGraphic);
    }

    private double getTextMiddlePostion(StringBounder stringBounder) {
        return (this.getPreferredWidth(stringBounder) - this.getTextWidth(stringBounder)) / 2.0;
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return this.stickman.getPreferredHeight(stringBounder) + this.getTextHeight(stringBounder);
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return Math.max(this.stickman.getPreferredWidth(stringBounder), this.getTextWidth(stringBounder));
    }
}

