/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.rose;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.List;
import net.sourceforge.plantuml.SpriteContainer;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.ArrowConfiguration;
import net.sourceforge.plantuml.skin.ArrowDecoration;
import net.sourceforge.plantuml.skin.ArrowHead;
import net.sourceforge.plantuml.skin.ArrowPart;
import net.sourceforge.plantuml.skin.rose.AbstractComponentRoseArrow;
import net.sourceforge.plantuml.ugraphic.AbstractShadowable;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentRoseArrow
extends AbstractComponentRoseArrow {
    private final HorizontalAlignement messagePosition;
    private final double spaceCrossX = 6.0;
    private final double diamCircle = 8.0;
    private final double thinCircle = 1.5;

    public ComponentRoseArrow(HtmlColor htmlColor, HtmlColor htmlColor2, UFont uFont, List<? extends CharSequence> list, ArrowConfiguration arrowConfiguration, HorizontalAlignement horizontalAlignement, SpriteContainer spriteContainer) {
        super(htmlColor, htmlColor2, uFont, list, arrowConfiguration, spriteContainer);
        this.messagePosition = horizontalAlignement;
    }

    @Override
    public void drawInternalU(UGraphic uGraphic, Area area) {
        double d;
        AbstractShadowable abstractShadowable;
        Dimension2D dimension2D = area.getDimensionToUse();
        StringBounder stringBounder = uGraphic.getStringBounder();
        int n = (int)this.getTextHeight(stringBounder);
        uGraphic.getParam().setColor(this.getForegroundColor());
        double d2 = dimension2D.getWidth() - 1.0;
        if (this.getArrowConfiguration().isDotted()) {
            this.stroke(uGraphic, 2.0, 2.0);
        }
        double d3 = 0.0;
        double d4 = d2;
        int n2 = this.getDirection();
        double d5 = n2 == 1 ? d2 - 1.0 : 2.0;
        ArrowDecoration arrowDecoration = this.getArrowConfiguration().getDecorationStart();
        if (arrowDecoration == ArrowDecoration.CIRCLE) {
            if (n2 == 1) {
                d3 += 4.0;
                d4 -= 4.0;
            } else if (n2 == -1) {
                d4 -= 4.0;
            }
        }
        ArrowDecoration arrowDecoration2 = this.getArrowConfiguration().getDecorationEnd();
        switch (arrowDecoration2) {
            case CROSSX: {
                if (n2 == 1) {
                    d4 -= 6.0 + (double)(this.getArrowDeltaX() / 2);
                    break;
                }
                if (n2 != -1) break;
                d3 += 6.0 + (double)(this.getArrowDeltaX() / 2);
                d4 -= 6.0 + (double)(this.getArrowDeltaX() / 2);
                break;
            }
            case CIRCLE: {
                if (n2 == 1) {
                    d4 -= 4.0;
                    d5 -= 5.5;
                    break;
                }
                if (n2 != -1) break;
                d3 += 4.0;
                d4 -= 4.0;
                d5 += 5.5;
            }
        }
        if (arrowDecoration2 != ArrowDecoration.CROSSX && this.getArrowConfiguration().getHead() == ArrowHead.NORMAL && this.getArrowConfiguration().getPart() == ArrowPart.FULL) {
            if (n2 == 1) {
                d4 -= (double)(this.getArrowDeltaX() / 2);
            } else if (n2 == -1) {
                d3 += (double)(this.getArrowDeltaX() / 2);
                d4 -= (double)(this.getArrowDeltaX() / 2);
            }
        }
        uGraphic.draw(d3, n, new ULine(d4, 0.0));
        if (this.getArrowConfiguration().isDotted()) {
            uGraphic.getParam().setStroke(new UStroke());
        }
        if (n2 == 1) {
            if (this.getArrowConfiguration().getHead() == ArrowHead.ASYNC) {
                if (this.getArrowConfiguration().getPart() != ArrowPart.BOTTOM_PART) {
                    uGraphic.draw(d5, n, new ULine(-this.getArrowDeltaX(), -this.getArrowDeltaY()));
                }
                if (this.getArrowConfiguration().getPart() != ArrowPart.TOP_PART) {
                    uGraphic.draw(d5, n, new ULine(-this.getArrowDeltaX(), this.getArrowDeltaY()));
                }
            } else if (arrowDecoration2 == ArrowDecoration.CROSSX) {
                uGraphic.getParam().setStroke(new UStroke(2.0));
                uGraphic.draw(d2 - (double)this.getArrowDeltaX() - 6.0, n - this.getArrowDeltaX() / 2, new ULine(this.getArrowDeltaX(), this.getArrowDeltaX()));
                uGraphic.draw(d2 - (double)this.getArrowDeltaX() - 6.0, n + this.getArrowDeltaX() / 2, new ULine(this.getArrowDeltaX(), -this.getArrowDeltaX()));
                uGraphic.getParam().setStroke(new UStroke());
            } else {
                uGraphic.getParam().setBackcolor(this.getForegroundColor());
                abstractShadowable = this.getPolygonNormal(n, d5);
                uGraphic.draw(0.0, 0.0, abstractShadowable);
                uGraphic.getParam().setBackcolor(null);
            }
            if (arrowDecoration == ArrowDecoration.CIRCLE) {
                uGraphic.getParam().setStroke(new UStroke(1.5));
                uGraphic.getParam().setColor(this.getForegroundColor());
                uGraphic.getParam().setBackcolor(null);
                abstractShadowable = new UEllipse(8.0, 8.0);
                uGraphic.draw(-4.5, (double)n - 4.0 - 0.75, abstractShadowable);
                uGraphic.getParam().setStroke(new UStroke());
            }
            if (arrowDecoration2 == ArrowDecoration.CIRCLE) {
                uGraphic.getParam().setStroke(new UStroke(1.5));
                uGraphic.getParam().setColor(this.getForegroundColor());
                uGraphic.getParam().setBackcolor(null);
                abstractShadowable = new UEllipse(8.0, 8.0);
                uGraphic.draw(d2 - 4.0 + 0.5, (double)n - 4.0 - 0.75, abstractShadowable);
                uGraphic.getParam().setStroke(new UStroke());
            }
        } else {
            if (this.getArrowConfiguration().getHead() == ArrowHead.ASYNC) {
                if (this.getArrowConfiguration().getPart() != ArrowPart.BOTTOM_PART) {
                    uGraphic.draw(d5 - 1.0, n, new ULine(this.getArrowDeltaX(), -this.getArrowDeltaY()));
                }
                if (this.getArrowConfiguration().getPart() != ArrowPart.TOP_PART) {
                    uGraphic.draw(d5 - 1.0, n, new ULine(this.getArrowDeltaX(), this.getArrowDeltaY()));
                }
            } else if (arrowDecoration2 == ArrowDecoration.CROSSX) {
                uGraphic.getParam().setStroke(new UStroke(2.0));
                uGraphic.draw(6.0, n - this.getArrowDeltaX() / 2, new ULine(this.getArrowDeltaX(), this.getArrowDeltaX()));
                uGraphic.draw(6.0, n + this.getArrowDeltaX() / 2, new ULine(this.getArrowDeltaX(), -this.getArrowDeltaX()));
                uGraphic.getParam().setStroke(new UStroke());
            } else {
                uGraphic.getParam().setBackcolor(this.getForegroundColor());
                abstractShadowable = this.getPolygonReverse(n);
                uGraphic.draw(d5, 0.0, abstractShadowable);
                uGraphic.getParam().setBackcolor(null);
            }
            if (arrowDecoration == ArrowDecoration.CIRCLE) {
                uGraphic.getParam().setStroke(new UStroke(1.5));
                uGraphic.getParam().setColor(this.getForegroundColor());
                uGraphic.getParam().setBackcolor(null);
                abstractShadowable = new UEllipse(8.0, 8.0);
                uGraphic.draw(d2 - 4.0 + 0.5, (double)n - 4.0 - 0.75, abstractShadowable);
                uGraphic.getParam().setStroke(new UStroke());
            }
            if (arrowDecoration2 == ArrowDecoration.CIRCLE) {
                uGraphic.getParam().setStroke(new UStroke(1.5));
                uGraphic.getParam().setColor(this.getForegroundColor());
                uGraphic.getParam().setBackcolor(null);
                abstractShadowable = new UEllipse(8.0, 8.0);
                uGraphic.draw(-4.5, (double)n - 4.0 - 0.75, abstractShadowable);
                uGraphic.getParam().setStroke(new UStroke());
            }
        }
        if (this.messagePosition == HorizontalAlignement.CENTER) {
            double d6 = this.getTextBlock().calculateDimension(stringBounder).getWidth();
            d = (dimension2D.getWidth() - d6) / 2.0;
        } else if (this.messagePosition == HorizontalAlignement.RIGHT) {
            double d7 = this.getTextBlock().calculateDimension(stringBounder).getWidth();
            d = dimension2D.getWidth() - d7 - (double)this.getMarginX2();
        } else {
            d = this.getMarginX1();
        }
        this.getTextBlock().drawU(uGraphic, d, 0.0);
    }

    private UPolygon getPolygonNormal(int n, double d) {
        UPolygon uPolygon = new UPolygon();
        if (this.getArrowConfiguration().getPart() == ArrowPart.TOP_PART) {
            uPolygon.addPoint(d - (double)this.getArrowDeltaX(), n - this.getArrowDeltaY());
            uPolygon.addPoint(d, n);
            uPolygon.addPoint(d - (double)this.getArrowDeltaX(), n);
        } else if (this.getArrowConfiguration().getPart() == ArrowPart.BOTTOM_PART) {
            uPolygon.addPoint(d - (double)this.getArrowDeltaX(), n + 1);
            uPolygon.addPoint(d, n + 1);
            uPolygon.addPoint(d - (double)this.getArrowDeltaX(), n + this.getArrowDeltaY() + 1);
        } else {
            uPolygon.addPoint(d - (double)this.getArrowDeltaX(), n - this.getArrowDeltaY());
            uPolygon.addPoint(d, n);
            uPolygon.addPoint(d - (double)this.getArrowDeltaX(), n + this.getArrowDeltaY());
        }
        return uPolygon;
    }

    private UPolygon getPolygonReverse(int n) {
        UPolygon uPolygon = new UPolygon();
        if (this.getArrowConfiguration().getPart() == ArrowPart.TOP_PART) {
            uPolygon.addPoint(this.getArrowDeltaX(), n - this.getArrowDeltaY());
            uPolygon.addPoint(0.0, n);
            uPolygon.addPoint(this.getArrowDeltaX(), n);
        } else if (this.getArrowConfiguration().getPart() == ArrowPart.BOTTOM_PART) {
            uPolygon.addPoint(this.getArrowDeltaX(), n + 1);
            uPolygon.addPoint(0.0, n + 1);
            uPolygon.addPoint(this.getArrowDeltaX(), n + this.getArrowDeltaY() + 1);
        } else {
            uPolygon.addPoint(this.getArrowDeltaX(), n - this.getArrowDeltaY());
            uPolygon.addPoint(0.0, n);
            uPolygon.addPoint(this.getArrowDeltaX(), n + this.getArrowDeltaY());
        }
        return uPolygon;
    }

    @Override
    public Point2D getStartPoint(StringBounder stringBounder, Dimension2D dimension2D) {
        int n = (int)this.getTextHeight(stringBounder);
        if (this.getDirection() == 1) {
            return new Point2D.Double(this.getPaddingX(), (double)n + this.getPaddingY());
        }
        return new Point2D.Double(dimension2D.getWidth() + this.getPaddingX(), (double)n + this.getPaddingY());
    }

    @Override
    public Point2D getEndPoint(StringBounder stringBounder, Dimension2D dimension2D) {
        int n = (int)this.getTextHeight(stringBounder);
        if (this.getDirection() == 1) {
            return new Point2D.Double(dimension2D.getWidth() + this.getPaddingX(), (double)n + this.getPaddingY());
        }
        return new Point2D.Double(this.getPaddingX(), (double)n + this.getPaddingY());
    }

    protected final int getDirection() {
        if (this.getArrowConfiguration().isLeftToRightNormal()) {
            return 1;
        }
        if (this.getArrowConfiguration().isRightToLeftReverse()) {
            return -1;
        }
        throw new IllegalStateException();
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return this.getTextHeight(stringBounder) + (double)this.getArrowDeltaY() + 2.0 * this.getPaddingY();
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return this.getTextWidth(stringBounder);
    }
}

