/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.rose;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.List;
import net.sourceforge.plantuml.SpriteContainer;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.ArrowConfiguration;
import net.sourceforge.plantuml.skin.ArrowHead;
import net.sourceforge.plantuml.skin.ArrowPart;
import net.sourceforge.plantuml.skin.rose.AbstractComponentRoseArrow;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentRoseSelfArrow
extends AbstractComponentRoseArrow {
    private final double arrowWidth = 45.0;

    public ComponentRoseSelfArrow(HtmlColor htmlColor, HtmlColor htmlColor2, UFont uFont, List<? extends CharSequence> list, ArrowConfiguration arrowConfiguration, SpriteContainer spriteContainer) {
        super(htmlColor, htmlColor2, uFont, list, arrowConfiguration, spriteContainer);
    }

    @Override
    protected void drawInternalU(UGraphic uGraphic, Area area) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        double d = this.getTextHeight(stringBounder);
        uGraphic.getParam().setColor(this.getForegroundColor());
        if (this.getArrowConfiguration().isDotted()) {
            this.stroke(uGraphic, 2.0, 2.0);
        }
        double d2 = area.getDeltaX1() < 0.0 ? area.getDeltaX1() : 0.0;
        double d3 = area.getDeltaX1() > 0.0 ? -area.getDeltaX1() : 0.0;
        uGraphic.draw(d2, d, new ULine(42.0 - d2, 0.0));
        double d4 = d + this.getArrowOnlyHeight(stringBounder);
        uGraphic.draw(42.0, d, new ULine(0.0, d4 - d));
        uGraphic.draw(d3, d4, new ULine(42.0 - d3, 0.0));
        if (this.getArrowConfiguration().isDotted()) {
            uGraphic.getParam().setStroke(new UStroke());
        }
        if (this.getArrowConfiguration().getHead() == ArrowHead.ASYNC) {
            if (this.getArrowConfiguration().getPart() != ArrowPart.BOTTOM_PART) {
                uGraphic.draw(d3, d4, new ULine(this.getArrowDeltaX(), -this.getArrowDeltaY()));
            }
            if (this.getArrowConfiguration().getPart() != ArrowPart.TOP_PART) {
                uGraphic.draw(d3, d4, new ULine(this.getArrowDeltaX(), this.getArrowDeltaY()));
            }
        } else {
            uGraphic.getParam().setBackcolor(this.getForegroundColor());
            UPolygon uPolygon = this.getPolygon(d4);
            uGraphic.draw(d3, 0.0, uPolygon);
            uGraphic.getParam().setBackcolor(null);
        }
        this.getTextBlock().drawU(uGraphic, this.getMarginX1(), 0.0);
    }

    private UPolygon getPolygon(double d) {
        UPolygon uPolygon = new UPolygon();
        if (this.getArrowConfiguration().getPart() == ArrowPart.TOP_PART) {
            uPolygon.addPoint(this.getArrowDeltaX(), d - (double)this.getArrowDeltaY());
            uPolygon.addPoint(0.0, d);
            uPolygon.addPoint(this.getArrowDeltaX(), d);
        } else if (this.getArrowConfiguration().getPart() == ArrowPart.BOTTOM_PART) {
            uPolygon.addPoint(this.getArrowDeltaX(), d);
            uPolygon.addPoint(0.0, d);
            uPolygon.addPoint(this.getArrowDeltaX(), d + (double)this.getArrowDeltaY());
        } else {
            uPolygon.addPoint(this.getArrowDeltaX(), d - (double)this.getArrowDeltaY());
            uPolygon.addPoint(0.0, d);
            uPolygon.addPoint(this.getArrowDeltaX(), d + (double)this.getArrowDeltaY());
        }
        return uPolygon;
    }

    @Override
    public Point2D getStartPoint(StringBounder stringBounder, Dimension2D dimension2D) {
        int n = (int)this.getTextHeight(stringBounder);
        return new Point2D.Double(this.getPaddingX(), (double)n + this.getPaddingY());
    }

    @Override
    public Point2D getEndPoint(StringBounder stringBounder, Dimension2D dimension2D) {
        int n = (int)this.getTextHeight(stringBounder);
        int n2 = (int)((double)n + this.getArrowOnlyHeight(stringBounder));
        return new Point2D.Double(this.getPaddingX(), (double)n2 + this.getPaddingY());
    }

    @Override
    public double getPreferredHeight(StringBounder stringBounder) {
        return this.getTextHeight(stringBounder) + (double)this.getArrowDeltaY() + this.getArrowOnlyHeight(stringBounder) + 2.0 * this.getPaddingY();
    }

    private double getArrowOnlyHeight(StringBounder stringBounder) {
        return 13.0;
    }

    @Override
    public double getPreferredWidth(StringBounder stringBounder) {
        return Math.max(this.getTextWidth(stringBounder), 45.0);
    }
}

