/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.statediagram.command;

import java.util.Map;
import java.util.StringTokenizer;
import net.sourceforge.plantuml.Direction;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexPartialMatch;
import net.sourceforge.plantuml.cucadiagram.EntityType;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LinkDecor;
import net.sourceforge.plantuml.cucadiagram.LinkType;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.statediagram.StateDiagram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandLinkState2
extends SingleLineCommand2<StateDiagram> {
    public CommandLinkState2(StateDiagram stateDiagram) {
        super(stateDiagram, CommandLinkState2.getRegex());
    }

    static RegexConcat getRegex() {
        return new RegexConcat(new RegexLeaf("^"), CommandLinkState2.getStatePattern("ENT1"), new RegexLeaf("\\s*"), new RegexLeaf("ARROW", "((-+)(left|right|up|down|le?|ri?|up?|do?)?(?:\\[((?:#\\w+|dotted|dashed|bold)(?:,#\\w+|,dotted|,dashed|,bold)*)\\])?(-*)\\>)"), new RegexLeaf("\\s*"), CommandLinkState2.getStatePattern("ENT2"), new RegexLeaf("\\s*"), new RegexLeaf("LABEL", "(?::\\s*([^\"]+))?"), new RegexLeaf("$"));
    }

    private static RegexLeaf getStatePattern(String string) {
        return new RegexLeaf(string, "([\\p{L}0-9_.]+|[\\p{L}0-9_.]+\\[H\\]|\\[\\*\\]|\\[H\\]|(?:==+)(?:[\\p{L}0-9_.]+)(?:==+))\\s*(\\<\\<.*\\>\\>)?\\s*(#\\w+)?");
    }

    @Override
    protected CommandExecutionResult executeArg(Map<String, RegexPartialMatch> map) {
        String string = map.get("ENT1").get(0);
        String string2 = map.get("ENT2").get(0);
        IEntity iEntity = this.getEntityStart(string);
        IEntity iEntity2 = this.getEntityEnd(string2);
        if (map.get("ENT1").get(1) != null) {
            iEntity.setStereotype(new Stereotype(map.get("ENT1").get(1)));
        }
        if (map.get("ENT1").get(2) != null) {
            iEntity.setSpecificBackcolor(HtmlColorUtils.getColorIfValid(map.get("ENT1").get(2)));
        }
        if (map.get("ENT2").get(1) != null) {
            iEntity2.setStereotype(new Stereotype(map.get("ENT2").get(1)));
        }
        if (map.get("ENT2").get(2) != null) {
            iEntity2.setSpecificBackcolor(HtmlColorUtils.getColorIfValid(map.get("ENT2").get(2)));
        }
        String string3 = map.get("ARROW").get(1) + map.get("ARROW").get(4);
        Direction direction = this.getDirection(map);
        if (direction == Direction.LEFT || direction == Direction.RIGHT) {
            string3 = "-";
        }
        int n = string3.length();
        Link link = new Link(iEntity, iEntity2, new LinkType(LinkDecor.ARROW, LinkDecor.NONE), map.get("LABEL").get(0), n);
        if (direction == Direction.LEFT || direction == Direction.UP) {
            link = link.getInv();
        }
        if (map.get("ARROW").get(3) != null) {
            StringTokenizer stringTokenizer = new StringTokenizer(map.get("ARROW").get(3), ",");
            while (stringTokenizer.hasMoreTokens()) {
                String string4 = stringTokenizer.nextToken();
                if (string4.equalsIgnoreCase("dashed")) {
                    link = link.getDashed();
                    continue;
                }
                if (string4.equalsIgnoreCase("bold")) {
                    link = link.getBold();
                    continue;
                }
                if (string4.equalsIgnoreCase("dotted")) {
                    link = link.getDotted();
                    continue;
                }
                link.setSpecificColor(string4);
            }
        }
        ((StateDiagram)this.getSystem()).addLink(link);
        return CommandExecutionResult.ok();
    }

    private Direction getDirection(Map<String, RegexPartialMatch> map) {
        if (map.get("ARROW").get(2) != null) {
            return StringUtils.getQueueDirection(map.get("ARROW").get(2));
        }
        return null;
    }

    private IEntity getEntityStart(String string) {
        if (string.startsWith("[*]")) {
            return ((StateDiagram)this.getSystem()).getStart();
        }
        if (string.equalsIgnoreCase("[H]")) {
            return ((StateDiagram)this.getSystem()).getHistorical();
        }
        if (string.endsWith("[H]")) {
            return ((StateDiagram)this.getSystem()).getHistorical(string.substring(0, string.length() - 3));
        }
        if (string.startsWith("=") && string.startsWith("=")) {
            string = this.removeEquals(string);
            return ((StateDiagram)this.getSystem()).getOrCreateEntity(string, EntityType.SYNCHRO_BAR);
        }
        return ((StateDiagram)this.getSystem()).getOrCreateClass(string);
    }

    private String removeEquals(String string) {
        while (string.startsWith("=")) {
            string = string.substring(1);
        }
        while (string.endsWith("=")) {
            string = string.substring(0, string.length() - 1);
        }
        return string;
    }

    private IEntity getEntityEnd(String string) {
        if (string.startsWith("[*]")) {
            return ((StateDiagram)this.getSystem()).getEnd();
        }
        if (string.endsWith("[H]")) {
            return ((StateDiagram)this.getSystem()).getHistorical(string.substring(0, string.length() - 3));
        }
        if (string.startsWith("=") && string.startsWith("=")) {
            string = this.removeEquals(string);
            return ((StateDiagram)this.getSystem()).getOrCreateEntity(string, EntityType.SYNCHRO_BAR);
        }
        return ((StateDiagram)this.getSystem()).getOrCreateClass(string);
    }
}

