/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.cucadiagram.EntityMutable;
import net.sourceforge.plantuml.cucadiagram.Group;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.Member;
import net.sourceforge.plantuml.cucadiagram.MethodsOrFieldsArea;
import net.sourceforge.plantuml.cucadiagram.dot.DotData;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockEmpty;
import net.sourceforge.plantuml.graphic.TextBlockWidth;
import net.sourceforge.plantuml.posimo.Moveable;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.svek.ClusterDecoration;
import net.sourceforge.plantuml.svek.ColorSequence;
import net.sourceforge.plantuml.svek.Line;
import net.sourceforge.plantuml.svek.PackageStyle;
import net.sourceforge.plantuml.svek.RoundedContainer;
import net.sourceforge.plantuml.svek.Shape;
import net.sourceforge.plantuml.svek.SvekUtils;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Cluster
implements Moveable {
    private final Cluster parent;
    private final Group group;
    private final List<Shape> shapes = new ArrayList<Shape>();
    private final List<Cluster> children = new ArrayList<Cluster>();
    private final boolean special;
    private final int color;
    private final int colorTitle;
    private final ISkinParam skinParam;
    private int titleWidth;
    private int titleHeight;
    private TextBlock title;
    private double xTitle;
    private double yTitle;
    private double minX;
    private double minY;
    private double maxX;
    private double maxY;
    public static final String CENTER_ID = "za";

    @Override
    public void moveSvek(double d, double d2) {
        this.xTitle += d;
        this.minX += d;
        this.maxX += d;
        this.yTitle += d2;
        this.minY += d2;
        this.maxY += d2;
    }

    public Cluster(ColorSequence colorSequence, ISkinParam iSkinParam) {
        this(null, null, false, colorSequence, iSkinParam);
    }

    private int getUid2() {
        return this.group.zgetUid2();
    }

    private Cluster(Cluster cluster, Group group, boolean bl, ColorSequence colorSequence, ISkinParam iSkinParam) {
        this.parent = cluster;
        this.group = group;
        this.special = bl;
        this.color = colorSequence.getValue();
        this.colorTitle = colorSequence.getValue();
        this.skinParam = iSkinParam;
    }

    public String toString() {
        return super.toString() + " " + this.group;
    }

    public final Cluster getParent() {
        return this.parent;
    }

    public void addShape(Shape shape) {
        if (shape == null) {
            throw new IllegalArgumentException();
        }
        this.shapes.add(shape);
        shape.setCluster(this);
    }

    public final List<Shape> getShapes() {
        return Collections.unmodifiableList(this.shapes);
    }

    private List<Shape> getShapesOrderedTop(Collection<Line> collection) {
        ArrayList<Shape> arrayList = new ArrayList<Shape>();
        HashSet<String> hashSet = new HashSet<String>();
        HashMap<String, Shape> hashMap = new HashMap<String, Shape>();
        for (Shape moveable : this.shapes) {
            hashMap.put(moveable.getUid(), moveable);
            if (!moveable.isTop()) continue;
            arrayList.add(moveable);
            hashSet.add(moveable.getUid());
        }
        for (Line line : collection) {
            Shape shape;
            if (hashSet.contains(line.getStartUid()) && (shape = (Shape)hashMap.get(line.getEndUid())) != null) {
                arrayList.add(0, shape);
            }
            if (!line.isInverted() || (shape = (Shape)hashMap.get(line.getStartUid())) == null) continue;
            arrayList.add(0, shape);
        }
        return arrayList;
    }

    private List<Shape> getShapesOrderedWithoutTop(Collection<Line> collection) {
        ArrayList<Shape> arrayList = new ArrayList<Shape>(this.shapes);
        HashSet<String> hashSet = new HashSet<String>();
        HashMap<String, Shape> hashMap = new HashMap<String, Shape>();
        Iterator<Object> iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Shape moveable = (Shape)iterator.next();
            hashMap.put(moveable.getUid(), moveable);
            if (!moveable.isTop()) continue;
            hashSet.add(moveable.getUid());
            iterator.remove();
        }
        for (Line line : collection) {
            Shape shape;
            if (hashSet.contains(line.getStartUid()) && (shape = (Shape)hashMap.get(line.getEndUid())) != null) {
                arrayList.remove(shape);
            }
            if (!line.isInverted() || (shape = (Shape)hashMap.get(line.getStartUid())) == null) continue;
            arrayList.remove(shape);
        }
        return arrayList;
    }

    public final List<Cluster> getChildren() {
        return Collections.unmodifiableList(this.children);
    }

    public Cluster createChild(Group group, int n, int n2, TextBlock textBlock, boolean bl, ColorSequence colorSequence, ISkinParam iSkinParam) {
        Cluster cluster = new Cluster(this, group, bl, colorSequence, iSkinParam);
        cluster.titleWidth = n;
        cluster.titleHeight = n2;
        cluster.title = textBlock;
        this.children.add(cluster);
        return cluster;
    }

    public final Group getGroup() {
        return this.group;
    }

    public final int getTitleWidth() {
        return this.titleWidth;
    }

    public final int getTitleHeight() {
        return this.titleHeight;
    }

    public double getWidth() {
        return this.maxX - this.minX;
    }

    public double getMinX() {
        return this.minX;
    }

    public void setTitlePosition(double d, double d2) {
        this.xTitle = d;
        this.yTitle = d2;
    }

    public void drawU(UGraphic uGraphic, double d, double d2, HtmlColor htmlColor, DotData dotData) {
        boolean bl;
        if (this.skinParam.useSwimlanes()) {
            this.drawSwinLinesState(uGraphic, d, d2, htmlColor, dotData);
            return;
        }
        boolean bl2 = bl = dotData.getUmlDiagramType() == UmlDiagramType.STATE;
        if (bl) {
            this.drawUState(uGraphic, d, d2, htmlColor, dotData);
            return;
        }
        PackageStyle packageStyle = this.group.zgetPackageStyle();
        if (packageStyle == null) {
            packageStyle = dotData.getSkinParam().getPackageStyle();
        }
        if (this.title != null) {
            HtmlColor htmlColor2 = Cluster.getStateBackColor(this.getBackColor(), dotData.getSkinParam(), this.group.zgetStereotype() == null ? null : this.group.zgetStereotype().getLabel());
            ClusterDecoration clusterDecoration = new ClusterDecoration(packageStyle, this.title, htmlColor2, this.minX, this.minY, this.maxX, this.maxY);
            clusterDecoration.drawU(uGraphic, d, d2, htmlColor, dotData.getSkinParam().shadowing());
            return;
        }
        URectangle uRectangle = new URectangle(this.maxX - this.minX, this.maxY - this.minY);
        if (dotData.getSkinParam().shadowing()) {
            uRectangle.setDeltaShadow(3.0);
        }
        HtmlColor htmlColor3 = Cluster.getStateBackColor(this.getBackColor(), dotData.getSkinParam(), this.group.zgetStereotype() == null ? null : this.group.zgetStereotype().getLabel());
        uGraphic.getParam().setBackcolor(htmlColor3);
        uGraphic.getParam().setColor(htmlColor);
        uGraphic.getParam().setStroke(new UStroke(2.0));
        uGraphic.draw(d + this.minX, d2 + this.minY, uRectangle);
        uGraphic.getParam().setStroke(new UStroke());
    }

    private void drawSwinLinesState(UGraphic uGraphic, double d, double d2, HtmlColor htmlColor, DotData dotData) {
        if (this.title != null) {
            this.title.drawU(uGraphic, d + this.xTitle, d2);
        }
        ULine uLine = new ULine(0.0, this.maxY - this.minY);
        uGraphic.getParam().setColor(htmlColor);
        uGraphic.draw(d + this.minX, d2, uLine);
        uGraphic.draw(d + this.maxX, d2, uLine);
    }

    private HtmlColor getColor(DotData dotData, ColorParam colorParam, String string) {
        return new Rose().getHtmlColor(dotData.getSkinParam(), colorParam, string);
    }

    private void drawUState(UGraphic uGraphic, double d, double d2, HtmlColor htmlColor, DotData dotData) {
        Dimension2DDouble dimension2DDouble = new Dimension2DDouble(this.maxX - this.minX, this.maxY - this.minY);
        double d3 = this.title == null ? 0.0 : this.title.calculateDimension(uGraphic.getStringBounder()).getHeight() + 5.0 + 5.0;
        HtmlColor htmlColor2 = this.getBackColor();
        if (htmlColor2 == null) {
            htmlColor2 = this.getColor(dotData, ColorParam.stateBackground, this.group.zgetStereotype() == null ? null : this.group.zgetStereotype().getLabel());
        }
        HtmlColor htmlColor3 = this.getColor(dotData, ColorParam.background, null);
        List<Member> list = ((IEntity)((Object)this.group)).getFieldsToDisplay();
        TextBlockWidth textBlockWidth = list.size() == 0 ? new TextBlockEmpty() : new MethodsOrFieldsArea(list, FontParam.STATE_ATTRIBUTE, dotData.getSkinParam());
        double d4 = textBlockWidth.calculateDimension(uGraphic.getStringBounder()).getHeight();
        RoundedContainer roundedContainer = new RoundedContainer(dimension2DDouble, d3, d4 + (double)(d4 > 0.0 ? 5 : 0), htmlColor, htmlColor2, htmlColor3);
        roundedContainer.drawU(uGraphic, d + this.minX, d2 + this.minY, dotData.getSkinParam().shadowing());
        if (this.title != null) {
            this.title.drawU(uGraphic, d + this.xTitle, d2 + this.yTitle);
        }
        if (d4 > 0.0) {
            textBlockWidth.drawU(uGraphic, d + this.minX + 5.0, d2 + this.minY + d3 + 2.5, ((Dimension2D)dimension2DDouble).getWidth());
        }
    }

    public void setPosition(double d, double d2, double d3, double d4) {
        this.minX = d;
        this.maxX = d3;
        this.minY = d2;
        this.maxY = d4;
    }

    public boolean isSpecial() {
        return this.special;
    }

    public void printCluster1(StringBuilder stringBuilder, Collection<Line> collection) {
        for (Shape shape : this.getShapesOrderedTop(collection)) {
            shape.appendShape(stringBuilder);
        }
    }

    public void printCluster2(StringBuilder stringBuilder, Collection<Line> collection) {
        HashSet<String> hashSet = new HashSet<String>();
        for (Line object : collection) {
            String string;
            String string2 = object.getStartUid();
            String string3 = object.getEndUid();
            if (!this.isInCluster(string2) || !this.isInCluster(string3) || (string = object.rankSame()) == null) continue;
            hashSet.add(string);
        }
        for (Shape shape : this.getShapesOrderedWithoutTop(collection)) {
            shape.appendShape(stringBuilder);
        }
        for (String string : hashSet) {
            stringBuilder.append(string);
            SvekUtils.println(stringBuilder);
        }
        for (Cluster cluster : this.getChildren()) {
            cluster.printInternal(stringBuilder, collection);
        }
    }

    public void fillRankMin(Set<String> set) {
        for (Shape moveable : this.getShapes()) {
            if (!moveable.isTop()) continue;
            set.add(moveable.getUid());
        }
        for (Cluster cluster : this.getChildren()) {
            cluster.fillRankMin(set);
        }
    }

    private boolean isInCluster(String string) {
        for (Shape shape : this.shapes) {
            if (!shape.getUid().equals(string)) continue;
            return true;
        }
        return false;
    }

    public String getClusterId() {
        return "cluster" + this.color;
    }

    public String getSpecialPointId() {
        return CENTER_ID + this.getUid2();
    }

    private boolean protection0() {
        return !this.skinParam.useSwimlanes();
    }

    private boolean protection1() {
        return !this.skinParam.useSwimlanes();
    }

    public String getMinPoint() {
        if (this.skinParam.useSwimlanes()) {
            return "minPoint" + this.color;
        }
        return null;
    }

    public String getMaxPoint() {
        if (this.skinParam.useSwimlanes()) {
            return "maxPoint" + this.color;
        }
        return null;
    }

    private String getSourceInPoint() {
        if (this.skinParam.useSwimlanes()) {
            return "sourceIn" + this.color;
        }
        return null;
    }

    private String getSinkInPoint() {
        if (this.skinParam.useSwimlanes()) {
            return "sinkIn" + this.color;
        }
        return null;
    }

    private void printInternal(StringBuilder stringBuilder, Collection<Line> collection) {
        if (this.isSpecial()) {
            this.subgraphCluster(stringBuilder, "a");
        }
        if (this.protection0()) {
            this.subgraphCluster(stringBuilder, "p0");
        }
        stringBuilder.append("subgraph " + this.getClusterId() + " {");
        stringBuilder.append("style=solid;");
        stringBuilder.append("color=\"" + StringUtils.getAsHtml(this.color) + "\";");
        int n = this.getTitleWidth();
        int n2 = this.getTitleHeight();
        if (n2 > 0 && n > 0) {
            stringBuilder.append("label=<");
            Line.appendTable(stringBuilder, n, n2 - 5, this.colorTitle);
            stringBuilder.append(">;");
        }
        SvekUtils.println(stringBuilder);
        if (this.isSpecial()) {
            stringBuilder.append(this.getSpecialPointId() + " [shape=point,width=.01,label=\"\"];");
            this.subgraphCluster(stringBuilder, "i");
        }
        if (this.protection1()) {
            this.subgraphCluster(stringBuilder, "p1");
        }
        if (this.skinParam.useSwimlanes()) {
            stringBuilder.append("{rank = source; ");
            stringBuilder.append(this.getSourceInPoint());
            stringBuilder.append(" [shape=point,width=.01,label=\"\"];");
            stringBuilder.append(this.getMinPoint() + "->" + this.getSourceInPoint() + "  [weight=999];");
            stringBuilder.append("}");
            SvekUtils.println(stringBuilder);
            stringBuilder.append("{rank = sink; ");
            stringBuilder.append(this.getSinkInPoint());
            stringBuilder.append(" [shape=point,width=.01,label=\"\"];");
            stringBuilder.append("}");
            stringBuilder.append(this.getSinkInPoint() + "->" + this.getMaxPoint() + "  [weight=999];");
            SvekUtils.println(stringBuilder);
        }
        SvekUtils.println(stringBuilder);
        this.printCluster1(stringBuilder, collection);
        this.printCluster2(stringBuilder, collection);
        if (this.protection1()) {
            stringBuilder.append("}");
        }
        if (this.isSpecial()) {
            stringBuilder.append("}");
        }
        stringBuilder.append("}");
        if (this.protection0()) {
            stringBuilder.append("}");
        }
        if (this.isSpecial()) {
            stringBuilder.append("}");
        }
        SvekUtils.println(stringBuilder);
    }

    private void subgraphCluster(StringBuilder stringBuilder, String string) {
        String string2 = this.getClusterId() + string;
        stringBuilder.append("subgraph " + string2 + " {");
        stringBuilder.append("style=invis;");
        stringBuilder.append("label=\"\";");
    }

    public int getColor() {
        return this.color;
    }

    public int getTitleColor() {
        return this.colorTitle;
    }

    private final HtmlColor getBackColor() {
        if (this.group == null) {
            return null;
        }
        HtmlColor htmlColor = this.group.zgetBackColor();
        if (htmlColor != null) {
            return htmlColor;
        }
        if (this.parent == null) {
            return null;
        }
        return this.parent.getBackColor();
    }

    public boolean isClusterOf(IEntity iEntity) {
        if (!((EntityMutable)iEntity).isGroup()) {
            return false;
        }
        return this.group == iEntity;
    }

    static HtmlColor getStateBackColor(HtmlColor htmlColor, ISkinParam iSkinParam, String string) {
        if (htmlColor == null) {
            htmlColor = iSkinParam.getHtmlColor(ColorParam.packageBackground, string);
        }
        if (htmlColor == null) {
            htmlColor = iSkinParam.getHtmlColor(ColorParam.background, string);
        }
        if (htmlColor == null) {
            htmlColor = HtmlColorUtils.WHITE;
        }
        return htmlColor;
    }
}

