/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.svek.PackageStyle;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPath;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;

public class ClusterDecoration {
    private final PackageStyle style;
    private final TextBlock title;
    private final HtmlColor stateBack;
    private final double minX;
    private final double minY;
    private final double maxX;
    private final double maxY;
    private final int cornersize = 10;
    public static final int marginTitleX1 = 3;
    public static final int marginTitleX2 = 3;
    public static final int marginTitleX3 = 7;
    public static final int marginTitleY0 = 0;
    public static final int marginTitleY1 = 3;
    public static final int marginTitleY2 = 3;

    public ClusterDecoration(PackageStyle packageStyle, TextBlock textBlock, HtmlColor htmlColor, double d, double d2, double d3, double d4) {
        this.style = packageStyle;
        this.title = textBlock;
        this.stateBack = htmlColor;
        this.minX = d;
        this.minY = d2;
        this.maxX = d3;
        this.maxY = d4;
    }

    public void drawU(UGraphic uGraphic, double d, double d2, HtmlColor htmlColor, boolean bl) {
        if (this.style == PackageStyle.NODE) {
            this.drawWithTitleNode(uGraphic, d, d2, htmlColor, bl);
        } else if (this.style == PackageStyle.DATABASE) {
            this.drawWithTitleDatabase(uGraphic, d, d2, htmlColor, bl);
        } else if (this.style == PackageStyle.CLOUD) {
            this.drawWithTitleCloud(uGraphic, d, d2, htmlColor, bl);
        } else if (this.style == PackageStyle.FRAME) {
            this.drawWithTitleCorner(uGraphic, d, d2, htmlColor, bl);
        } else if (this.style == PackageStyle.RECT) {
            this.drawWithTitleRect(uGraphic, d, d2, htmlColor, bl);
        } else {
            this.drawWithTitleFolder(uGraphic, d, d2, htmlColor, bl);
        }
    }

    private void drawWithTitleCloud(UGraphic uGraphic, double d, double d2, HtmlColor htmlColor, boolean bl) {
        Dimension2D dimension2D = this.title.calculateDimension(uGraphic.getStringBounder());
        double d3 = this.maxX - this.minX;
        double d4 = this.maxY - this.minY;
        UPath uPath = this.getSpecificFrontierForCloud(d3, d4);
        if (bl) {
            uPath.setDeltaShadow(3.0);
        }
        uGraphic.getParam().setBackcolor(this.stateBack);
        uGraphic.getParam().setColor(htmlColor);
        uGraphic.getParam().setStroke(new UStroke(2.0));
        uGraphic.draw(d + this.minX, d2 + this.minY, uPath);
        uGraphic.getParam().setStroke(new UStroke());
        this.title.drawU(uGraphic, d + this.minX + 3.0, d2 + this.minY + 10.0);
    }

    private UPath getSpecificFrontierForCloud(double d, double d2) {
        UPath uPath = new UPath();
        uPath.moveTo(0.0, 10.0);
        double d3 = 0.0;
        int n = 0;
        while ((double)n < d - 9.0) {
            uPath.cubicTo(0 + n, 7.0, 2 + n, 5.0, 5 + n, 5.0);
            uPath.cubicTo(8 + n, 5.0, 10 + n, 7.0, 10 + n, 10.0);
            d3 = n + 10;
            n += 10;
        }
        double d4 = 0.0;
        int n2 = 10;
        while ((double)n2 < d2 - 9.0) {
            uPath.cubicTo(d3 + 3.0, 0 + n2, d3 + 5.0, 2 + n2, d3 + 5.0, 5 + n2);
            uPath.cubicTo(d3 + 5.0, 8 + n2, d3 + 3.0, 10 + n2, d3, 10 + n2);
            d4 = n2 + 10;
            n2 += 10;
        }
        n2 = 0;
        while ((double)n2 < d - 9.0) {
            uPath.cubicTo(d3 - (double)n2, d4 + 3.0, d3 - 3.0 - (double)n2, d4 + 5.0, d3 - 5.0 - (double)n2, d4 + 5.0);
            uPath.cubicTo(d3 - 8.0 - (double)n2, d4 + 5.0, d3 - 10.0 - (double)n2, d4 + 3.0, d3 - 10.0 - (double)n2, d4);
            n2 += 10;
        }
        n2 = 0;
        while ((double)n2 < d2 - 9.0 - 10.0) {
            uPath.cubicTo(-3.0, d4 - (double)n2, -5.0, d4 - 2.0 - (double)n2, -5.0, d4 - 5.0 - (double)n2);
            uPath.cubicTo(-5.0, d4 - 8.0 - (double)n2, -3.0, d4 - 10.0 - (double)n2, 0.0, d4 - 10.0 - (double)n2);
            n2 += 10;
        }
        return uPath;
    }

    private void drawWithTitleDatabase(UGraphic uGraphic, double d, double d2, HtmlColor htmlColor, boolean bl) {
        Dimension2D dimension2D = this.title.calculateDimension(uGraphic.getStringBounder());
        double d3 = this.maxX - this.minX;
        double d4 = this.maxY - this.minY;
        UPath uPath = new UPath();
        if (bl) {
            uPath.setDeltaShadow(3.0);
        }
        uPath.moveTo(0.0, 0.0);
        uPath.cubicTo(10.0, -10.0, d3 / 2.0 - 10.0, -10.0, d3 / 2.0, -10.0);
        uPath.cubicTo(d3 / 2.0 + 10.0, -10.0, d3 - 10.0, -10.0, d3, 0.0);
        uPath.lineTo(d3, d4);
        uPath.cubicTo(d3 - 10.0, d4 + 10.0, d3 / 2.0 - 10.0, d4 + 10.0, d3 / 2.0, d4 + 10.0);
        uPath.cubicTo(d3 / 2.0 + 10.0, d4 + 10.0, 10.0, d4 + 10.0, 0.0, d4);
        uPath.lineTo(0.0, 0.0);
        uGraphic.getParam().setBackcolor(this.stateBack);
        uGraphic.getParam().setColor(htmlColor);
        uGraphic.getParam().setStroke(new UStroke(2.0));
        uGraphic.draw(d + this.minX, d2 + this.minY, uPath);
        UPath uPath2 = new UPath();
        uPath2.moveTo(0.0, 0.0);
        uPath2.cubicTo(10.0, 10.0, d3 / 2.0 - 10.0, 10.0, d3 / 2.0, 10.0);
        uPath2.cubicTo(d3 / 2.0 + 10.0, 10.0, d3 - 10.0, 10.0, d3, 0.0);
        uGraphic.draw(d + this.minX, d2 + this.minY, uPath2);
        uGraphic.getParam().setStroke(new UStroke());
        this.title.drawU(uGraphic, d + this.minX + 3.0, d2 + this.minY + 10.0);
    }

    private void drawWithTitleCorner(UGraphic uGraphic, double d, double d2, HtmlColor htmlColor, boolean bl) {
        Dimension2D dimension2D = this.title.calculateDimension(uGraphic.getStringBounder());
        double d3 = this.maxX - this.minX;
        double d4 = this.maxY - this.minY;
        URectangle uRectangle = new URectangle(d3, d4);
        if (bl) {
            uRectangle.setDeltaShadow(3.0);
        }
        uGraphic.getParam().setBackcolor(this.stateBack);
        uGraphic.getParam().setColor(htmlColor);
        uGraphic.getParam().setStroke(new UStroke(2.0));
        uGraphic.draw(d + this.minX, d2 + this.minY, uRectangle);
        double d5 = dimension2D.getWidth() + 10.0;
        double d6 = dimension2D.getHeight() + 3.0;
        UPath uPath = new UPath();
        uPath.moveTo(d5, 1.0);
        uPath.lineTo(d5, d6 - 10.0);
        uPath.lineTo(d5 - 10.0, d6);
        uPath.lineTo(0.0, d6);
        uGraphic.draw(d + this.minX, d2 + this.minY, uPath);
        uGraphic.getParam().setStroke(new UStroke());
        this.title.drawU(uGraphic, d + this.minX + 3.0, d2 + this.minY);
    }

    private void drawWithTitleNode(UGraphic uGraphic, double d, double d2, HtmlColor htmlColor, boolean bl) {
        UPolygon uPolygon = this.getSpecificFrontierForNode(uGraphic.getStringBounder());
        if (bl) {
            uPolygon.setDeltaShadow(3.0);
        }
        double d3 = this.maxX - this.minX;
        double d4 = this.maxY - this.minY;
        uGraphic.getParam().setBackcolor(this.stateBack);
        uGraphic.getParam().setColor(htmlColor);
        uGraphic.getParam().setStroke(new UStroke(2.0));
        uGraphic.draw(d + this.minX, d2 + this.minY, uPolygon);
        uGraphic.draw(d + this.minX + d3, d2 + this.minY + 10.0, new ULine(9.0, -9.0));
        UPath uPath = new UPath();
        uPath.moveTo(0.0, 0.0);
        uPath.lineTo(d3, 0.0);
        uPath.lineTo(d3, d4 - 10.0);
        uGraphic.draw(d + this.minX, d2 + this.minY + 10.0, uPath);
        uGraphic.getParam().setStroke(new UStroke());
        this.title.drawU(uGraphic, d + this.minX + 3.0, d2 + this.minY + 3.0 + 10.0);
    }

    private UPolygon getSpecificFrontierForNode(StringBounder stringBounder) {
        double d = this.maxX - this.minX;
        double d2 = this.maxY - this.minY;
        UPolygon uPolygon = new UPolygon();
        uPolygon.addPoint(0.0, 10.0);
        uPolygon.addPoint(10.0, 0.0);
        uPolygon.addPoint(d + 10.0, 0.0);
        uPolygon.addPoint(d + 10.0, d2 - 10.0);
        uPolygon.addPoint(d, d2);
        uPolygon.addPoint(0.0, d2);
        uPolygon.addPoint(0.0, 10.0);
        return uPolygon;
    }

    private UPolygon getSpecificFrontierForFolder(StringBounder stringBounder) {
        double d = this.maxX - this.minX;
        double d2 = this.maxY - this.minY;
        Dimension2D dimension2D = this.title.calculateDimension(stringBounder);
        double d3 = dimension2D.getWidth() + 3.0 + 3.0;
        double d4 = dimension2D.getHeight() + 3.0 + 3.0;
        UPolygon uPolygon = new UPolygon();
        uPolygon.addPoint(0.0, 0.0);
        uPolygon.addPoint(d3, 0.0);
        uPolygon.addPoint(d3 + 7.0, d4);
        uPolygon.addPoint(d, d4);
        uPolygon.addPoint(d, d2);
        uPolygon.addPoint(0.0, d2);
        uPolygon.addPoint(0.0, 0.0);
        return uPolygon;
    }

    private void drawWithTitleFolder(UGraphic uGraphic, double d, double d2, HtmlColor htmlColor, boolean bl) {
        Dimension2D dimension2D = this.title.calculateDimension(uGraphic.getStringBounder());
        double d3 = dimension2D.getWidth() + 3.0 + 3.0;
        double d4 = dimension2D.getHeight() + 3.0 + 3.0;
        UPolygon uPolygon = this.getSpecificFrontierForFolder(uGraphic.getStringBounder());
        if (bl) {
            uPolygon.setDeltaShadow(3.0);
        }
        uGraphic.getParam().setBackcolor(this.stateBack);
        uGraphic.getParam().setColor(htmlColor);
        uGraphic.getParam().setStroke(new UStroke(2.0));
        uGraphic.draw(d + this.minX, d2 + this.minY, uPolygon);
        uGraphic.draw(d + this.minX, d2 + this.minY + d4, new ULine(d3 + 7.0, 0.0));
        uGraphic.getParam().setStroke(new UStroke());
        this.title.drawU(uGraphic, d + this.minX + 3.0, d2 + this.minY + 3.0);
    }

    private void drawWithTitleRect(UGraphic uGraphic, double d, double d2, HtmlColor htmlColor, boolean bl) {
        Dimension2D dimension2D = this.title.calculateDimension(uGraphic.getStringBounder());
        double d3 = this.maxX - this.minX;
        double d4 = this.maxY - this.minY;
        URectangle uRectangle = new URectangle(d3, d4);
        if (bl) {
            uRectangle.setDeltaShadow(3.0);
        }
        uGraphic.getParam().setBackcolor(this.stateBack);
        uGraphic.getParam().setColor(htmlColor);
        uGraphic.getParam().setStroke(new UStroke(2.0));
        uGraphic.draw(d + this.minX, d2 + this.minY, uRectangle);
        uGraphic.getParam().setStroke(new UStroke());
        double d5 = d3 - dimension2D.getWidth();
        this.title.drawU(uGraphic, d + this.minX + d5 / 2.0, d2 + this.minY + 5.0);
    }
}

