/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.Color;
import java.awt.geom.Dimension2D;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.EmptyImageBuilder;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.cucadiagram.EntityType;
import net.sourceforge.plantuml.cucadiagram.EntityUtils;
import net.sourceforge.plantuml.cucadiagram.Group;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.Member;
import net.sourceforge.plantuml.cucadiagram.MethodsOrFieldsArea;
import net.sourceforge.plantuml.cucadiagram.dot.DotData;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.GraphicStrings;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.StringBounderUtils;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockEmpty;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.TextBlockWidth;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.svek.Bibliotekon;
import net.sourceforge.plantuml.svek.Cluster;
import net.sourceforge.plantuml.svek.ColorSequence;
import net.sourceforge.plantuml.svek.DotStringFactory;
import net.sourceforge.plantuml.svek.EntityImageNote;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.Line;
import net.sourceforge.plantuml.svek.Shape;
import net.sourceforge.plantuml.svek.SvekResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class CucaDiagramFileMakerSvek2 {
    private final ColorSequence colorSequence = new ColorSequence();
    private final DotData dotData;
    private static final StringBounder stringBounder;
    private DotStringFactory dotStringFactory;

    public CucaDiagramFileMakerSvek2(DotData dotData) {
        this.dotData = dotData;
    }

    public Bibliotekon getBibliotekon() {
        return this.dotStringFactory.getBibliotekon();
    }

    /*
     * WARNING - void declaration
     */
    public IEntityImage createFile(String ... stringArray) throws IOException, InterruptedException {
        void var3_6;
        Object object;
        this.dotStringFactory = new DotStringFactory(this.colorSequence, stringBounder, this.dotData);
        this.printGroups(null);
        this.printEntities(this.getUnpackagedEntities());
        for (Link object22 : this.dotData.getLinks()) {
            try {
                Shape shape;
                Object object2;
                Object object3;
                object = this.getBibliotekon().getShapeUid(object22.getEntity1());
                String string = this.getBibliotekon().getShapeUid(object22.getEntity2());
                String string2 = null;
                if (((String)object).startsWith("za")) {
                    object3 = EntityUtils.getContainerOrEquivalent(object22.getEntity1());
                    string2 = this.getCluster((Group)object3).getClusterId();
                }
                object3 = null;
                if (string.startsWith("za")) {
                    object2 = EntityUtils.getContainerOrEquivalent(object22.getEntity2());
                    object3 = this.getCluster((Group)object2).getClusterId();
                }
                object2 = new FontConfiguration(this.dotData.getSkinParam().getFont(FontParam.ACTIVITY_ARROW, null), HtmlColorUtils.BLACK);
                Line line = new Line((String)object, string, object22, this.colorSequence, string2, (String)object3, this.dotData.getSkinParam(), stringBounder, (FontConfiguration)object2, this.getBibliotekon());
                this.getBibliotekon().addLine(line);
                if (object22.getEntity1().getEntityType() == EntityType.NOTE && this.onlyOneLink(object22.getEntity1())) {
                    shape = this.getBibliotekon().getShape(object22.getEntity1());
                    ((EntityImageNote)shape.getImage()).setOpaleLine(line, shape);
                    line.setOpale(true);
                    continue;
                }
                if (object22.getEntity2().getEntityType() != EntityType.NOTE || !this.onlyOneLink(object22.getEntity2())) continue;
                shape = this.getBibliotekon().getShape(object22.getEntity2());
                ((EntityImageNote)shape.getImage()).setOpaleLine(line, shape);
                line.setOpale(true);
            }
            catch (IllegalStateException illegalStateException) {
                illegalStateException.printStackTrace();
            }
        }
        if (this.dotStringFactory.illegalDotExe()) {
            return this.error(this.dotStringFactory.getDotExe());
        }
        Dimension2D dimension2D = Dimension2DDouble.delta(this.dotStringFactory.solve(stringArray), 10.0);
        if (this.dotData.getUmlDiagramType() == UmlDiagramType.STATE) {
            HtmlColor htmlColor = this.getColor(ColorParam.stateBorder, null);
        } else {
            HtmlColor htmlColor = this.getColor(ColorParam.packageBorder, null);
        }
        object = new SvekResult(dimension2D, this.dotData, this.dotStringFactory, (HtmlColor)var3_6);
        ((SvekResult)object).moveSvek(6.0, 0.0);
        return object;
    }

    private boolean onlyOneLink(IEntity iEntity) {
        return Link.onlyOneLink(iEntity, this.dotData.getLinks());
    }

    protected final HtmlColor getColor(ColorParam colorParam, String string) {
        return new Rose().getHtmlColor(this.dotData.getSkinParam(), colorParam, string);
    }

    private Cluster getCluster(Group group) {
        for (Cluster cluster : this.getBibliotekon().allCluster()) {
            if (!EntityUtils.equals(cluster.getGroup(), group)) continue;
            return cluster;
        }
        throw new IllegalArgumentException(group.toString());
    }

    private IEntityImage error(File file) {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("Dot Executable: " + file);
        if (file != null) {
            if (!file.exists()) {
                arrayList.add("File does not exist");
            } else if (file.isDirectory()) {
                arrayList.add("It should be an executable, not a directory");
            } else if (!file.isFile()) {
                arrayList.add("Not a valid file");
            } else if (!file.canRead()) {
                arrayList.add("File cannot be read");
            }
        }
        arrayList.add("Cannot find Graphviz. You should try");
        arrayList.add(" ");
        arrayList.add("@startuml");
        arrayList.add("testdot");
        arrayList.add("@enduml");
        arrayList.add(" ");
        arrayList.add(" or ");
        arrayList.add(" ");
        arrayList.add("java -jar plantuml.jar -testdot");
        return new GraphicStrings(arrayList);
    }

    private void printEntities(Collection<? extends IEntity> collection) {
        for (IEntity iEntity : collection) {
            this.printEntity(iEntity);
        }
    }

    private void printEntity(IEntity iEntity) {
        IEntityImage iEntityImage = Shape.printEntity(iEntity, this.dotData);
        Dimension2D dimension2D = iEntityImage.getDimension(stringBounder);
        Shape shape = new Shape(iEntityImage, iEntityImage.getShapeType(), dimension2D.getWidth(), dimension2D.getHeight(), this.colorSequence, iEntity.isTop(), iEntityImage.getShield(), iEntity.getUrls());
        this.dotStringFactory.addShape(shape);
        this.getBibliotekon().putShape(iEntity, shape);
    }

    private Collection<IEntity> getUnpackagedEntities() {
        ArrayList<IEntity> arrayList = new ArrayList<IEntity>();
        for (IEntity iEntity : this.dotData.getEntities()) {
            if (!EntityUtils.equals(EntityUtils.getContainerOrEquivalent(iEntity), this.dotData.getTopParent())) continue;
            arrayList.add(iEntity);
        }
        return arrayList;
    }

    private void printGroups(Group group) throws IOException {
        for (Group group2 : this.dotData.getGroupHierarchy().getChildrenGroups(group)) {
            if (this.dotData.isEmpty(group2) && group2.zgetGroupType() == GroupType.PACKAGE) {
                IEntity iEntity = this.dotData.getEntityFactory().createEntity(group2.zgetUid1(), group2.zgetUid2(), group2.zgetGroupCode(), group2.zgetDisplay(), EntityType.EMPTY_PACKAGE, null, null);
                iEntity.setSpecificBackcolor(group2.zgetBackColor());
                this.printEntity(iEntity);
                continue;
            }
            this.printGroup(group2);
        }
    }

    private void printGroup(Group group) throws IOException {
        if (group.zgetGroupType() == GroupType.CONCURRENT_STATE) {
            return;
        }
        int n = 0;
        int n2 = 0;
        String string = group.zgetDisplay();
        TextBlock textBlock = null;
        if (string != null) {
            FontParam fontParam = group.zgetGroupType() == GroupType.STATE ? FontParam.STATE : FontParam.PACKAGE;
            String string2 = group.zgetStereotype() == null ? null : group.zgetStereotype().getLabel();
            textBlock = TextBlockUtils.create(StringUtils.getWithNewlines(string), new FontConfiguration(this.dotData.getSkinParam().getFont(fontParam, string2), this.dotData.getSkinParam().getFontHtmlColor(fontParam, string2)), HorizontalAlignement.CENTER, this.dotData.getSkinParam());
            Dimension2D dimension2D = textBlock.calculateDimension(stringBounder);
            List<Member> list = ((IEntity)((Object)group)).getFieldsToDisplay();
            TextBlockWidth textBlockWidth = list.size() == 0 ? new TextBlockEmpty() : new MethodsOrFieldsArea(list, FontParam.STATE_ATTRIBUTE, this.dotData.getSkinParam());
            double d = textBlockWidth.calculateDimension(stringBounder).getHeight();
            double d2 = d > 0.0 ? 5.0 : 0.0;
            n = (int)dimension2D.getWidth();
            n2 = (int)(dimension2D.getHeight() + d + d2);
        }
        this.dotStringFactory.openCluster(group, n, n2, textBlock, this.isSpecialGroup(group));
        this.printEntities(group.zentities());
        this.printGroups(group);
        this.dotStringFactory.closeCluster();
    }

    private boolean isSpecialGroup(Group group) {
        if (group.zgetGroupType() == GroupType.STATE) {
            return true;
        }
        if (group.zgetGroupType() == GroupType.CONCURRENT_STATE) {
            throw new IllegalStateException();
        }
        return this.dotData.isThereLink(group);
    }

    static {
        EmptyImageBuilder emptyImageBuilder = new EmptyImageBuilder(10, 10, Color.WHITE);
        stringBounder = StringBounderUtils.asStringBounder(emptyImageBuilder.getGraphics2D());
    }
}

