/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import net.sourceforge.plantuml.graphic.UDrawable3;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPolygon;

class Diamond
implements UDrawable3 {
    private int radius;
    private final Point2D center;
    private final Point2D p1;
    private final Point2D p2;
    private Point2D p3;
    private Point2D p4;
    private final boolean fill;
    private final double delta = 0.7;

    public Diamond(Point2D point2D, Point2D point2D2, boolean bl) {
        this.center = new Point2D.Double((point2D.getX() + point2D2.getX()) / 2.0, (point2D.getY() + point2D2.getY()) / 2.0);
        AffineTransform affineTransform = AffineTransform.getTranslateInstance(-this.center.getX(), -this.center.getY());
        AffineTransform affineTransform2 = AffineTransform.getTranslateInstance(this.center.getX(), this.center.getY());
        this.radius = (int)(point2D.distance(point2D2) / 2.0);
        if (this.radius % 2 == 0) {
            --this.radius;
        }
        this.p1 = point2D;
        this.p2 = point2D2;
        this.p3 = affineTransform.transform(this.p1, null);
        this.p3 = new Point2D.Double(this.p3.getY() * 0.7, -this.p3.getX() * 0.7);
        this.p3 = affineTransform2.transform(this.p3, null);
        this.p4 = affineTransform.transform(this.p2, null);
        this.p4 = new Point2D.Double(this.p4.getY() * 0.7, -this.p4.getX() * 0.7);
        this.p4 = affineTransform2.transform(this.p4, null);
        this.fill = bl;
    }

    public void drawU(UGraphic uGraphic, double d, double d2) {
        UPolygon uPolygon = new UPolygon();
        uPolygon.addPoint(this.p1.getX(), this.p1.getY());
        uPolygon.addPoint(this.p3.getX(), this.p3.getY());
        uPolygon.addPoint(this.p2.getX(), this.p2.getY());
        uPolygon.addPoint(this.p4.getX(), this.p4.getY());
        if (this.fill) {
            uGraphic.getParam().setBackcolor(uGraphic.getParam().getColor());
        }
        uGraphic.draw(d, d2, uPolygon);
        uGraphic.getParam().setBackcolor(null);
    }

    private static void drawLine(UGraphic uGraphic, double d, double d2, Point2D point2D, Point2D point2D2) {
        double d3 = point2D2.getX() - point2D.getX();
        double d4 = point2D2.getY() - point2D.getY();
        uGraphic.draw(d + point2D.getX(), d2 + point2D.getY(), new ULine(d3, d4));
    }
}

