/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.geom.Dimension2D;
import java.util.List;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.skin.StickMan;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.UGraphic;

public class EntityImageActor
extends AbstractEntityImage {
    private final StickMan stickman;
    private final TextBlock name;
    private final TextBlock stereo;
    private final List<Url> url;

    public EntityImageActor(IEntity iEntity, ISkinParam iSkinParam) {
        super(iEntity, iSkinParam);
        Stereotype stereotype = iEntity.getStereotype();
        this.name = TextBlockUtils.create(iEntity.getDisplay2(), new FontConfiguration(this.getFont(FontParam.USECASE_ACTOR, stereotype), this.getFontColor(FontParam.USECASE_ACTOR, stereotype)), HorizontalAlignement.CENTER, iSkinParam);
        this.stickman = new StickMan(this.getColor(ColorParam.usecaseActorBackground, this.getStereo()), this.getColor(ColorParam.usecaseActorBorder, this.getStereo()));
        if (iSkinParam.shadowing()) {
            this.stickman.setDeltaShadow(4.0);
        }
        this.stereo = stereotype == null || stereotype.getLabel() == null ? null : TextBlockUtils.create(StringUtils.getWithNewlines(stereotype.getLabel()), new FontConfiguration(this.getFont(FontParam.USECASE_ACTOR_STEREOTYPE, stereotype), this.getFontColor(FontParam.USECASE_ACTOR_STEREOTYPE, null)), HorizontalAlignement.CENTER, iSkinParam);
        this.url = iEntity.getUrls();
    }

    public Dimension2D getDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = this.name.calculateDimension(stringBounder);
        Dimension2D dimension2D2 = this.getStereoDimension(stringBounder);
        Dimension2DDouble dimension2DDouble = new Dimension2DDouble(this.stickman.getPreferredWidth(stringBounder), this.stickman.getPreferredHeight(stringBounder));
        return Dimension2DDouble.mergeLayoutT12B3(dimension2D2, dimension2DDouble, dimension2D);
    }

    private Dimension2D getStereoDimension(StringBounder stringBounder) {
        if (this.stereo == null) {
            return new Dimension2DDouble(0.0, 0.0);
        }
        return this.stereo.calculateDimension(stringBounder);
    }

    public void drawU(UGraphic uGraphic, double d, double d2) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        Dimension2D dimension2D = this.getStereoDimension(stringBounder);
        Dimension2D dimension2D2 = this.getDimension(stringBounder);
        Dimension2D dimension2D3 = this.name.calculateDimension(stringBounder);
        double d3 = uGraphic.getTranslateX();
        double d4 = uGraphic.getTranslateY();
        double d5 = (dimension2D2.getWidth() - this.stickman.getPreferredWidth(stringBounder)) / 2.0;
        double d6 = dimension2D.getHeight();
        if (this.url.size() > 0) {
            uGraphic.startUrl(this.url.get(0));
        }
        uGraphic.translate(d + d5, d2 + d6);
        this.stickman.drawU(uGraphic);
        uGraphic.setTranslate(d3, d4);
        double d7 = (dimension2D2.getWidth() - dimension2D3.getWidth()) / 2.0;
        double d8 = this.stickman.getPreferredHeight(stringBounder) + dimension2D.getHeight();
        this.name.drawU(uGraphic, d + d7, d2 + d8);
        if (this.stereo != null) {
            double d9 = (dimension2D2.getWidth() - dimension2D.getWidth()) / 2.0;
            this.stereo.drawU(uGraphic, d + d9, d2);
        }
        if (this.url.size() > 0) {
            uGraphic.closeAction();
        }
    }

    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }

    public int getShield() {
        return 0;
    }
}

