/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.geom.Dimension2D;
import java.util.List;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.UEllipse;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;

public class EntityImageCircleInterface
extends AbstractEntityImage {
    private static final int SIZE = 16;
    private final TextBlock name;
    private final TextBlock stereo;
    private final List<Url> url;

    public EntityImageCircleInterface(IEntity iEntity, ISkinParam iSkinParam) {
        super(iEntity, iSkinParam);
        Stereotype stereotype = iEntity.getStereotype();
        this.name = TextBlockUtils.create(iEntity.getDisplay2(), new FontConfiguration(this.getFont(FontParam.COMPONENT, stereotype), this.getFontColor(FontParam.COMPONENT, stereotype)), HorizontalAlignement.CENTER, iSkinParam);
        this.stereo = stereotype == null || stereotype.getLabel() == null ? null : TextBlockUtils.create(StringUtils.getWithNewlines(stereotype.getLabel()), new FontConfiguration(this.getFont(FontParam.COMPONENT_STEREOTYPE, stereotype), this.getFontColor(FontParam.COMPONENT_STEREOTYPE, null)), HorizontalAlignement.CENTER, iSkinParam);
        this.url = iEntity.getUrls();
    }

    public Dimension2D getDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = this.name.calculateDimension(stringBounder);
        Dimension2D dimension2D2 = this.getStereoDimension(stringBounder);
        Dimension2DDouble dimension2DDouble = new Dimension2DDouble(16.0, 16.0);
        return Dimension2DDouble.mergeLayoutT12B3(dimension2D2, dimension2DDouble, dimension2D);
    }

    private Dimension2D getStereoDimension(StringBounder stringBounder) {
        if (this.stereo == null) {
            return new Dimension2DDouble(0.0, 0.0);
        }
        return this.stereo.calculateDimension(stringBounder);
    }

    public void drawU(UGraphic uGraphic, double d, double d2) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        Dimension2D dimension2D = this.getStereoDimension(stringBounder);
        Dimension2D dimension2D2 = this.getDimension(stringBounder);
        Dimension2D dimension2D3 = this.name.calculateDimension(stringBounder);
        double d3 = (dimension2D2.getWidth() - 16.0) / 2.0;
        double d4 = dimension2D.getHeight();
        UEllipse uEllipse = new UEllipse(16.0, 16.0);
        if (this.getSkinParam().shadowing()) {
            uEllipse.setDeltaShadow(4.0);
        }
        uGraphic.getParam().setStroke(new UStroke(2.0));
        uGraphic.getParam().setColor(this.getColor(ColorParam.componentInterfaceBorder, this.getStereo()));
        uGraphic.getParam().setBackcolor(this.getColor(ColorParam.componentInterfaceBackground, this.getStereo()));
        if (this.url.size() > 0) {
            uGraphic.startUrl(this.url.get(0));
        }
        uGraphic.draw(d + d3, d2 + d4, uEllipse);
        uGraphic.getParam().setStroke(new UStroke());
        double d5 = (dimension2D2.getWidth() - dimension2D3.getWidth()) / 2.0;
        double d6 = 16.0 + dimension2D.getHeight();
        this.name.drawU(uGraphic, d + d5, d2 + d6);
        if (this.stereo != null) {
            double d7 = (dimension2D2.getWidth() - dimension2D.getWidth()) / 2.0;
            this.stereo.drawU(uGraphic, d + d7, d2);
        }
        if (this.url.size() > 0) {
            uGraphic.closeAction();
        }
    }

    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }

    public int getShield() {
        return 0;
    }
}

