/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.geom.Dimension2D;
import java.util.Arrays;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.cucadiagram.EntityPortion;
import net.sourceforge.plantuml.cucadiagram.EntityType;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.PortionShower;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.CircledCharacter;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockGeneric;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.HeaderLayout;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;

public class EntityImageClassHeader2
extends AbstractEntityImage {
    private final HeaderLayout headerLayout;

    public EntityImageClassHeader2(IEntity iEntity, ISkinParam iSkinParam, PortionShower portionShower) {
        super(iEntity, iSkinParam);
        Object object;
        TextBlock textBlock;
        boolean bl = iEntity.getEntityType() == EntityType.ABSTRACT_CLASS || iEntity.getEntityType() == EntityType.INTERFACE;
        HtmlColor htmlColor = this.getFontColor(FontParam.CLASS, this.getStereo());
        Stereotype stereotype = iEntity.getStereotype();
        String string = iEntity.getGeneric();
        FontConfiguration fontConfiguration = new FontConfiguration(this.getFont(FontParam.CLASS, stereotype), htmlColor);
        if (bl) {
            fontConfiguration = fontConfiguration.italic();
        }
        TextBlock textBlock2 = TextBlockUtils.withMargin(TextBlockUtils.create(iEntity.getDisplay2(), fontConfiguration, HorizontalAlignement.CENTER, iSkinParam), 3.0, 3.0, 0.0, 0.0);
        TextBlock textBlock3 = stereotype == null || stereotype.getLabel() == null || !portionShower.showPortion(EntityPortion.STEREOTYPE, iEntity) ? null : TextBlockUtils.withMargin(TextBlockUtils.create(stereotype.getLabels(), new FontConfiguration(this.getFont(FontParam.CLASS_STEREOTYPE, stereotype), this.getFontColor(FontParam.CLASS_STEREOTYPE, stereotype)), HorizontalAlignement.CENTER, iSkinParam), 1.0, 0.0);
        if (string == null) {
            textBlock = null;
        } else {
            textBlock = TextBlockUtils.create(Arrays.asList(string), new FontConfiguration(this.getFont(FontParam.CLASS_STEREOTYPE, stereotype), this.getFontColor(FontParam.CLASS_STEREOTYPE, stereotype)), HorizontalAlignement.CENTER, iSkinParam);
            textBlock = TextBlockUtils.withMargin(textBlock, 1.0, 1.0);
            object = this.getColor(ColorParam.background, stereotype);
            HtmlColor htmlColor2 = this.getFontColor(FontParam.CLASS_STEREOTYPE, stereotype);
            textBlock = new TextBlockGeneric(textBlock, (HtmlColor)object, htmlColor2);
            textBlock = TextBlockUtils.withMargin(textBlock, 1.0, 1.0);
        }
        object = portionShower.showPortion(EntityPortion.CIRCLED_CHARACTER, this.getEntity()) ? TextBlockUtils.withMargin(this.getCircledCharacter(iEntity, iSkinParam), 4.0, 0.0, 5.0, 5.0) : null;
        this.headerLayout = new HeaderLayout((TextBlock)object, textBlock3, textBlock2, textBlock);
    }

    private TextBlock getCircledCharacter(IEntity iEntity, ISkinParam iSkinParam) {
        Stereotype stereotype = iEntity.getStereotype();
        if (stereotype != null && stereotype.getSprite() != null) {
            return iSkinParam.getSprite(stereotype.getSprite()).asTextBlock(stereotype.getHtmlColor());
        }
        if (stereotype != null && stereotype.getCharacter() != '\u0000') {
            HtmlColor htmlColor = this.getColor(ColorParam.classBorder, stereotype);
            UFont uFont = this.getFont(FontParam.CIRCLED_CHARACTER, null);
            return new CircledCharacter(stereotype.getCharacter(), this.getSkinParam().getCircledCharacterRadius(), uFont, stereotype.getHtmlColor(), htmlColor, this.getFontColor(FontParam.CIRCLED_CHARACTER, null));
        }
        if (iEntity.getEntityType() == EntityType.ABSTRACT_CLASS) {
            return new CircledCharacter('A', this.getSkinParam().getCircledCharacterRadius(), this.getFont(FontParam.CIRCLED_CHARACTER, null), this.getColor(ColorParam.stereotypeABackground, stereotype), this.getColor(ColorParam.classBorder, stereotype), this.getFontColor(FontParam.CIRCLED_CHARACTER, null));
        }
        if (iEntity.getEntityType() == EntityType.CLASS) {
            return new CircledCharacter('C', this.getSkinParam().getCircledCharacterRadius(), this.getFont(FontParam.CIRCLED_CHARACTER, null), this.getColor(ColorParam.stereotypeCBackground, stereotype), this.getColor(ColorParam.classBorder, stereotype), this.getFontColor(FontParam.CIRCLED_CHARACTER, null));
        }
        if (iEntity.getEntityType() == EntityType.INTERFACE) {
            return new CircledCharacter('I', this.getSkinParam().getCircledCharacterRadius(), this.getFont(FontParam.CIRCLED_CHARACTER, null), this.getColor(ColorParam.stereotypeIBackground, stereotype), this.getColor(ColorParam.classBorder, stereotype), this.getFontColor(FontParam.CIRCLED_CHARACTER, null));
        }
        if (iEntity.getEntityType() == EntityType.ENUM) {
            return new CircledCharacter('E', this.getSkinParam().getCircledCharacterRadius(), this.getFont(FontParam.CIRCLED_CHARACTER, null), this.getColor(ColorParam.stereotypeEBackground, stereotype), this.getColor(ColorParam.classBorder, stereotype), this.getFontColor(FontParam.CIRCLED_CHARACTER, null));
        }
        assert (false);
        return null;
    }

    public Dimension2D getDimension(StringBounder stringBounder) {
        return this.headerLayout.getDimension(stringBounder);
    }

    public void drawU(UGraphic uGraphic, double d, double d2) {
        throw new UnsupportedOperationException();
    }

    public void drawU(UGraphic uGraphic, double d, double d2, double d3, double d4) {
        this.headerLayout.drawU(uGraphic, d, d2, d3, d4);
    }

    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }

    public int getShield() {
        return 0;
    }
}

