/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.geom.Dimension2D;
import java.util.List;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.svek.AbstractEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;

public class EntityImageComponent
extends AbstractEntityImage {
    private final TextBlock desc;
    private final TextBlock stereo;
    private static final int MARGIN = 10;
    private final List<Url> url;
    private final boolean useUml2ForComponent;

    public EntityImageComponent(IEntity iEntity, ISkinParam iSkinParam) {
        super(iEntity, iSkinParam);
        Stereotype stereotype = iEntity.getStereotype();
        this.desc = TextBlockUtils.create(iEntity.getDisplay2(), new FontConfiguration(this.getFont(FontParam.COMPONENT, stereotype), this.getFontColor(FontParam.COMPONENT, stereotype)), HorizontalAlignement.CENTER, iSkinParam);
        this.stereo = stereotype == null || stereotype.getLabel() == null ? null : TextBlockUtils.create(StringUtils.getWithNewlines(stereotype.getLabel()), new FontConfiguration(this.getFont(FontParam.COMPONENT_STEREOTYPE, stereotype), this.getFontColor(FontParam.COMPONENT_STEREOTYPE, null)), HorizontalAlignement.CENTER, iSkinParam);
        this.url = iEntity.getUrls();
        this.useUml2ForComponent = iSkinParam.useUml2ForComponent();
    }

    private Dimension2D getStereoDimension(StringBounder stringBounder) {
        if (this.stereo == null) {
            return new Dimension2DDouble(0.0, 0.0);
        }
        return this.stereo.calculateDimension(stringBounder);
    }

    private double getSuppDimensionForDocoration() {
        if (this.useUml2ForComponent) {
            return 8.0;
        }
        return 0.0;
    }

    public Dimension2D getDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = Dimension2DDouble.mergeTB(this.desc.calculateDimension(stringBounder), this.getStereoDimension(stringBounder));
        return Dimension2DDouble.delta(dimension2D, 20.0 + this.getSuppDimensionForDocoration());
    }

    public void drawU(UGraphic uGraphic, double d, double d2) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        Dimension2D dimension2D = this.getDimension(stringBounder);
        Dimension2D dimension2D2 = this.getStereoDimension(stringBounder);
        Dimension2D dimension2D3 = this.desc.calculateDimension(stringBounder);
        double d3 = dimension2D.getWidth();
        double d4 = dimension2D.getHeight();
        URectangle uRectangle = new URectangle(d3, d4);
        if (this.getSkinParam().shadowing()) {
            uRectangle.setDeltaShadow(4.0);
        }
        URectangle uRectangle2 = this.useUml2ForComponent ? new URectangle(15.0, 10.0) : new URectangle(10.0, 5.0);
        URectangle uRectangle3 = new URectangle(4.0, 2.0);
        uGraphic.getParam().setStroke(new UStroke(1.5));
        uGraphic.getParam().setColor(this.getColor(ColorParam.componentBorder, this.getStereo()));
        HtmlColor htmlColor = this.getEntity().getSpecificBackColor();
        if (htmlColor == null) {
            htmlColor = this.getColor(ColorParam.componentBackground, this.getStereo());
        }
        uGraphic.getParam().setBackcolor(htmlColor);
        if (this.url.size() > 0) {
            uGraphic.startUrl(this.url.get(0));
        }
        uGraphic.draw(d, d2, uRectangle);
        if (this.useUml2ForComponent) {
            uGraphic.draw(d + d3 - 20.0, d2 + 5.0, uRectangle2);
            uGraphic.draw(d + d3 - 22.0, d2 + 7.0, uRectangle3);
            uGraphic.draw(d + d3 - 22.0, d2 + 11.0, uRectangle3);
        } else {
            uGraphic.draw(d - 5.0, d2 + 5.0, uRectangle2);
            uGraphic.draw(d - 5.0, d2 + d4 - 10.0, uRectangle2);
        }
        uGraphic.getParam().setStroke(new UStroke());
        double d5 = d + (dimension2D.getWidth() - dimension2D3.getWidth()) / 2.0;
        double d6 = d2 + 10.0 + dimension2D2.getHeight();
        this.desc.drawU(uGraphic, d5, d6 + this.getSuppDimensionForDocoration());
        if (this.stereo != null) {
            double d7 = (dimension2D.getWidth() - dimension2D2.getWidth()) / 2.0;
            this.stereo.drawU(uGraphic, d + d7, d2 + 10.0);
        }
        if (this.url.size() > 0) {
            uGraphic.closeAction();
        }
    }

    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }

    public int getShield() {
        return 0;
    }
}

