/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.cucadiagram.CucaDiagram;
import net.sourceforge.plantuml.cucadiagram.EntityUtils;
import net.sourceforge.plantuml.cucadiagram.Group;
import net.sourceforge.plantuml.cucadiagram.GroupHierarchy;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.IEntityMutable;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.cucadiagram.dot.DotData;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.svek.CucaDiagramFileMakerSvek2;
import net.sourceforge.plantuml.svek.EntityImageState;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.InnerActivity;
import net.sourceforge.plantuml.ugraphic.UFont;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GroupPngMakerActivity {
    private final CucaDiagram diagram;
    private final Group group;
    private final Rose rose = new Rose();

    public GroupPngMakerActivity(CucaDiagram cucaDiagram, Group group) {
        this.diagram = cucaDiagram;
        this.group = group;
    }

    private List<Link> getPureInnerLinks() {
        ArrayList<Link> arrayList = new ArrayList<Link>();
        for (Link link : this.diagram.getLinks()) {
            IEntityMutable iEntityMutable = (IEntityMutable)link.getEntity1();
            IEntityMutable iEntityMutable2 = (IEntityMutable)link.getEntity2();
            if (!EntityUtils.equals(iEntityMutable.getContainer(), this.group) || iEntityMutable.isGroup() || !EntityUtils.equals(iEntityMutable2.getContainer(), this.group) || iEntityMutable2.isGroup()) continue;
            arrayList.add(link);
        }
        return arrayList;
    }

    public IEntityImage getImage() throws IOException, InterruptedException {
        String string = this.group.zgetDisplay();
        TextBlock textBlock = TextBlockUtils.create(StringUtils.getWithNewlines(string), new FontConfiguration(this.getFont(FontParam.STATE), HtmlColorUtils.BLACK), HorizontalAlignement.CENTER, this.diagram.getSkinParam());
        if (this.group.zsize() == 0) {
            return new EntityImageState((IEntity)((Object)this.group), this.diagram.getSkinParam());
        }
        List<Link> list = this.getPureInnerLinks();
        ISkinParam iSkinParam = this.diagram.getSkinParam();
        DotData dotData = new DotData(this.group, list, this.group.zentities(), this.diagram.getUmlDiagramType(), iSkinParam, this.group.zgetRankdir(), new InnerGroupHierarchy(), this.diagram.getColorMapper(), this.diagram.getEntityFactory());
        CucaDiagramFileMakerSvek2 cucaDiagramFileMakerSvek2 = new CucaDiagramFileMakerSvek2(dotData);
        if (this.group.zgetGroupType() == GroupType.INNER_ACTIVITY) {
            HtmlColor htmlColor = this.getColor(ColorParam.stateBorder, null);
            return new InnerActivity(cucaDiagramFileMakerSvek2.createFile(new String[0]), htmlColor);
        }
        throw new UnsupportedOperationException(this.group.zgetGroupType().toString());
    }

    private UFont getFont(FontParam fontParam) {
        ISkinParam iSkinParam = this.diagram.getSkinParam();
        return iSkinParam.getFont(fontParam, null);
    }

    protected final HtmlColor getColor(ColorParam colorParam, Stereotype stereotype) {
        String string = stereotype == null ? null : stereotype.getLabel();
        ISkinParam iSkinParam = this.diagram.getSkinParam();
        return this.rose.getHtmlColor(iSkinParam, colorParam, string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class InnerGroupHierarchy
    implements GroupHierarchy {
        InnerGroupHierarchy() {
        }

        @Override
        public Collection<? extends Group> getChildrenGroups(Group group) {
            if (group == null) {
                return GroupPngMakerActivity.this.diagram.getChildrenGroups(GroupPngMakerActivity.this.group);
            }
            return GroupPngMakerActivity.this.diagram.getChildrenGroups(group);
        }

        @Override
        public boolean isEmpty(Group group) {
            return GroupPngMakerActivity.this.diagram.isEmpty(group);
        }
    }
}

