/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.cucadiagram.CucaDiagram;
import net.sourceforge.plantuml.cucadiagram.EntityUtils;
import net.sourceforge.plantuml.cucadiagram.Group;
import net.sourceforge.plantuml.cucadiagram.GroupHierarchy;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.IEntityMutable;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.Member;
import net.sourceforge.plantuml.cucadiagram.MethodsOrFieldsArea;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.cucadiagram.dot.DotData;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignement;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockEmpty;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.TextBlockWidth;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.svek.CucaDiagramFileMakerSvek2;
import net.sourceforge.plantuml.svek.EntityImageState;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.InnerStateAutonom;
import net.sourceforge.plantuml.svek.InnerStateConcurrent;
import net.sourceforge.plantuml.ugraphic.UFont;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class GroupPngMakerState {
    private final CucaDiagram diagram;
    private final Group group;
    private final Rose rose = new Rose();

    public GroupPngMakerState(CucaDiagram cucaDiagram, Group group) {
        this.diagram = cucaDiagram;
        this.group = group;
    }

    private List<Link> getPureInnerLinks() {
        ArrayList<Link> arrayList = new ArrayList<Link>();
        for (Link link : this.diagram.getLinks()) {
            IEntityMutable iEntityMutable = (IEntityMutable)link.getEntity1();
            IEntityMutable iEntityMutable2 = (IEntityMutable)link.getEntity2();
            if (!this.isParent(iEntityMutable, this.group) || iEntityMutable.isGroup() || !this.isParent(iEntityMutable2, this.group) || iEntityMutable2.isGroup()) continue;
            arrayList.add(link);
        }
        return arrayList;
    }

    private boolean isParent(IEntity iEntity, Group group) {
        for (Group group2 = iEntity.getContainer(); group2 != null; group2 = group2.zgetParent()) {
            if (!EntityUtils.equals(group2, group)) continue;
            return true;
        }
        return false;
    }

    public IEntityImage getImage() throws IOException, InterruptedException {
        String string = this.group.zgetDisplay();
        TextBlock textBlock = TextBlockUtils.create(StringUtils.getWithNewlines(string), new FontConfiguration(this.getFont(FontParam.STATE), HtmlColorUtils.BLACK), HorizontalAlignement.CENTER, this.diagram.getSkinParam());
        if (this.group.zsize() == 0) {
            return new EntityImageState((IEntity)((Object)this.group), this.diagram.getSkinParam());
        }
        List<Link> list = this.getPureInnerLinks();
        ISkinParam iSkinParam = this.diagram.getSkinParam();
        DotData dotData = new DotData(this.group, list, this.group.zentities(), this.diagram.getUmlDiagramType(), iSkinParam, this.group.zgetRankdir(), new InnerGroupHierarchy(), this.diagram.getColorMapper(), this.diagram.getEntityFactory());
        CucaDiagramFileMakerSvek2 cucaDiagramFileMakerSvek2 = new CucaDiagramFileMakerSvek2(dotData);
        if (this.group.zgetGroupType() == GroupType.CONCURRENT_STATE) {
            return new InnerStateConcurrent(cucaDiagramFileMakerSvek2.createFile(new String[0]));
        }
        if (this.group.zgetGroupType() == GroupType.STATE) {
            HtmlColor htmlColor = this.getColor(ColorParam.stateBorder, null);
            HtmlColor htmlColor2 = this.group.zgetBackColor() == null ? this.getColor(ColorParam.stateBackground, null) : this.group.zgetBackColor();
            List<Member> list2 = ((IEntity)((Object)this.group)).getFieldsToDisplay();
            TextBlockWidth textBlockWidth = list2.size() == 0 ? new TextBlockEmpty() : new MethodsOrFieldsArea(list2, FontParam.STATE_ATTRIBUTE, this.diagram.getSkinParam());
            ArrayList<Url> arrayList = new ArrayList<Url>();
            for (IEntity iEntity : this.group.zentities()) {
                arrayList.addAll(iEntity.getUrls());
            }
            return new InnerStateAutonom(cucaDiagramFileMakerSvek2.createFile(new String[0]), textBlock, textBlockWidth, htmlColor, htmlColor2, iSkinParam.shadowing(), arrayList, ((IEntityMutable)this.group).getUrls());
        }
        throw new UnsupportedOperationException(this.group.zgetGroupType().toString());
    }

    private UFont getFont(FontParam fontParam) {
        ISkinParam iSkinParam = this.diagram.getSkinParam();
        return iSkinParam.getFont(fontParam, null);
    }

    protected final HtmlColor getColor(ColorParam colorParam, Stereotype stereotype) {
        String string = stereotype == null ? null : stereotype.getLabel();
        ISkinParam iSkinParam = this.diagram.getSkinParam();
        return this.rose.getHtmlColor(iSkinParam, colorParam, string);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class InnerGroupHierarchy
    implements GroupHierarchy {
        InnerGroupHierarchy() {
        }

        @Override
        public Collection<? extends Group> getChildrenGroups(Group group) {
            if (group == null) {
                return GroupPngMakerState.this.diagram.getChildrenGroups(GroupPngMakerState.this.group);
            }
            return GroupPngMakerState.this.diagram.getChildrenGroups(group);
        }

        @Override
        public boolean isEmpty(Group group) {
            return GroupPngMakerState.this.diagram.isEmpty(group);
        }
    }
}

