/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.geom.Dimension2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.cucadiagram.EntityType;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.IEntityMutable;
import net.sourceforge.plantuml.cucadiagram.dot.DotData;
import net.sourceforge.plantuml.posimo.Positionable;
import net.sourceforge.plantuml.svek.Cluster;
import net.sourceforge.plantuml.svek.ColorSequence;
import net.sourceforge.plantuml.svek.EntityImageActivity;
import net.sourceforge.plantuml.svek.EntityImageActor;
import net.sourceforge.plantuml.svek.EntityImageArcCircle;
import net.sourceforge.plantuml.svek.EntityImageAssociation;
import net.sourceforge.plantuml.svek.EntityImageAssociationPoint;
import net.sourceforge.plantuml.svek.EntityImageBranch;
import net.sourceforge.plantuml.svek.EntityImageCircleEnd;
import net.sourceforge.plantuml.svek.EntityImageCircleInterface;
import net.sourceforge.plantuml.svek.EntityImageCircleStart;
import net.sourceforge.plantuml.svek.EntityImageClass;
import net.sourceforge.plantuml.svek.EntityImageComponent;
import net.sourceforge.plantuml.svek.EntityImageEmptyPackage2;
import net.sourceforge.plantuml.svek.EntityImageGroup;
import net.sourceforge.plantuml.svek.EntityImageLollipopInterface;
import net.sourceforge.plantuml.svek.EntityImageNote;
import net.sourceforge.plantuml.svek.EntityImageObject;
import net.sourceforge.plantuml.svek.EntityImagePseudoState;
import net.sourceforge.plantuml.svek.EntityImageState;
import net.sourceforge.plantuml.svek.EntityImageSynchroBar;
import net.sourceforge.plantuml.svek.EntityImageUseCase;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.svek.SvekUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Shape
implements Positionable {
    private final ShapeType type;
    private final double width;
    private final double height;
    private final String uid;
    private final int color;
    private double minX;
    private double minY;
    private final int shield;
    private final List<Url> urls = new ArrayList<Url>();
    private Cluster cluster;
    private final boolean top;
    private final IEntityImage image;

    public final Cluster getCluster() {
        return this.cluster;
    }

    public final void setCluster(Cluster cluster) {
        this.cluster = cluster;
    }

    public Shape(IEntityImage iEntityImage, ShapeType shapeType, double d, double d2, ColorSequence colorSequence, boolean bl, int n, List<Url> list) {
        this.image = iEntityImage;
        this.top = bl;
        this.type = shapeType;
        this.width = d;
        this.height = d2;
        this.color = colorSequence.getValue();
        this.uid = String.format("sh%04d", this.color);
        this.shield = n;
        this.urls.addAll(list);
        if (n > 0 && shapeType != ShapeType.RECTANGLE) {
            throw new IllegalArgumentException();
        }
    }

    public final ShapeType getType() {
        return this.type;
    }

    public final double getWidth() {
        return this.width;
    }

    public final double getHeight() {
        return this.height;
    }

    public void appendShape(StringBuilder stringBuilder) {
        if (this.type == ShapeType.RECTANGLE && this.shield > 0) {
            this.appendHtml(stringBuilder);
            return;
        }
        stringBuilder.append(this.uid);
        stringBuilder.append(" [");
        this.appendShapeInternal(stringBuilder);
        stringBuilder.append(",");
        stringBuilder.append("label=\"\"");
        stringBuilder.append(",");
        stringBuilder.append("width=" + SvekUtils.pixelToInches(this.getWidth()));
        stringBuilder.append(",");
        stringBuilder.append("height=" + SvekUtils.pixelToInches(this.getHeight()));
        stringBuilder.append(",");
        stringBuilder.append("color=\"" + StringUtils.getAsHtml(this.color) + "\"");
        stringBuilder.append("];");
        SvekUtils.println(stringBuilder);
    }

    private void appendHtml(StringBuilder stringBuilder) {
        stringBuilder.append(this.uid);
        stringBuilder.append(" [");
        stringBuilder.append("shape=plaintext,");
        stringBuilder.append("label=<");
        this.appendLabelHtml(stringBuilder);
        stringBuilder.append(">");
        stringBuilder.append("];");
        SvekUtils.println(stringBuilder);
    }

    private void appendLabelHtml(StringBuilder stringBuilder) {
        stringBuilder.append("<TABLE BORDER=\"0\" CELLBORDER=\"0\" CELLSPACING=\"0\" CELLPADDING=\"0\">");
        stringBuilder.append("<TR>");
        this.appendTd(stringBuilder);
        this.appendTd(stringBuilder, this.shield, this.shield);
        this.appendTd(stringBuilder);
        stringBuilder.append("</TR>");
        stringBuilder.append("<TR>");
        this.appendTd(stringBuilder, this.shield, this.shield);
        stringBuilder.append("<TD BGCOLOR=\"" + StringUtils.getAsHtml(this.color) + "\"");
        stringBuilder.append(" FIXEDSIZE=\"TRUE\" WIDTH=\"" + this.getWidth() + "\" HEIGHT=\"" + this.getHeight() + "\"");
        stringBuilder.append(" PORT=\"h\">");
        stringBuilder.append("</TD>");
        this.appendTd(stringBuilder, this.shield, this.shield);
        stringBuilder.append("</TR>");
        stringBuilder.append("<TR>");
        this.appendTd(stringBuilder);
        this.appendTd(stringBuilder, this.shield, this.shield);
        this.appendTd(stringBuilder);
        stringBuilder.append("</TR>");
        stringBuilder.append("</TABLE>");
    }

    private void appendTd(StringBuilder stringBuilder, int n, int n2) {
        stringBuilder.append("<TD");
        stringBuilder.append(" FIXEDSIZE=\"TRUE\" WIDTH=\"" + n + "\" HEIGHT=\"" + n2 + "\"");
        stringBuilder.append(">");
        stringBuilder.append("</TD>");
    }

    private void appendTd(StringBuilder stringBuilder) {
        stringBuilder.append("<TD>");
        stringBuilder.append("</TD>");
    }

    private void appendShapeInternal(StringBuilder stringBuilder) {
        if (this.type == ShapeType.RECTANGLE && this.shield > 0) {
            throw new UnsupportedOperationException();
        }
        if (this.type == ShapeType.RECTANGLE) {
            stringBuilder.append("shape=rect");
        } else if (this.type == ShapeType.DIAMOND) {
            stringBuilder.append("shape=diamond");
        } else if (this.type == ShapeType.CIRCLE) {
            stringBuilder.append("shape=circle");
        } else if (this.type == ShapeType.CIRCLE_IN_RECT) {
            stringBuilder.append("shape=circle");
        } else if (this.type == ShapeType.OVAL) {
            stringBuilder.append("shape=ellipse");
        } else if (this.type == ShapeType.ROUND_RECTANGLE) {
            stringBuilder.append("shape=rect,style=rounded");
        } else {
            throw new IllegalStateException(this.type.toString());
        }
    }

    public final String getUid() {
        if (this.uid == null) {
            throw new IllegalStateException();
        }
        return this.uid;
    }

    public final double getMinX() {
        return this.minX;
    }

    public final double getMinY() {
        return this.minY;
    }

    public IEntityImage getImage() {
        return this.image;
    }

    public final boolean isTop() {
        return this.top;
    }

    @Override
    public Point2D getPosition() {
        return new Point2D.Double(this.minX, this.minY);
    }

    @Override
    public Dimension2D getSize() {
        return new Dimension2DDouble(this.width, this.height);
    }

    public boolean isShielded() {
        return this.shield > 0;
    }

    @Override
    public void moveSvek(double d, double d2) {
        this.minX += d;
        this.minY += d2;
    }

    public static IEntityImage printEntity(IEntity iEntity, DotData dotData) {
        IEntityImage iEntityImage = iEntity.getSvekImage() == null ? Shape.createEntityImageBlock(dotData, iEntity) : iEntity.getSvekImage();
        return iEntityImage;
    }

    private static IEntityImage createEntityImageBlock(DotData dotData, IEntity iEntity) {
        if (iEntity.getEntityType() == EntityType.CLASS || iEntity.getEntityType() == EntityType.ABSTRACT_CLASS || iEntity.getEntityType() == EntityType.INTERFACE || iEntity.getEntityType() == EntityType.ENUM) {
            return new EntityImageClass(iEntity, dotData.getSkinParam(), dotData);
        }
        if (iEntity.getEntityType() == EntityType.NOTE) {
            return new EntityImageNote(iEntity, dotData.getSkinParam());
        }
        if (iEntity.getEntityType() == EntityType.ACTIVITY) {
            return new EntityImageActivity(iEntity, dotData.getSkinParam());
        }
        if (iEntity.getEntityType() == EntityType.STATE) {
            return new EntityImageState(iEntity, dotData.getSkinParam());
        }
        if (iEntity.getEntityType() == EntityType.CIRCLE_START) {
            return new EntityImageCircleStart(iEntity, dotData.getSkinParam());
        }
        if (iEntity.getEntityType() == EntityType.CIRCLE_END) {
            return new EntityImageCircleEnd(iEntity, dotData.getSkinParam());
        }
        if (iEntity.getEntityType() == EntityType.USECASE) {
            return new EntityImageUseCase(iEntity, dotData.getSkinParam());
        }
        if (iEntity.getEntityType() == EntityType.BRANCH) {
            return new EntityImageBranch(iEntity, dotData.getSkinParam());
        }
        if (iEntity.getEntityType() == EntityType.LOLLIPOP) {
            return new EntityImageLollipopInterface(iEntity, dotData.getSkinParam());
        }
        if (iEntity.getEntityType() == EntityType.ACTOR) {
            return new EntityImageActor(iEntity, dotData.getSkinParam());
        }
        if (iEntity.getEntityType() == EntityType.COMPONENT) {
            return new EntityImageComponent(iEntity, dotData.getSkinParam());
        }
        if (iEntity.getEntityType() == EntityType.OBJECT) {
            return new EntityImageObject(iEntity, dotData.getSkinParam());
        }
        if (iEntity.getEntityType() == EntityType.SYNCHRO_BAR) {
            return new EntityImageSynchroBar(iEntity, dotData.getSkinParam());
        }
        if (iEntity.getEntityType() == EntityType.CIRCLE_INTERFACE) {
            return new EntityImageCircleInterface(iEntity, dotData.getSkinParam());
        }
        if (iEntity.getEntityType() == EntityType.ARC_CIRCLE) {
            return new EntityImageArcCircle(iEntity, dotData.getSkinParam());
        }
        if (iEntity.getEntityType() == EntityType.POINT_FOR_ASSOCIATION) {
            return new EntityImageAssociationPoint(iEntity, dotData.getSkinParam());
        }
        if (((IEntityMutable)iEntity).isGroup()) {
            return new EntityImageGroup(iEntity, dotData.getSkinParam());
        }
        if (iEntity.getEntityType() == EntityType.EMPTY_PACKAGE) {
            return new EntityImageEmptyPackage2(iEntity, dotData.getSkinParam());
        }
        if (iEntity.getEntityType() == EntityType.ASSOCIATION) {
            return new EntityImageAssociation(iEntity, dotData.getSkinParam());
        }
        if (iEntity.getEntityType() == EntityType.PSEUDO_STATE) {
            return new EntityImagePseudoState(iEntity, dotData.getSkinParam());
        }
        throw new UnsupportedOperationException(iEntity.getEntityType().toString());
    }
}

