/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.cucadiagram.dot.DotData;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.posimo.Moveable;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.svek.Cluster;
import net.sourceforge.plantuml.svek.DotStringFactory;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.Line;
import net.sourceforge.plantuml.svek.Shape;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.UGraphic;

public final class SvekResult
implements IEntityImage,
Moveable {
    private final Rose rose = new Rose();
    private final HtmlColor clusterBorder;
    private Dimension2D dim;
    private final DotData dotData;
    private final DotStringFactory dotStringFactory;

    public SvekResult(Dimension2D dimension2D, DotData dotData, DotStringFactory dotStringFactory, HtmlColor htmlColor) {
        this.dim = dimension2D;
        this.dotData = dotData;
        this.dotStringFactory = dotStringFactory;
        this.clusterBorder = htmlColor;
    }

    public void drawU(UGraphic uGraphic, double d, double d2) {
        for (Cluster moveable : this.dotStringFactory.getBibliotekon().allCluster()) {
            moveable.drawU(uGraphic, d, d2, this.clusterBorder, this.dotData);
        }
        for (Shape shape : this.dotStringFactory.getBibliotekon().allShapes()) {
            double d3 = shape.getMinX();
            double d4 = shape.getMinY();
            shape.getImage().drawU(uGraphic, d + d3, d2 + d4);
        }
        for (Line line : this.dotStringFactory.getBibliotekon().allLines()) {
            HtmlColor htmlColor = this.rose.getHtmlColor(this.dotData.getSkinParam(), this.getArrowColorParam(), null);
            line.drawU(uGraphic, d, d2, htmlColor);
        }
    }

    private ColorParam getArrowColorParam() {
        if (this.dotData.getUmlDiagramType() == UmlDiagramType.CLASS) {
            return ColorParam.classArrow;
        }
        if (this.dotData.getUmlDiagramType() == UmlDiagramType.OBJECT) {
            return ColorParam.objectArrow;
        }
        if (this.dotData.getUmlDiagramType() == UmlDiagramType.USECASE) {
            return ColorParam.usecaseArrow;
        }
        if (this.dotData.getUmlDiagramType() == UmlDiagramType.ACTIVITY) {
            return ColorParam.activityArrow;
        }
        if (this.dotData.getUmlDiagramType() == UmlDiagramType.COMPONENT) {
            return ColorParam.componentArrow;
        }
        if (this.dotData.getUmlDiagramType() == UmlDiagramType.STATE) {
            return ColorParam.stateArrow;
        }
        throw new IllegalStateException();
    }

    public HtmlColor getBackcolor() {
        return this.dotData.getSkinParam().getBackgroundColor();
    }

    public Dimension2D getDimension(StringBounder stringBounder) {
        return this.dim;
    }

    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }

    public int getShield() {
        return 0;
    }

    public void moveSvek(double d, double d2) {
        this.dotStringFactory.moveSvek(d, d2);
        this.dim = Dimension2DDouble.delta(this.dim, d > 0.0 ? d : 0.0, d2 > 0.0 ? d2 : 0.0);
    }
}

