/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.g2d;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Point2D;
import net.sourceforge.plantuml.EnsureVisible;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UDriver;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.g2d.DriverShadowedG2d;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DriverPolygonG2d
extends DriverShadowedG2d
implements UDriver<Graphics2D> {
    private final double dpiFactor;
    private final EnsureVisible visible;

    public DriverPolygonG2d(double d, EnsureVisible ensureVisible) {
        this.dpiFactor = d;
        this.visible = ensureVisible;
    }

    @Override
    public void draw(UShape uShape, double d, double d2, ColorMapper colorMapper, UParam uParam, Graphics2D graphics2D) {
        UPolygon uPolygon = (UPolygon)uShape;
        graphics2D.setStroke(new BasicStroke((float)uParam.getStroke().getThickness()));
        GeneralPath generalPath = new GeneralPath();
        boolean bl = true;
        for (Point2D.Double double_ : uPolygon.getPoints()) {
            double d3 = ((Point2D)double_).getX() + d;
            double d4 = ((Point2D)double_).getY() + d2;
            this.visible.ensureVisible(d3, d4);
            if (bl) {
                generalPath.moveTo((float)d3, (float)d4);
            } else {
                generalPath.lineTo((float)d3, (float)d4);
            }
            bl = false;
        }
        if (!bl) {
            generalPath.closePath();
        }
        if (uPolygon.getDeltaShadow() != 0.0) {
            this.drawShadow(graphics2D, generalPath, uPolygon.getDeltaShadow(), this.dpiFactor);
        }
        if (uParam.getBackcolor() != null) {
            graphics2D.setColor(colorMapper.getMappedColor(uParam.getBackcolor()));
            graphics2D.fill(generalPath);
        }
        if (uParam.getColor() != null) {
            graphics2D.setColor(colorMapper.getMappedColor(uParam.getColor()));
            graphics2D.draw(generalPath);
        }
    }
}

