/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.usecasediagram.command;

import java.util.List;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand;
import net.sourceforge.plantuml.cucadiagram.EntityType;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.usecasediagram.UsecaseDiagram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandCreateUsecase2
extends SingleLineCommand<UsecaseDiagram> {
    public CommandCreateUsecase2(UsecaseDiagram usecaseDiagram) {
        super(usecaseDiagram, "(?i)^(?:usecase\\s+)?([\\p{L}0-9_.]+|\\([^)]+\\))\\s*as\\s+(\"[^\"]+\"|\\([^)]+\\))(?:\\s*([\\<\\[]{2}.*[\\>\\]]{2}))?$");
    }

    @Override
    protected boolean isForbidden(String string) {
        return string.matches("^[\\p{L}0-9_.]+$");
    }

    @Override
    protected CommandExecutionResult executeArg(List<String> list) {
        EntityType entityType = EntityType.USECASE;
        String string = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(list.get(0));
        String string2 = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(list.get(1));
        String string3 = list.get(2);
        IEntity iEntity = ((UsecaseDiagram)this.getSystem()).getOrCreateEntity(string, entityType);
        iEntity.setDisplay2(string2);
        if (string3 != null) {
            iEntity.setStereotype(new Stereotype(string3, ((UsecaseDiagram)this.getSystem()).getSkinParam().getCircledCharacterRadius(), ((UsecaseDiagram)this.getSystem()).getSkinParam().getFont(FontParam.CIRCLED_CHARACTER, null)));
        }
        return CommandExecutionResult.ok();
    }
}

