/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.NewpagedDiagram;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.activitydiagram3.ActivityDiagram3;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.cucadiagram.CucaDiagram;
import net.sourceforge.plantuml.html.CucaDiagramHtmlMaker;
import net.sourceforge.plantuml.png.PngSplitter;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PSystemUtils {
    public static List<File> exportDiagrams(Diagram diagram, File file, FileFormatOption fileFormatOption) throws IOException {
        if (diagram instanceof NewpagedDiagram) {
            return PSystemUtils.exportDiagramsNewpaged((NewpagedDiagram)diagram, file, fileFormatOption);
        }
        if (diagram instanceof SequenceDiagram) {
            return PSystemUtils.exportDiagramsSequence((SequenceDiagram)diagram, file, fileFormatOption);
        }
        if (diagram instanceof CucaDiagram) {
            return PSystemUtils.exportDiagramsCuca((CucaDiagram)diagram, file, fileFormatOption);
        }
        if (diagram instanceof ActivityDiagram3) {
            return PSystemUtils.exportDiagramsActivityDiagram3((ActivityDiagram3)diagram, file, fileFormatOption);
        }
        return PSystemUtils.exportDiagramsDefault(diagram, file, fileFormatOption);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<File> exportDiagramsNewpaged(NewpagedDiagram newpagedDiagram, File file, FileFormatOption fileFormatOption) throws IOException {
        ArrayList<File> arrayList = new ArrayList<File>();
        int n = newpagedDiagram.getNbImages();
        for (int i = 0; i < n; ++i) {
            Object var9_8;
            File file2 = fileFormatOption.getFileFormat().computeFilename(file, i);
            if (!PSystemUtils.canFileBeWritten(file2)) {
                return arrayList;
            }
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
            try {
                newpagedDiagram.exportDiagram(bufferedOutputStream, i, fileFormatOption);
                var9_8 = null;
            }
            catch (Throwable throwable) {
                var9_8 = null;
                ((OutputStream)bufferedOutputStream).close();
                throw throwable;
            }
            ((OutputStream)bufferedOutputStream).close();
            Log.info("File size : " + file2.length());
            arrayList.add(file2);
        }
        return arrayList;
    }

    public static boolean canFileBeWritten(File file) {
        Log.info("Creating file: " + file);
        if (file.exists() && !file.canWrite()) {
            if (OptionFlags.getInstance().isOverwrite()) {
                Log.info("Overwrite " + file);
                file.setWritable(true);
                file.delete();
                return true;
            }
            Log.error("Cannot write to file " + file);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static List<File> exportDiagramsDefault(Diagram diagram, File file, FileFormatOption fileFormatOption) throws IOException {
        OutputStream outputStream;
        block4: {
            List<File> list;
            if (file.exists() && file.isDirectory()) {
                throw new IllegalArgumentException("File is a directory " + file);
            }
            outputStream = null;
            try {
                if (PSystemUtils.canFileBeWritten(file)) break block4;
                list = Collections.emptyList();
                Object var6_5 = null;
                if (outputStream == null) return list;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                if (outputStream == null) throw throwable;
                outputStream.close();
                throw throwable;
            }
            outputStream.close();
            return list;
        }
        outputStream = new BufferedOutputStream(new FileOutputStream(file));
        diagram.exportDiagram(outputStream, 0, fileFormatOption);
        Object var6_6 = null;
        if (outputStream == null) return Arrays.asList(file);
        outputStream.close();
        return Arrays.asList(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static List<File> exportDiagramsActivityDiagram3(ActivityDiagram3 activityDiagram3, File file, FileFormatOption fileFormatOption) throws IOException {
        ImageData imageData;
        OutputStream outputStream;
        block8: {
            List<File> list;
            block7: {
                if (file.exists() && file.isDirectory()) {
                    throw new IllegalArgumentException("File is a directory " + file);
                }
                outputStream = null;
                imageData = null;
                try {
                    if (!PSystemUtils.canFileBeWritten(file)) {
                        list = Collections.emptyList();
                        Object var7_6 = null;
                        if (outputStream == null) return list;
                        break block7;
                    }
                    outputStream = new BufferedOutputStream(new FileOutputStream(file));
                    imageData = activityDiagram3.exportDiagram(outputStream, 0, fileFormatOption);
                    break block8;
                }
                catch (Throwable throwable) {
                    Object var7_8 = null;
                    if (outputStream != null) {
                        outputStream.close();
                    }
                    throw throwable;
                }
            }
            outputStream.close();
            return list;
        }
        Object var7_7 = null;
        if (outputStream != null) {
            outputStream.close();
        }
        if (imageData != null && imageData.containsCMapData()) {
            activityDiagram3.exportCmap(file, imageData);
        }
        return Arrays.asList(file);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static List<File> exportDiagramsSequence(SequenceDiagram sequenceDiagram, File file, FileFormatOption fileFormatOption) throws IOException {
        ArrayList<File> arrayList = new ArrayList<File>();
        int n = sequenceDiagram.getNbImages();
        for (int i = 0; i < n; ++i) {
            Object var10_9;
            File file2 = fileFormatOption.getFileFormat().computeFilename(file, i);
            if (!PSystemUtils.canFileBeWritten(file)) {
                return arrayList;
            }
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file2));
            ImageData imageData = null;
            try {
                imageData = sequenceDiagram.exportDiagram(bufferedOutputStream, i, fileFormatOption);
                var10_9 = null;
            }
            catch (Throwable throwable) {
                var10_9 = null;
                ((OutputStream)bufferedOutputStream).close();
                throw throwable;
            }
            ((OutputStream)bufferedOutputStream).close();
            if (imageData != null && imageData.containsCMapData()) {
                sequenceDiagram.exportCmap(file, imageData);
            }
            Log.info("File size : " + file2.length());
            arrayList.add(file2);
        }
        return arrayList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<File> exportDiagramsCuca(CucaDiagram cucaDiagram, File file, FileFormatOption fileFormatOption) throws IOException {
        OutputStream outputStream;
        ImageData imageData;
        block8: {
            List<File> list;
            block7: {
                if (file.exists() && file.isDirectory()) {
                    throw new IllegalArgumentException("File is a directory " + file);
                }
                if (fileFormatOption.getFileFormat() == FileFormat.HTML) {
                    return PSystemUtils.createFilesHtml(cucaDiagram, file);
                }
                imageData = null;
                outputStream = null;
                try {
                    if (!PSystemUtils.canFileBeWritten(file)) {
                        list = Collections.emptyList();
                        Object var7_7 = null;
                        if (outputStream == null) return list;
                        break block7;
                    }
                    outputStream = new BufferedOutputStream(new FileOutputStream(file));
                    imageData = cucaDiagram.exportDiagram(outputStream, 0, fileFormatOption);
                    break block8;
                }
                catch (Throwable throwable) {
                    Object var7_9 = null;
                    if (outputStream == null) throw throwable;
                    outputStream.close();
                    throw throwable;
                }
            }
            outputStream.close();
            return list;
        }
        Object var7_8 = null;
        if (outputStream != null) {
            outputStream.close();
        }
        List<File> list = Arrays.asList(file);
        if (imageData != null && imageData.containsCMapData()) {
            cucaDiagram.exportCmap(file, imageData);
        }
        if (fileFormatOption.getFileFormat() != FileFormat.PNG) return list;
        return new PngSplitter(file, cucaDiagram.getHorizontalPages(), cucaDiagram.getVerticalPages(), cucaDiagram.getMetadata(), cucaDiagram.getDpi(fileFormatOption), fileFormatOption.isWithMetadata()).getFiles();
    }

    private static List<File> createFilesHtml(CucaDiagram cucaDiagram, File file) throws IOException {
        String string = file.getName();
        int n = string.lastIndexOf(46);
        File file2 = new File(file.getParentFile(), string.substring(0, n));
        CucaDiagramHtmlMaker cucaDiagramHtmlMaker = new CucaDiagramHtmlMaker(cucaDiagram, file2);
        return cucaDiagramHtmlMaker.create();
    }
}

