/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3;

import java.awt.geom.Dimension2D;
import java.io.IOException;
import java.io.OutputStream;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.Scale;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.activitydiagram3.Instruction;
import net.sourceforge.plantuml.activitydiagram3.InstructionFork;
import net.sourceforge.plantuml.activitydiagram3.InstructionGoto;
import net.sourceforge.plantuml.activitydiagram3.InstructionGroup;
import net.sourceforge.plantuml.activitydiagram3.InstructionIf;
import net.sourceforge.plantuml.activitydiagram3.InstructionLabel;
import net.sourceforge.plantuml.activitydiagram3.InstructionList;
import net.sourceforge.plantuml.activitydiagram3.InstructionRepeat;
import net.sourceforge.plantuml.activitydiagram3.InstructionSimple;
import net.sourceforge.plantuml.activitydiagram3.InstructionSplit;
import net.sourceforge.plantuml.activitydiagram3.InstructionStart;
import net.sourceforge.plantuml.activitydiagram3.InstructionStop;
import net.sourceforge.plantuml.activitydiagram3.InstructionWhile;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyle;
import net.sourceforge.plantuml.activitydiagram3.ftile.EntityImageLegend;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlanes;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.DiagramDescriptionImpl;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockCompressed;
import net.sourceforge.plantuml.graphic.TextBlockRecentred;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.skin.rose.Rose;
import net.sourceforge.plantuml.svek.DecorateEntityImage;
import net.sourceforge.plantuml.svek.DecorateTextBlock;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;
import net.sourceforge.plantuml.ugraphic.UFont;

public class ActivityDiagram3
extends UmlDiagram {
    private SwimlaneStrategy swimlaneStrategy;
    private final Swimlanes swinlanes = new Swimlanes(this.getSkinParam());
    private final Rose rose = new Rose();
    private boolean hasUrl = false;

    private void manageSwimlaneStrategy() {
        if (this.swimlaneStrategy == null) {
            this.swimlaneStrategy = SwimlaneStrategy.SWIMLANE_FORBIDDEN;
        }
    }

    public CommandExecutionResult swimlane(String string, HtmlColor htmlColor, Display display) {
        if (this.swimlaneStrategy == null) {
            this.swimlaneStrategy = SwimlaneStrategy.SWIMLANE_ALLOWED;
        }
        if (this.swimlaneStrategy == SwimlaneStrategy.SWIMLANE_FORBIDDEN) {
            return CommandExecutionResult.error("This swimlane must be defined at the start of the diagram.");
        }
        this.swinlanes.swimlane(string, htmlColor, display);
        return CommandExecutionResult.ok();
    }

    private void setCurrent(Instruction instruction) {
        this.swinlanes.setCurrent(instruction);
    }

    private Instruction current() {
        return this.swinlanes.getCurrent();
    }

    private LinkRendering nextLinkRenderer() {
        return this.swinlanes.nextLinkRenderer();
    }

    public void addActivity(Display display, HtmlColor htmlColor, BoxStyle boxStyle, Url url) {
        this.manageSwimlaneStrategy();
        InstructionSimple instructionSimple = new InstructionSimple(display, htmlColor, this.nextLinkRenderer(), this.swinlanes.getCurrentSwimlane(), boxStyle, url);
        this.current().add(instructionSimple);
        this.setNextLinkRendererInternal(null);
        this.manageHasUrl(display);
        if (url != null) {
            this.hasUrl = true;
        }
    }

    public CommandExecutionResult addGoto(String string) {
        InstructionGoto instructionGoto = new InstructionGoto(this.swinlanes.getCurrentSwimlane(), string);
        this.current().add(instructionGoto);
        this.setNextLinkRendererInternal(null);
        return CommandExecutionResult.ok();
    }

    public CommandExecutionResult addLabel(String string) {
        InstructionLabel instructionLabel = new InstructionLabel(this.swinlanes.getCurrentSwimlane(), string);
        this.current().add(instructionLabel);
        this.setNextLinkRendererInternal(null);
        return CommandExecutionResult.ok();
    }

    public void start() {
        this.manageSwimlaneStrategy();
        this.current().add(new InstructionStart(this.swinlanes.getCurrentSwimlane()));
    }

    public void stop() {
        this.manageSwimlaneStrategy();
        this.current().add(new InstructionStop(this.swinlanes.getCurrentSwimlane()));
    }

    public DiagramDescription getDescription() {
        return new DiagramDescriptionImpl("activity3", this.getClass());
    }

    public UmlDiagramType getUmlDiagramType() {
        return UmlDiagramType.ACTIVITY;
    }

    private TextBlock addLegend(TextBlock textBlock) {
        Display display = this.getLegend();
        if (display == null) {
            return textBlock;
        }
        TextBlock textBlock2 = EntityImageLegend.create(display, this.getSkinParam());
        return DecorateEntityImage.addBottom(textBlock, textBlock2, this.getLegendAlignment());
    }

    protected ImageData exportDiagramInternal(OutputStream outputStream, int n, FileFormatOption fileFormatOption) throws IOException {
        TextBlock textBlock = new TextBlockCompressed(this.swinlanes);
        textBlock = new TextBlockRecentred(textBlock);
        textBlock = this.addLegend(textBlock);
        textBlock = this.addTitle(textBlock);
        textBlock = this.addHeaderAndFooter(textBlock);
        ISkinParam iSkinParam = this.getSkinParam();
        Dimension2D dimension2D = TextBlockUtils.getMinMax(textBlock).getDimension();
        double d = this.getDpiFactor(fileFormatOption, Dimension2DDouble.delta(dimension2D, 20.0, 0.0));
        ImageBuilder imageBuilder = new ImageBuilder(iSkinParam.getColorMapper(), d, this.getSkinParam().getBackgroundColor(), fileFormatOption.isWithMetadata() ? this.getMetadata() : null, this.getWarningOrError(), 10.0, 10.0, this.getAnimation());
        imageBuilder.addUDrawable(textBlock);
        return imageBuilder.writeImageTOBEMOVED(fileFormatOption.getFileFormat(), outputStream);
    }

    private final double getDpiFactor(FileFormatOption fileFormatOption, Dimension2D dimension2D) {
        Scale scale = this.getScale();
        double d = scale == null ? this.getDpiFactor(fileFormatOption) : scale.getScale(dimension2D.getWidth(), dimension2D.getHeight());
        return d;
    }

    private TextBlock addTitle(TextBlock textBlock) {
        Display display = this.getTitle();
        if (display == null) {
            return textBlock;
        }
        TextBlock textBlock2 = TextBlockUtils.create(display, new FontConfiguration(this.getFont(FontParam.TITLE), this.getFontColor(FontParam.TITLE, null), this.getSkinParam().getHyperlinkColor(), this.getSkinParam().useUnderlineForHyperlink()), HorizontalAlignment.CENTER, this.getSkinParam());
        return new DecorateTextBlock(textBlock, textBlock2, HorizontalAlignment.CENTER);
    }

    private TextBlock addHeaderAndFooter(TextBlock textBlock) {
        Display display = this.getFooter();
        Display display2 = this.getHeader();
        if (display == null && display2 == null) {
            return textBlock;
        }
        TextBlock textBlock2 = display == null ? null : TextBlockUtils.create(display, new FontConfiguration(this.getFont(FontParam.FOOTER), this.getFontColor(FontParam.FOOTER, null), this.getSkinParam().getHyperlinkColor(), this.getSkinParam().useUnderlineForHyperlink()), this.getFooterAlignment(), this.getSkinParam());
        TextBlock textBlock3 = display2 == null ? null : TextBlockUtils.create(display2, new FontConfiguration(this.getFont(FontParam.HEADER), this.getFontColor(FontParam.HEADER, null), this.getSkinParam().getHyperlinkColor(), this.getSkinParam().useUnderlineForHyperlink()), this.getHeaderAlignment(), this.getSkinParam());
        return new DecorateTextBlock(textBlock, textBlock3, this.getHeaderAlignment(), textBlock2, this.getFooterAlignment());
    }

    private final UFont getFont(FontParam fontParam) {
        ISkinParam iSkinParam = this.getSkinParam();
        return iSkinParam.getFont(fontParam, null, false);
    }

    private final HtmlColor getFontColor(FontParam fontParam, Stereotype stereotype) {
        ISkinParam iSkinParam = this.getSkinParam();
        return iSkinParam.getFontHtmlColor(fontParam, stereotype);
    }

    public void fork() {
        InstructionFork instructionFork = new InstructionFork(this.current());
        this.current().add(instructionFork);
        this.setCurrent(instructionFork);
    }

    public CommandExecutionResult forkAgain() {
        if (this.current() instanceof InstructionFork) {
            ((InstructionFork)this.current()).forkAgain();
            return CommandExecutionResult.ok();
        }
        return CommandExecutionResult.error("Cannot find fork");
    }

    public CommandExecutionResult endFork() {
        if (this.current() instanceof InstructionFork) {
            this.setCurrent(((InstructionFork)this.current()).getParent());
            return CommandExecutionResult.ok();
        }
        return CommandExecutionResult.error("Cannot find fork");
    }

    public void split() {
        InstructionSplit instructionSplit = new InstructionSplit(this.current());
        this.current().add(instructionSplit);
        this.setCurrent(instructionSplit);
    }

    public CommandExecutionResult splitAgain() {
        if (this.current() instanceof InstructionSplit) {
            ((InstructionSplit)this.current()).splitAgain();
            return CommandExecutionResult.ok();
        }
        return CommandExecutionResult.error("Cannot find split");
    }

    public CommandExecutionResult endSplit() {
        if (this.current() instanceof InstructionSplit) {
            this.setCurrent(((InstructionSplit)this.current()).getParent());
            return CommandExecutionResult.ok();
        }
        return CommandExecutionResult.error("Cannot find split");
    }

    public void startIf(Display display, Display display2, HtmlColor htmlColor) {
        this.manageSwimlaneStrategy();
        InstructionIf instructionIf = new InstructionIf(this.swinlanes.getCurrentSwimlane(), this.current(), display, display2, this.nextLinkRenderer(), htmlColor, this.getSkinParam());
        this.current().add(instructionIf);
        this.setCurrent(instructionIf);
    }

    public CommandExecutionResult elseIf(Display display, Display display2, HtmlColor htmlColor) {
        if (this.current() instanceof InstructionIf) {
            ((InstructionIf)this.current()).elseIf(display, display2, this.nextLinkRenderer(), htmlColor);
            this.setNextLinkRendererInternal(null);
            return CommandExecutionResult.ok();
        }
        return CommandExecutionResult.error("Cannot find if");
    }

    public CommandExecutionResult else2(Display display) {
        if (this.current() instanceof InstructionIf) {
            boolean bl = ((InstructionIf)this.current()).swithToElse2(display, this.nextLinkRenderer());
            if (!bl) {
                return CommandExecutionResult.error("Cannot find if");
            }
            this.setNextLinkRendererInternal(null);
            return CommandExecutionResult.ok();
        }
        return CommandExecutionResult.error("Cannot find if");
    }

    public CommandExecutionResult endif() {
        if (this.current() instanceof InstructionIf) {
            ((InstructionIf)this.current()).endif(this.nextLinkRenderer());
            this.setNextLinkRendererInternal(null);
            this.setCurrent(((InstructionIf)this.current()).getParent());
            return CommandExecutionResult.ok();
        }
        return CommandExecutionResult.error("Cannot find if");
    }

    public void startRepeat(HtmlColor htmlColor) {
        this.manageSwimlaneStrategy();
        InstructionRepeat instructionRepeat = new InstructionRepeat(this.swinlanes.getCurrentSwimlane(), this.current(), this.nextLinkRenderer(), htmlColor);
        this.current().add(instructionRepeat);
        this.setCurrent(instructionRepeat);
    }

    public CommandExecutionResult repeatWhile(Display display, Display display2, Display display3) {
        this.manageSwimlaneStrategy();
        if (this.current() instanceof InstructionRepeat) {
            InstructionRepeat instructionRepeat = (InstructionRepeat)this.current();
            instructionRepeat.setTest(display, display2, display3, this.nextLinkRenderer());
            this.setCurrent(instructionRepeat.getParent());
            this.setNextLinkRendererInternal(null);
            return CommandExecutionResult.ok();
        }
        return CommandExecutionResult.error("Cannot find repeat");
    }

    public void doWhile(Display display, Display display2, HtmlColor htmlColor) {
        this.manageSwimlaneStrategy();
        InstructionWhile instructionWhile = new InstructionWhile(this.swinlanes.getCurrentSwimlane(), this.current(), display, this.nextLinkRenderer(), display2, htmlColor);
        this.current().add(instructionWhile);
        this.setCurrent(instructionWhile);
    }

    public CommandExecutionResult endwhile(Display display) {
        if (this.current() instanceof InstructionWhile) {
            ((InstructionWhile)this.current()).endwhile(this.nextLinkRenderer(), display);
            this.setNextLinkRendererInternal(null);
            this.setCurrent(((InstructionWhile)this.current()).getParent());
            return CommandExecutionResult.ok();
        }
        return CommandExecutionResult.error("Cannot find while");
    }

    public final CommandExecutionResult kill() {
        if (!this.current().kill()) {
            return CommandExecutionResult.error("kill cannot be used here");
        }
        return CommandExecutionResult.ok();
    }

    public void startGroup(Display display, HtmlColor htmlColor, HtmlColor htmlColor2) {
        this.manageSwimlaneStrategy();
        InstructionGroup instructionGroup = new InstructionGroup(this.current(), display, htmlColor, htmlColor2);
        this.current().add(instructionGroup);
        this.setCurrent(instructionGroup);
    }

    public CommandExecutionResult endGroup() {
        if (this.current() instanceof InstructionGroup) {
            this.setCurrent(((InstructionGroup)this.current()).getParent());
            return CommandExecutionResult.ok();
        }
        return CommandExecutionResult.error("Cannot find group");
    }

    private void setNextLinkRendererInternal(LinkRendering linkRendering) {
        this.swinlanes.setNextLinkRenderer(linkRendering);
    }

    private void setNextLink(LinkRendering linkRendering) {
        Instruction instruction;
        if (this.current() instanceof InstructionList && (instruction = ((InstructionList)this.current()).getLast()) instanceof InstructionWhile) {
            ((InstructionWhile)instruction).afterEndwhile(linkRendering);
        }
        this.setNextLinkRendererInternal(linkRendering);
    }

    public void setLabelNextArrow(Display display) {
        if (this.nextLinkRenderer() == null) {
            HtmlColor htmlColor = this.rose.getHtmlColor(this.getSkinParam(), ColorParam.activityArrow);
            this.setNextLink(new LinkRendering(htmlColor));
        }
        this.nextLinkRenderer().setDisplay(display);
    }

    public void setColorNextArrow(HtmlColor htmlColor) {
        if (htmlColor == null) {
            return;
        }
        LinkRendering linkRendering = new LinkRendering(htmlColor);
        this.setNextLink(linkRendering);
    }

    public CommandExecutionResult addNote(Display display, NotePosition notePosition) {
        this.current().addNote(display, notePosition);
        this.manageHasUrl(display);
        return CommandExecutionResult.ok();
    }

    private void manageHasUrl(Display display) {
        if (display.hasUrl()) {
            this.hasUrl = true;
        }
    }

    public boolean hasUrl() {
        return this.hasUrl;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum SwimlaneStrategy {
        SWIMLANE_FORBIDDEN,
        SWIMLANE_ALLOWED;

    }
}

