/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3;

import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.activitydiagram3.Instruction;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.MonoSwimable;
import net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyle;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileKilled;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.sequencediagram.NotePosition;

public class InstructionSimple
extends MonoSwimable
implements Instruction {
    private boolean killed = false;
    private final Display label;
    private final HtmlColor color;
    private final LinkRendering inlinkRendering;
    private Display note;
    private NotePosition notePosition;
    private final BoxStyle style;
    private final Url url;

    public InstructionSimple(Display display, HtmlColor htmlColor, LinkRendering linkRendering, Swimlane swimlane, BoxStyle boxStyle, Url url) {
        super(swimlane);
        this.url = url;
        this.style = boxStyle;
        this.label = display;
        this.color = htmlColor;
        this.inlinkRendering = linkRendering;
    }

    public Ftile createFtile(FtileFactory ftileFactory) {
        Ftile ftile = ftileFactory.activity(this.label, this.color, this.getSwimlaneIn(), this.style);
        if (this.url != null) {
            ftile = ftileFactory.addUrl(ftile, this.url);
        }
        if (this.note != null) {
            ftile = ftileFactory.addNote(ftile, this.note, this.notePosition);
        }
        if (this.killed) {
            return new FtileKilled(ftile);
        }
        return ftile;
    }

    public void add(Instruction instruction) {
        throw new UnsupportedOperationException();
    }

    public final boolean kill() {
        this.killed = true;
        return true;
    }

    public LinkRendering getInLinkRendering() {
        return this.inlinkRendering;
    }

    public void addNote(Display display, NotePosition notePosition) {
        this.note = display;
        this.notePosition = notePosition;
    }
}

