/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.command;

import java.util.List;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.activitydiagram3.ActivityDiagram3;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HtmlColor;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandIf2Multilines
extends CommandMultilines2<ActivityDiagram3> {
    public CommandIf2Multilines() {
        super(CommandIf2Multilines.getRegexConcat(), MultilinesStrategy.REMOVE_STARTING_QUOTE);
    }

    @Override
    public String getPatternEnd() {
        return "(?i)^(.*?)\\)[%s]*(?:then[%s]*(?:\\((.+?)\\))?)?;?$";
    }

    static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("COLOR", "(?:(#\\w+[-\\\\|/]?\\w+):)?"), new RegexLeaf("if"), new RegexLeaf("[%s]*"), new RegexLeaf("\\("), new RegexLeaf("TEST", "([^)]*)$"));
    }

    @Override
    public CommandExecutionResult executeNow(ActivityDiagram3 activityDiagram3, List<String> list) {
        StringUtils.trim(list, false);
        RegexResult regexResult = this.getStartingPattern().matcher(list.get(0).trim());
        List<String> list2 = StringUtils.getSplit(MyPattern.cmpile(this.getPatternEnd()), list.get(list.size() - 1));
        HtmlColor htmlColor = activityDiagram3.getSkinParam().getIHtmlColorSet().getColorIfValid(regexResult.get("COLOR", 0));
        String string = regexResult.get("TEST", 0);
        Display display = Display.getWithNewlines(string);
        for (int i = 1; i < list.size() - 1; ++i) {
            display = display.add(list.get(i));
        }
        String string2 = list2.get(0);
        if (!StringUtils.isEmpty(string2)) {
            display = display.add(string2);
        }
        activityDiagram3.startIf(display, Display.getWithNewlines(list2.get(1)), htmlColor);
        return CommandExecutionResult.ok();
    }
}

