/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile;

import java.awt.geom.Dimension2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.activitydiagram3.ftile.SnakeDirection;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.ULine;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UShape;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Snake
implements UShape {
    private final List<Point2D.Double> points = new ArrayList<Point2D.Double>();
    private final UPolygon endDecoration;
    private final HtmlColor color;
    private final boolean mergeable;
    private TextBlock textBlock;

    public Snake(HtmlColor htmlColor, UPolygon uPolygon, boolean bl) {
        this.endDecoration = uPolygon;
        this.color = htmlColor;
        this.mergeable = bl;
    }

    public void setLabel(TextBlock textBlock) {
        this.textBlock = textBlock;
    }

    public Snake move(double d, double d2) {
        Snake snake = new Snake(this.color, this.endDecoration, this.mergeable);
        for (Point2D point2D : this.points) {
            snake.addPoint(point2D.getX() + d, point2D.getY() + d2);
        }
        snake.textBlock = this.textBlock;
        return snake;
    }

    public Snake translate(UTranslate uTranslate) {
        return this.move(uTranslate.getDx(), uTranslate.getDy());
    }

    public String toString() {
        return this.points.toString();
    }

    SnakeDirection getDirection() {
        if (this.points.size() < 2) {
            throw new IllegalStateException();
        }
        return SnakeDirection.getDirection(this.points.get(0), this.points.get(1));
    }

    public Snake(HtmlColor htmlColor, UPolygon uPolygon) {
        this(htmlColor, uPolygon, false);
    }

    public Snake(HtmlColor htmlColor) {
        this(htmlColor, null, false);
    }

    public Snake(HtmlColor htmlColor, boolean bl) {
        this(htmlColor, null, bl);
    }

    public void addPoint(double d, double d2) {
        if (this.mergeable && this.points.size() == 3) {
            SnakeDirection snakeDirection = this.getDirection();
            Point2D point2D = this.points.get(0);
            this.points.remove(2);
            this.points.remove(1);
            if (snakeDirection == SnakeDirection.VERTICAL_THEN_HORIZONTAL) {
                this.points.add(new Point2D.Double(point2D.getX(), d2));
            } else {
                this.points.add(new Point2D.Double(d, point2D.getY()));
            }
        }
        this.points.add(new Point2D.Double(d, d2));
    }

    public void addPoint(Point2D point2D) {
        this.addPoint(point2D.getX(), point2D.getY());
    }

    public void drawInternal(UGraphic uGraphic) {
        uGraphic = uGraphic.apply(new UChangeColor(this.color));
        uGraphic = uGraphic.apply(new UStroke(1.5));
        for (int i = 0; i < this.points.size() - 1; ++i) {
            Line2D.Double double_ = new Line2D.Double(this.points.get(i), this.points.get(i + 1));
            this.drawLine(uGraphic, double_);
        }
        if (this.endDecoration != null) {
            uGraphic = uGraphic.apply(new UChangeBackColor(this.color));
            Point2D point2D = this.points.get(this.points.size() - 1);
            uGraphic.apply(new UTranslate(point2D)).apply(new UStroke()).draw(this.endDecoration);
        }
        if (this.textBlock != null) {
            Point2D point2D = this.getTextBlockPosition(uGraphic.getStringBounder());
            this.textBlock.drawU(uGraphic.apply(new UTranslate(point2D)));
        }
    }

    public double getMaxX(StringBounder stringBounder) {
        double d = -1.7976931348623157E308;
        for (Point2D cloneable : this.points) {
            d = Math.max(d, cloneable.getX());
        }
        if (this.textBlock != null) {
            Point2D point2D = this.getTextBlockPosition(stringBounder);
            Dimension2D dimension2D = this.textBlock.calculateDimension(stringBounder);
            d = Math.max(d, point2D.getX() + dimension2D.getWidth());
        }
        return d;
    }

    private Point2D getTextBlockPosition(StringBounder stringBounder) {
        Point2D point2D = this.points.get(0);
        Point2D point2D2 = this.points.get(1);
        Dimension2D dimension2D = this.textBlock.calculateDimension(stringBounder);
        double d = (point2D.getY() + point2D2.getY()) / 2.0 - dimension2D.getHeight() / 2.0;
        return new Point2D.Double(Math.max(point2D.getX(), point2D2.getX()) + 4.0, d);
    }

    public List<Line2D> getHorizontalLines() {
        ArrayList<Line2D> arrayList = new ArrayList<Line2D>();
        for (int i = 0; i < this.points.size() - 1; ++i) {
            Point2D point2D = this.points.get(i);
            Point2D point2D2 = this.points.get(i + 1);
            if (point2D.getY() != point2D2.getY()) continue;
            Line2D.Double double_ = new Line2D.Double(point2D, point2D2);
            arrayList.add(double_);
        }
        return arrayList;
    }

    private Point2D getFirst() {
        return this.points.get(0);
    }

    public Point2D getLast() {
        return this.points.get(this.points.size() - 1);
    }

    private boolean same(Point2D point2D, Point2D point2D2) {
        return point2D.getX() == point2D2.getX() && point2D.getY() == point2D2.getY();
    }

    public Snake merge(Snake snake) {
        if (this.same(this.getLast(), snake.getFirst())) {
            Snake snake2 = new Snake(this.color, this.endDecoration, this.mergeable);
            snake2.addPoint(this.getFirst());
            snake2.addPoint(this.getFirst().getX(), snake.getLast().getY());
            snake2.addPoint(snake.getLast());
            snake2.textBlock = this.textBlock;
            return snake2;
        }
        if (this.same(this.getFirst(), snake.getLast())) {
            throw new UnsupportedOperationException();
        }
        return null;
    }

    private void drawLine(UGraphic uGraphic, Line2D line2D) {
        this.drawLine(uGraphic, line2D.getX1(), line2D.getY1(), line2D.getX2(), line2D.getY2());
    }

    private void drawLine(UGraphic uGraphic, double d, double d2, double d3, double d4) {
        uGraphic = uGraphic.apply(new UTranslate(d, d2));
        uGraphic.draw(new ULine(d3 - d, d4 - d2));
    }

    public final boolean isMergeable() {
        return this.mergeable;
    }
}

