/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3.ftile.vertical;

import java.awt.geom.Dimension2D;
import java.util.Collections;
import java.util.Set;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyle;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileGeometry;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.creole.CreoleParser;
import net.sourceforge.plantuml.creole.Sheet;
import net.sourceforge.plantuml.creole.SheetBlock1;
import net.sourceforge.plantuml.creole.SheetBlock2;
import net.sourceforge.plantuml.creole.Stencil;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FtileBox
extends AbstractFtile {
    private static final int MARGIN = 10;
    private final TextBlock tb;
    private final HtmlColor borderColor;
    private final HtmlColor backColor;
    private final LinkRendering inRenreding;
    private final Swimlane swimlane;
    private final BoxStyle style;
    private final String print;

    @Override
    public final LinkRendering getInLinkRendering() {
        return this.inRenreding;
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        if (this.swimlane == null) {
            return Collections.emptySet();
        }
        return Collections.singleton(this.swimlane);
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.swimlane;
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.swimlane;
    }

    public FtileBox(boolean bl, Display display, HtmlColor htmlColor, HtmlColor htmlColor2, UFont uFont, HtmlColor htmlColor3, Swimlane swimlane, BoxStyle boxStyle, ISkinParam iSkinParam) {
        super(bl);
        this.style = boxStyle;
        this.borderColor = htmlColor;
        this.swimlane = swimlane;
        this.backColor = htmlColor2;
        this.inRenreding = new LinkRendering(htmlColor3);
        HtmlColor htmlColor4 = iSkinParam.getFontHtmlColor(FontParam.ACTIVITY, null);
        FontConfiguration fontConfiguration = new FontConfiguration(uFont, htmlColor4, iSkinParam.getHyperlinkColor(), iSkinParam.useUnderlineForHyperlink());
        Sheet sheet = new CreoleParser(fontConfiguration, HorizontalAlignment.LEFT, iSkinParam, false).createSheet(display);
        this.tb = new SheetBlock2(new SheetBlock1(sheet, 0.0), new MyStencil(), new UStroke(1.0));
        this.print = display.toString();
    }

    public String toString() {
        return this.print;
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        FtileGeometry ftileGeometry = this.calculateDimension(uGraphic.getStringBounder());
        double d = ((Dimension2D)ftileGeometry).getWidth();
        double d2 = ((Dimension2D)ftileGeometry).getHeight();
        UDrawable uDrawable = this.style.getUDrawable(d, d2, this.shadowing());
        uGraphic = uGraphic.apply(new UChangeColor(this.borderColor)).apply(new UChangeBackColor(this.backColor)).apply(new UStroke(1.5));
        uDrawable.drawU(uGraphic);
        this.tb.drawU(uGraphic.apply(new UTranslate(10.0, 10.0)));
    }

    @Override
    public FtileGeometry calculateDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = this.tb.calculateDimension(stringBounder);
        return new FtileGeometry(Dimension2DDouble.delta(dimension2D, 20.0, 20.0), dimension2D.getWidth() / 2.0 + 10.0, 0.0, dimension2D.getHeight() + 20.0);
    }

    class MyStencil
    implements Stencil {
        MyStencil() {
        }

        public double getStartingX(StringBounder stringBounder, double d) {
            return -10.0;
        }

        public double getEndingX(StringBounder stringBounder, double d) {
            FtileGeometry ftileGeometry = FtileBox.this.calculateDimension(stringBounder);
            return ((Dimension2D)ftileGeometry).getWidth() - 10.0;
        }
    }
}

