/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.classdiagram.AbstractEntityDiagram;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.utils.UniqueSequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandPackage
extends SingleLineCommand2<AbstractEntityDiagram> {
    public CommandPackage() {
        super(CommandPackage.getRegexConcat());
    }

    private static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^package[%s]+"), new RegexLeaf("NAME", "([%g][^%g]+[%g]|[^#%s{}]*)"), new RegexLeaf("AS", "(?:[%s]+as[%s]+([\\p{L}0-9_.]+))?"), new RegexLeaf("[%s]*"), new RegexLeaf("STEREOTYPE", "(\\<\\<.*\\>\\>)?"), new RegexLeaf("[%s]*"), new RegexLeaf("URL", "(" + UrlBuilder.getRegexp() + ")?"), new RegexLeaf("[%s]*"), new RegexLeaf("COLOR", "(#\\w+[-\\\\|/]?\\w+)?"), new RegexLeaf("[%s]*\\{$"));
    }

    @Override
    protected CommandExecutionResult executeArg(AbstractEntityDiagram abstractEntityDiagram, RegexResult regexResult) {
        Object object;
        String string;
        String string2;
        Code code;
        String string3 = StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(regexResult.get("NAME", 0));
        if (regexResult.get("AS", 0) == null) {
            if (string3.length() == 0) {
                code = Code.of("##" + UniqueSequence.getValue());
                string2 = null;
            } else {
                code = Code.of(string3);
                string2 = code.getFullName();
            }
        } else {
            string2 = string3;
            code = Code.of(regexResult.get("AS", 0));
        }
        IGroup iGroup = abstractEntityDiagram.getCurrentGroup();
        IGroup iGroup2 = abstractEntityDiagram.getOrCreateGroup(code, Display.getWithNewlines(string2), GroupType.PACKAGE, iGroup);
        String string4 = regexResult.get("STEREOTYPE", 0);
        if (string4 != null) {
            iGroup2.setStereotype(new Stereotype(string4));
        }
        if ((string = regexResult.get("URL", 0)) != null) {
            object = new UrlBuilder(abstractEntityDiagram.getSkinParam().getValue("topurl"), UrlBuilder.ModeUrl.STRICT);
            Url url = ((UrlBuilder)object).getUrl(string);
            iGroup2.addUrl(url);
        }
        if ((object = regexResult.get("COLOR", 0)) != null) {
            iGroup2.setSpecificBackcolor(abstractEntityDiagram.getSkinParam().getIHtmlColorSet().getColorIfValid((String)object));
        }
        return CommandExecutionResult.ok();
    }
}

