/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram.dot;

import java.io.File;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.api.Performance;
import net.sourceforge.plantuml.cucadiagram.dot.Graphviz;
import net.sourceforge.plantuml.cucadiagram.dot.GraphvizUtils;
import net.sourceforge.plantuml.cucadiagram.dot.ProcessRunner;
import net.sourceforge.plantuml.cucadiagram.dot.ProcessState;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AbstractGraphviz
implements Graphviz {
    private final File dotExe;
    private final String dotString;
    private final String[] type;

    static boolean isWindows() {
        return File.separatorChar == '\\';
    }

    AbstractGraphviz(String string, String ... stringArray) {
        if (stringArray == null) {
            throw new IllegalArgumentException();
        }
        this.dotExe = this.searchDotExe();
        this.dotString = string;
        this.type = stringArray;
    }

    private File searchDotExe() {
        if (OptionFlags.getInstance().getDotExecutable() == null) {
            String string = GraphvizUtils.getenvGraphvizDot();
            if (string == null) {
                return this.specificDotExe();
            }
            return new File(string);
        }
        return new File(OptionFlags.getInstance().getDotExecutable());
    }

    protected abstract File specificDotExe();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final ProcessState createFile3(OutputStream outputStream) {
        if (this.dotString == null) {
            throw new IllegalArgumentException();
        }
        if (this.illegalDotExe()) {
            throw new IllegalStateException();
        }
        String[] stringArray = this.getCommandLine();
        ProcessRunner processRunner = null;
        ProcessState processState = null;
        long l = -1L;
        try {
            Log.info("Starting Graphviz process " + Arrays.asList(stringArray));
            Log.info("DotString size: " + this.dotString.length());
            processRunner = new ProcessRunner(stringArray);
            l = System.currentTimeMillis();
            processState = processRunner.run(this.dotString.getBytes(), outputStream);
            Log.info("Ending process ok");
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            Log.error("Error: " + throwable);
            Log.error("The command was " + stringArray);
            Log.error("");
            Log.error("Try java -jar plantuml.jar -testdot to figure out the issue");
            Log.error("");
        }
        finally {
            if (l != -1L) {
                long l2 = System.currentTimeMillis() - l;
                Performance.updateDotTime2(l2);
            }
            Log.info("Ending Graphviz process");
        }
        if (OptionFlags.getInstance().isCheckDotError() && processRunner != null && processRunner.getError().length() > 0) {
            Log.error("GraphViz error stream : " + processRunner.getError());
            if (OptionFlags.getInstance().isCheckDotError()) {
                throw new IllegalStateException("Dot error " + processRunner.getError());
            }
        }
        if (OptionFlags.getInstance().isCheckDotError() && processRunner != null && processRunner.getOut().length() > 0) {
            Log.error("GraphViz out stream : " + processRunner.getOut());
            if (OptionFlags.getInstance().isCheckDotError()) {
                throw new IllegalStateException("Dot out " + processRunner.getOut());
            }
        }
        return processState;
    }

    private boolean illegalDotExe() {
        return this.dotExe == null || !this.dotExe.isFile() || !this.dotExe.canRead();
    }

    @Override
    public final String dotVersion() {
        String[] stringArray = this.getCommandLineVersion();
        return this.executeCmd(stringArray);
    }

    private String executeCmd(String[] stringArray) {
        ProcessRunner processRunner = new ProcessRunner(stringArray);
        ProcessState processState = processRunner.run(null, null);
        if (processState.differs(ProcessState.TERMINATED_OK())) {
            return "?";
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (StringUtils.isNotEmpty(processRunner.getOut())) {
            stringBuilder.append(processRunner.getOut());
        }
        if (StringUtils.isNotEmpty(processRunner.getError())) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(' ');
            }
            stringBuilder.append(processRunner.getError());
        }
        return stringBuilder.toString().replace('\n', ' ').trim();
    }

    final String[] getCommandLine() {
        if (OptionFlags.ADD_NICE_FOR_DOT) {
            String[] stringArray = new String[this.type.length + 1 + 3];
            stringArray[0] = "/bin/nice";
            stringArray[1] = "-n";
            stringArray[2] = "10";
            stringArray[3] = this.getDotExe().getAbsolutePath();
            for (int i = 0; i < this.type.length; ++i) {
                stringArray[i + 4] = "-T" + this.type[i];
            }
            return stringArray;
        }
        String[] stringArray = new String[this.type.length + 1];
        stringArray[0] = this.getDotExe().getAbsolutePath();
        for (int i = 0; i < this.type.length; ++i) {
            stringArray[i + 1] = "-T" + this.type[i];
        }
        return stringArray;
    }

    final String[] getCommandLineVersion() {
        return new String[]{this.getDotExe().getAbsolutePath(), "-V"};
    }

    @Override
    public final File getDotExe() {
        return this.dotExe;
    }

    public final String getDotString() {
        return this.dotString;
    }

    public final List<String> getType() {
        return Arrays.asList(this.type);
    }
}

