/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram.dot;

import java.io.IOException;

public class ProcessState {
    private final String name;
    private final IOException cause;
    private static final ProcessState INIT = new ProcessState("INIT", null);
    private static final ProcessState RUNNING = new ProcessState("RUNNING", null);
    private static final ProcessState TERMINATED_OK = new ProcessState("TERMINATED_OK", null);
    private static final ProcessState TIMEOUT = new ProcessState("TIMEOUT", null);

    private ProcessState(String string, IOException iOException) {
        this.name = string;
        this.cause = iOException;
    }

    public String toString() {
        if (this.cause == null) {
            return this.name;
        }
        return this.name + " " + this.cause.toString();
    }

    public static ProcessState INIT() {
        return INIT;
    }

    public static ProcessState RUNNING() {
        return RUNNING;
    }

    public static ProcessState TERMINATED_OK() {
        return TERMINATED_OK;
    }

    public static ProcessState TIMEOUT() {
        return TIMEOUT;
    }

    public static ProcessState IO_EXCEPTION1(IOException iOException) {
        return new ProcessState("IO_EXCEPTION1", iOException);
    }

    public static ProcessState IO_EXCEPTION2(IOException iOException) {
        return new ProcessState("IO_EXCEPTION2", iOException);
    }

    public boolean differs(ProcessState processState) {
        return !this.name.equals(processState.name);
    }

    public boolean equals(Object object) {
        ProcessState processState = (ProcessState)object;
        return this.name.equals(processState.name);
    }

    public Throwable getCause() {
        return this.cause;
    }
}

