/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.cucadiagram.entity;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.cucadiagram.BlockMember;
import net.sourceforge.plantuml.cucadiagram.BlockMemberImpl;
import net.sourceforge.plantuml.cucadiagram.Bodier;
import net.sourceforge.plantuml.cucadiagram.BodyEnhanced;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.EntityPortion;
import net.sourceforge.plantuml.cucadiagram.EntityPosition;
import net.sourceforge.plantuml.cucadiagram.EntityUtils;
import net.sourceforge.plantuml.cucadiagram.GroupType;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Link;
import net.sourceforge.plantuml.cucadiagram.LongCode;
import net.sourceforge.plantuml.cucadiagram.Member;
import net.sourceforge.plantuml.cucadiagram.PortionShower;
import net.sourceforge.plantuml.cucadiagram.Rankdir;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.cucadiagram.entity.EntityFactory;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockVertical2;
import net.sourceforge.plantuml.graphic.USymbol;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.PackageStyle;
import net.sourceforge.plantuml.svek.SingleStrategy;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.utils.UniqueSequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class EntityImpl
implements ILeaf,
IGroup {
    private final EntityFactory entityFactory;
    private final Code code;
    private final LongCode longCode;
    private Url url;
    private final Bodier bodier;
    private final String uid = StringUtils.getUid("cl", UniqueSequence.getValue());
    private Display display = Display.empty();
    private LeafType leafType;
    private Stereotype stereotype;
    private String generic;
    private IGroup parentContainer;
    private boolean top;
    private final List<String> mouseOver = new ArrayList<String>();
    private Code namespace2;
    private GroupType groupType;
    private boolean autonom = true;
    private Rankdir rankdir = Rankdir.TOP_TO_BOTTOM;
    private HtmlColor specificBackcolor;
    private boolean nearDecoration = false;
    private int xposition;
    private IEntityImage svekImage;
    private boolean removed = false;
    private HtmlColor specificLineColor;
    private UStroke specificStroke;
    private USymbol symbol;
    private final int rawLayout;
    private int layer;

    @Override
    public final boolean isTop() {
        this.checkNotGroup();
        return this.top;
    }

    @Override
    public final void setTop(boolean bl) {
        this.checkNotGroup();
        this.top = bl;
    }

    private EntityImpl(EntityFactory entityFactory, Code code, Bodier bodier, IGroup iGroup, LongCode longCode, String string, int n) {
        if (code == null) {
            throw new IllegalArgumentException();
        }
        this.entityFactory = entityFactory;
        this.bodier = bodier;
        this.code = code;
        this.parentContainer = iGroup;
        this.longCode = longCode;
        this.rawLayout = n;
    }

    EntityImpl(EntityFactory entityFactory, Code code, Bodier bodier, IGroup iGroup, LeafType leafType, LongCode longCode, String string, int n) {
        this(entityFactory, code, bodier, iGroup, longCode, string, n);
        this.leafType = leafType;
    }

    EntityImpl(EntityFactory entityFactory, Code code, Bodier bodier, IGroup iGroup, GroupType groupType, Code code2, LongCode longCode, String string, int n) {
        this(entityFactory, code, bodier, iGroup, longCode, string, n);
        this.groupType = groupType;
        this.namespace2 = code2;
    }

    @Override
    public void setContainer(IGroup iGroup) {
        this.checkNotGroup();
        if (iGroup == null) {
            throw new IllegalArgumentException();
        }
        this.parentContainer = iGroup;
    }

    @Override
    public LeafType getEntityType() {
        return this.leafType;
    }

    @Override
    public void muteToType(LeafType leafType, USymbol uSymbol) {
        this.checkNotGroup();
        if (leafType == null) {
            throw new IllegalArgumentException();
        }
        if (this.leafType != LeafType.STILL_UNKNOWN) {
            if (this.leafType != LeafType.ANNOTATION && this.leafType != LeafType.ABSTRACT_CLASS && this.leafType != LeafType.CLASS && this.leafType != LeafType.ENUM && this.leafType != LeafType.INTERFACE) {
                throw new IllegalArgumentException("type=" + (Object)((Object)this.leafType));
            }
            if (leafType != LeafType.ANNOTATION && leafType != LeafType.ABSTRACT_CLASS && leafType != LeafType.CLASS && leafType != LeafType.ENUM && leafType != LeafType.INTERFACE) {
                throw new IllegalArgumentException("newtype=" + (Object)((Object)leafType));
            }
        }
        this.leafType = leafType;
        this.symbol = uSymbol;
    }

    @Override
    public Code getCode() {
        return this.code;
    }

    @Override
    public Display getDisplay() {
        return this.display;
    }

    @Override
    public void setDisplay(Display display) {
        this.display = display;
    }

    @Override
    public String getUid() {
        return this.uid;
    }

    @Override
    public Stereotype getStereotype() {
        return this.stereotype;
    }

    @Override
    public final void setStereotype(Stereotype stereotype) {
        this.stereotype = stereotype;
    }

    @Override
    public final IGroup getParentContainer() {
        if (this.parentContainer == null) {
            throw new IllegalArgumentException();
        }
        return this.parentContainer;
    }

    public String toString() {
        return this.code + " " + this.display + "(" + (Object)((Object)this.leafType) + ") " + this.xposition + " " + this.getUid();
    }

    @Override
    public HtmlColor getSpecificBackColor() {
        return this.specificBackcolor;
    }

    @Override
    public void setSpecificBackcolor(HtmlColor htmlColor) {
        this.specificBackcolor = htmlColor;
    }

    @Override
    public final Url getUrl99() {
        return this.url;
    }

    @Override
    public boolean hasUrl() {
        if (this.display != null && this.display.hasUrl()) {
            return true;
        }
        if (this.bodier.hasUrl()) {
            return true;
        }
        return this.url != null;
    }

    @Override
    public final void addUrl(Url url) {
        this.url = url;
    }

    @Override
    public final boolean hasNearDecoration() {
        this.checkNotGroup();
        return this.nearDecoration;
    }

    @Override
    public final void setNearDecoration(boolean bl) {
        this.nearDecoration = bl;
    }

    @Override
    public int getXposition() {
        this.checkNotGroup();
        return this.xposition;
    }

    @Override
    public void setXposition(int n) {
        this.checkNotGroup();
        this.xposition = n;
    }

    @Override
    public final IEntityImage getSvekImage() {
        this.checkNotGroup();
        return this.svekImage;
    }

    @Override
    public final void setSvekImage(IEntityImage iEntityImage) {
        this.checkNotGroup();
        this.svekImage = iEntityImage;
    }

    @Override
    public final void setGeneric(String string) {
        this.checkNotGroup();
        this.generic = string;
    }

    @Override
    public final String getGeneric() {
        this.checkNotGroup();
        return this.generic;
    }

    @Override
    public BlockMember getBody(PortionShower portionShower) {
        this.checkNotGroup();
        final boolean bl = portionShower.showPortion(EntityPortion.METHOD, this);
        final boolean bl2 = portionShower.showPortion(EntityPortion.FIELD, this);
        if (this.getEntityType().isLikeClass() && this.bodier.isBodyEnhanced()) {
            if (bl && bl2) {
                return this.bodier.getBodyEnhanced();
            }
            return new BlockMember(){

                public TextBlock asTextBlock(FontParam fontParam, ISkinParam iSkinParam) {
                    return null;
                }
            };
        }
        return new BlockMember(){

            public TextBlock asTextBlock(FontParam fontParam, ISkinParam iSkinParam) {
                if (EntityImpl.this.getEntityType().isLikeClass()) {
                    if (bl2 && bl) {
                        return new TextBlockVertical2(new BlockMemberImpl(EntityImpl.this.getFieldsToDisplay()).asTextBlock(fontParam, iSkinParam), new BlockMemberImpl(EntityImpl.this.getMethodsToDisplay()).asTextBlock(fontParam, iSkinParam), HorizontalAlignment.LEFT);
                    }
                    if (bl2) {
                        return new BlockMemberImpl(EntityImpl.this.getFieldsToDisplay()).asTextBlock(fontParam, iSkinParam);
                    }
                    if (bl) {
                        return new BlockMemberImpl(EntityImpl.this.getMethodsToDisplay()).asTextBlock(fontParam, iSkinParam);
                    }
                    return null;
                }
                if (EntityImpl.this.getEntityType() == LeafType.OBJECT) {
                    return new BlockMemberImpl(EntityImpl.this.getFieldsToDisplay()).asTextBlock(fontParam, iSkinParam);
                }
                throw new UnsupportedOperationException();
            }
        };
    }

    @Override
    public BlockMember getMouseOver() {
        if (this.mouseOver.size() == 0) {
            return null;
        }
        return new BlockMember(){

            public TextBlock asTextBlock(FontParam fontParam, ISkinParam iSkinParam) {
                return new BodyEnhanced(EntityImpl.this.mouseOver, fontParam, iSkinParam, EntityImpl.this.leafType.manageModifier());
            }
        };
    }

    @Override
    public void mouseOver(String string) {
        this.mouseOver.add(string);
    }

    @Override
    public List<Member> getFieldsToDisplay() {
        return this.bodier.getFieldsToDisplay();
    }

    @Override
    public List<Member> getMethodsToDisplay() {
        return this.bodier.getMethodsToDisplay();
    }

    @Override
    public void addFieldOrMethod(String string) {
        this.bodier.addFieldOrMethod(string);
    }

    @Override
    public EntityPosition getEntityPosition() {
        this.checkNotGroup();
        if (this.leafType != LeafType.STATE) {
            return EntityPosition.NORMAL;
        }
        Stereotype stereotype = this.getStereotype();
        if (stereotype == null) {
            return EntityPosition.NORMAL;
        }
        String string = stereotype.getLabel();
        if ("<<entrypoint>>".equalsIgnoreCase(string)) {
            return EntityPosition.ENTRY_POINT;
        }
        if ("<<exitpoint>>".equalsIgnoreCase(string)) {
            return EntityPosition.EXIT_POINT;
        }
        return EntityPosition.NORMAL;
    }

    private void checkGroup() {
        if (!this.isGroup()) {
            throw new UnsupportedOperationException();
        }
    }

    private void checkNotGroup() {
        if (this.isGroup()) {
            throw new UnsupportedOperationException();
        }
    }

    @Override
    public boolean containsLeafRecurse(ILeaf iLeaf) {
        if (iLeaf == null) {
            throw new IllegalArgumentException();
        }
        if (iLeaf.isGroup()) {
            throw new IllegalArgumentException();
        }
        this.checkGroup();
        if (iLeaf.getParentContainer() == this) {
            return true;
        }
        for (IGroup iGroup : this.getChildren()) {
            if (!iGroup.containsLeafRecurse(iLeaf)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Collection<ILeaf> getLeafsDirect() {
        this.checkGroup();
        ArrayList<ILeaf> arrayList = new ArrayList<ILeaf>();
        for (ILeaf iLeaf : this.entityFactory.getLeafs().values()) {
            if (iLeaf.isGroup()) {
                throw new IllegalStateException();
            }
            if (iLeaf.getParentContainer() != this) continue;
            arrayList.add(iLeaf);
        }
        return Collections.unmodifiableCollection(arrayList);
    }

    @Override
    public Collection<IGroup> getChildren() {
        this.checkGroup();
        ArrayList<IGroup> arrayList = new ArrayList<IGroup>();
        for (IGroup iGroup : this.entityFactory.getGroups().values()) {
            if (iGroup == this || iGroup.getParentContainer() != this) continue;
            arrayList.add(iGroup);
        }
        return Collections.unmodifiableCollection(arrayList);
    }

    @Override
    public void moveEntitiesTo(IGroup iGroup) {
        this.checkGroup();
        if (!iGroup.isGroup()) {
            throw new UnsupportedOperationException();
        }
        for (ILeaf iEntity : this.getLeafsDirect()) {
            ((EntityImpl)iEntity).parentContainer = iGroup;
        }
        Iterator<IEntity> iterator = iGroup.getChildren().iterator();
        if (iterator.hasNext()) {
            IGroup iGroup2 = (IGroup)iterator.next();
            throw new IllegalStateException();
        }
        for (IGroup iGroup3 : this.getChildren()) {
            if (iGroup3 == iGroup) continue;
            ((EntityImpl)iGroup3).parentContainer = iGroup;
        }
    }

    @Override
    public int size() {
        this.checkGroup();
        return this.getLeafsDirect().size();
    }

    @Override
    public GroupType getGroupType() {
        this.checkGroup();
        return this.groupType;
    }

    @Override
    public Code getNamespace2() {
        this.checkGroup();
        return this.namespace2;
    }

    @Override
    public boolean isAutonom() {
        this.checkGroup();
        return this.autonom;
    }

    @Override
    public void setAutonom(boolean bl) {
        this.autonom = bl;
    }

    @Override
    public Rankdir getRankdir() {
        this.checkGroup();
        return this.rankdir;
    }

    @Override
    public void setRankdir(Rankdir rankdir) {
        this.checkGroup();
        this.rankdir = rankdir;
    }

    @Override
    public PackageStyle getPackageStyle() {
        this.checkGroup();
        if (this.stereotype == null) {
            return null;
        }
        return this.stereotype.getPackageStyle();
    }

    @Override
    public boolean isGroup() {
        if (this.groupType != null && this.leafType != null) {
            throw new IllegalStateException();
        }
        if (this.groupType != null) {
            return true;
        }
        if (this.leafType != null) {
            return false;
        }
        throw new IllegalStateException();
    }

    @Override
    public void overideImage(IEntityImage iEntityImage, LeafType leafType) {
        this.checkGroup();
        this.svekImage = iEntityImage;
        this.url = null;
        for (Link removeable : new ArrayList<Link>(this.entityFactory.getLinks())) {
            if (!EntityUtils.isPureInnerLink12(this, removeable)) continue;
            this.entityFactory.removeLink(removeable);
        }
        this.entityFactory.removeGroup(this.getCode());
        for (ILeaf iLeaf : new ArrayList<ILeaf>(this.entityFactory.getLeafs().values())) {
            if (this == iLeaf || this != iLeaf.getParentContainer()) continue;
            this.entityFactory.removeLeaf(iLeaf.getCode());
        }
        this.entityFactory.addLeaf(this);
        this.groupType = null;
        this.leafType = leafType;
    }

    void muteToGroup(Code code, GroupType groupType, IGroup iGroup) {
        this.checkNotGroup();
        if (!iGroup.isGroup()) {
            throw new IllegalArgumentException();
        }
        this.namespace2 = code;
        this.groupType = groupType;
        this.leafType = null;
        this.parentContainer = iGroup;
    }

    @Override
    public boolean isHidden() {
        if (this.entityFactory.isHidden(this.leafType)) {
            return true;
        }
        if (this.stereotype != null) {
            return this.stereotype.isHidden();
        }
        return false;
    }

    @Override
    public USymbol getUSymbol() {
        return this.symbol;
    }

    @Override
    public void setUSymbol(USymbol uSymbol) {
        this.symbol = uSymbol;
    }

    @Override
    public SingleStrategy getSingleStrategy() {
        return SingleStrategy.SQUARRE;
    }

    @Override
    public boolean isRemoved() {
        if (this.isGroup()) {
            if (this.getLeafsDirect().size() == 0) {
                return false;
            }
            for (ILeaf iEntity : this.getLeafsDirect()) {
                if (iEntity.isRemoved()) continue;
                return false;
            }
            for (IGroup iGroup : this.getChildren()) {
                if (iGroup.isRemoved()) continue;
                return false;
            }
            return true;
        }
        return this.removed;
    }

    @Override
    public void setRemoved(boolean bl) {
        this.removed = bl;
    }

    @Override
    public HtmlColor getSpecificLineColor() {
        return this.specificLineColor;
    }

    @Override
    public void setSpecificLineColor(HtmlColor htmlColor) {
        this.specificLineColor = htmlColor;
    }

    @Override
    public UStroke getSpecificLineStroke() {
        return this.specificStroke;
    }

    @Override
    public void setSpecificLineStroke(UStroke uStroke) {
        this.specificStroke = uStroke;
    }

    @Override
    public int getHectorLayer() {
        return this.layer;
    }

    @Override
    public void setHectorLayer(int n) {
        this.layer = n;
        if (n > 1000) {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public LongCode getLongCode() {
        return this.longCode;
    }

    @Override
    public FontParam getTitleFontParam() {
        if (this.symbol != null) {
            return this.symbol.getFontParam();
        }
        return this.getGroupType() == GroupType.STATE ? FontParam.STATE : FontParam.PACKAGE;
    }

    @Override
    public final int getRawLayout() {
        return this.rawLayout;
    }
}

