/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.donors;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.code.TranscoderImpl;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.DiagramDescriptionImpl;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.graphic.GraphicPosition;
import net.sourceforge.plantuml.graphic.GraphicStrings;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;
import net.sourceforge.plantuml.ugraphic.UAntiAliasing;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.version.PSystemVersion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PSystemDonors
extends AbstractPSystem {
    public static final String DONORS = "UDfTKS5oWa0ClUShEFCNZ7JeKAkEzjHRb2YfI-8i2rFu-iQsi6XE-oPvB-zbCvV-5tdOKI2VP19K64_mGMaiRM2j4VeMiecAHoXyRD401pfY6nWbsMWja4cbFYcKmaZtv_bi4zCu2gnniKW2v3m1Tf15QUtXq4KB0nISFfOeb9FBheL3e5jDagnKRvOld_PG2s_D4rKzhDIn97ljMeAoU-gdNsf19d1ZU5-uncO9RLNcw1kbidEkQZRL2_h1akxds7A1pT9z667hk3T2pgUhEPyxBF3IpjAoC95I3_dOSF13iiPQAuJoVlJF6ar-CPUIYzzbTHtiJ8B1vioV-Ih_pDFr8PLK3_2NoIRaZBRrWKTuZUrAuGTNtvOw";

    @Override
    public ImageData exportDiagram(OutputStream outputStream, int n, FileFormatOption fileFormatOption) throws IOException {
        GraphicStrings graphicStrings = this.getGraphicStrings();
        ImageBuilder imageBuilder = new ImageBuilder(new ColorMapperIdentity(), 1.0, graphicStrings.getBackcolor(), this.getMetadata(), null, 0.0, 0.0, null);
        imageBuilder.addUDrawable(graphicStrings);
        return imageBuilder.writeImageTOBEMOVED(fileFormatOption.getFileFormat(), outputStream);
    }

    private GraphicStrings getGraphicStrings() throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("<b>Special thanks to our sponsors and donors !");
        arrayList.add(" ");
        int n = 0;
        List<String> list = this.getDonors();
        int n2 = (list.size() + 1) / 2;
        for (String object2 : list) {
            arrayList.add(object2);
            if (++n != n2) continue;
            arrayList.add(" ");
            arrayList.add(" ");
            n = 0;
        }
        arrayList.add(" ");
        UFont uFont = new UFont("SansSerif", 0, 12);
        GraphicStrings graphicStrings = new GraphicStrings(arrayList, uFont, HtmlColorUtils.BLACK, HtmlColorUtils.WHITE, UAntiAliasing.ANTI_ALIASING_ON, PSystemVersion.getPlantumlImage(), GraphicPosition.BACKGROUND_CORNER_BOTTOM_RIGHT);
        graphicStrings.setMaxLine(n2 + 2);
        return graphicStrings;
    }

    private List<String> getDonors() throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        TranscoderImpl transcoderImpl = new TranscoderImpl();
        String string = transcoderImpl.decode(DONORS).replace('*', '.');
        StringTokenizer stringTokenizer = new StringTokenizer(string, "\n");
        while (stringTokenizer.hasMoreTokens()) {
            arrayList.add(stringTokenizer.nextToken());
        }
        return arrayList;
    }

    @Override
    public DiagramDescription getDescription() {
        return new DiagramDescriptionImpl("(Donors)", this.getClass());
    }

    public static PSystemDonors create() {
        return new PSystemDonors();
    }
}

