/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.flowdiagram;

import java.awt.geom.Dimension2D;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.SpriteContainerEmpty;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.golem.Tile;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class ActivityBox
implements TextBlock {
    private static final int CORNER = 25;
    private static final int MARGIN = 10;
    private final Tile tile;
    private final String id;
    private final String label;
    private final TextBlock tb;

    public ActivityBox(Tile tile, String string, String string2) {
        this.tile = tile;
        this.id = string;
        this.label = string2;
        UFont uFont = new UFont("Serif", 0, 14);
        FontConfiguration fontConfiguration = new FontConfiguration(uFont, HtmlColorUtils.BLACK, HtmlColorUtils.BLUE, true);
        this.tb = TextBlockUtils.create(Display.create(string2), fontConfiguration, HorizontalAlignment.LEFT, new SpriteContainerEmpty());
    }

    public Tile getTile() {
        return this.tile;
    }

    public String getId() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public void drawU(UGraphic uGraphic) {
        Dimension2D dimension2D = this.calculateDimension(uGraphic.getStringBounder());
        double d = dimension2D.getWidth();
        double d2 = dimension2D.getHeight();
        URectangle uRectangle = new URectangle(d, d2, 25.0, 25.0);
        uGraphic = uGraphic.apply(new UChangeColor(HtmlColorUtils.MY_RED));
        uGraphic = uGraphic.apply(new UChangeBackColor(HtmlColorUtils.MY_YELLOW));
        uGraphic.apply(new UStroke(1.5)).draw(uRectangle);
        this.tb.drawU(uGraphic.apply(new UTranslate(10.0, 10.0)));
    }

    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = this.tb.calculateDimension(stringBounder);
        return Dimension2DDouble.delta(dimension2D, 20.0, 20.0);
    }
}

