/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.graphic;

import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.util.List;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.SpriteContainerEmpty;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.DateEventUtils;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.GraphicPosition;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorSet;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.VerticalAlignment;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.ShapeType;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.UAntiAliasing;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UImage;
import net.sourceforge.plantuml.ugraphic.UTranslate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GraphicStrings
implements IEntityImage {
    private final HtmlColor background;
    private final UFont font;
    private final HtmlColor green;
    private final HtmlColor hyperlinkColor = HtmlColorUtils.BLUE;
    private final boolean useUnderlineForHyperlink = true;
    private final List<String> strings;
    private final BufferedImage image;
    private final GraphicPosition position;
    private final UAntiAliasing antiAliasing;
    private final ColorMapper colorMapper = new ColorMapperIdentity();
    private double minWidth;
    private int maxLine = 0;

    public static GraphicStrings createDefault(List<String> list, boolean bl) {
        if (bl) {
            return new GraphicStrings(list, new UFont("SansSerif", 1, 14), HtmlColorUtils.BLACK, HtmlColorUtils.RED_LIGHT, UAntiAliasing.ANTI_ALIASING_ON);
        }
        return new GraphicStrings(list, new UFont("SansSerif", 1, 14), HtmlColorSet.getInstance().getColorIfValid("#33FF02"), HtmlColorUtils.BLACK, UAntiAliasing.ANTI_ALIASING_ON);
    }

    public GraphicStrings(List<String> list, UFont uFont, HtmlColor htmlColor, HtmlColor htmlColor2, UAntiAliasing uAntiAliasing) {
        this(list, uFont, htmlColor, htmlColor2, uAntiAliasing, null, null);
    }

    public GraphicStrings(List<String> list, UFont uFont, HtmlColor htmlColor, HtmlColor htmlColor2, UAntiAliasing uAntiAliasing, BufferedImage bufferedImage, GraphicPosition graphicPosition) {
        this.strings = list;
        this.font = uFont;
        this.green = htmlColor;
        this.background = htmlColor2;
        this.image = bufferedImage;
        this.position = graphicPosition;
        this.antiAliasing = uAntiAliasing;
    }

    public void setMinWidth(double d) {
        this.minWidth = d;
    }

    private TextBlock getTextBlock() {
        TextBlock textBlock = null;
        if (this.maxLine == 0) {
            textBlock = TextBlockUtils.create(Display.create(this.strings), new FontConfiguration(this.font, this.green, this.hyperlinkColor, true), HorizontalAlignment.LEFT, new SpriteContainerEmpty());
        } else {
            for (int i = 0; i < this.strings.size(); i += this.maxLine) {
                int n = Math.min(i + this.maxLine, this.strings.size());
                TextBlock textBlock2 = TextBlockUtils.create(Display.create(this.strings.subList(i, n)), new FontConfiguration(this.font, this.green, this.hyperlinkColor, true), HorizontalAlignment.LEFT, new SpriteContainerEmpty());
                if (textBlock == null) {
                    textBlock = textBlock2;
                    continue;
                }
                textBlock = TextBlockUtils.withMargin(textBlock, 0.0, 10.0, 0.0, 0.0);
                textBlock = TextBlockUtils.mergeLR(textBlock, textBlock2, VerticalAlignment.TOP);
            }
        }
        textBlock = DateEventUtils.addEvent(textBlock, this.green);
        return textBlock;
    }

    @Override
    public void drawU(UGraphic uGraphic) {
        Dimension2D dimension2D = this.calculateDimension(uGraphic.getStringBounder());
        this.getTextBlock().drawU(uGraphic.apply(new UChangeColor(this.green)));
        if (this.image != null) {
            if (this.position == GraphicPosition.BOTTOM) {
                uGraphic.apply(new UTranslate((dimension2D.getWidth() - (double)this.image.getWidth()) / 2.0, dimension2D.getHeight() - (double)this.image.getHeight())).draw(new UImage(this.image));
            } else if (this.position == GraphicPosition.BACKGROUND_CORNER_BOTTOM_RIGHT) {
                uGraphic.apply(new UTranslate(dimension2D.getWidth() - (double)this.image.getWidth(), dimension2D.getHeight() - (double)this.image.getHeight())).draw(new UImage(this.image));
            } else if (this.position == GraphicPosition.BACKGROUND_CORNER_TOP_RIGHT) {
                uGraphic.apply(new UTranslate(dimension2D.getWidth() - (double)this.image.getWidth() - 1.0, 1.0)).draw(new UImage(this.image));
            }
        }
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        Dimension2D dimension2D = this.getTextBlock().calculateDimension(stringBounder);
        if (dimension2D.getWidth() < this.minWidth) {
            dimension2D = new Dimension2DDouble(this.minWidth, dimension2D.getHeight());
        }
        if (this.image != null) {
            if (this.position == GraphicPosition.BOTTOM) {
                dimension2D = new Dimension2DDouble(dimension2D.getWidth(), dimension2D.getHeight() + (double)this.image.getHeight());
            } else if (this.position == GraphicPosition.BACKGROUND_CORNER_BOTTOM_RIGHT) {
                dimension2D = new Dimension2DDouble(dimension2D.getWidth() + (double)this.image.getWidth(), dimension2D.getHeight());
            } else if (this.position == GraphicPosition.BACKGROUND_CORNER_TOP_RIGHT) {
                dimension2D = new Dimension2DDouble(dimension2D.getWidth() + (double)this.image.getWidth(), dimension2D.getHeight());
            }
        }
        return dimension2D;
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }

    @Override
    public HtmlColor getBackcolor() {
        return this.background;
    }

    @Override
    public int getShield() {
        return 0;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    public final void setMaxLine(int n) {
        this.maxLine = n;
    }
}

