/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.preproc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.FileSystem;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.preproc.Defines;
import net.sourceforge.plantuml.preproc.ReadLine;
import net.sourceforge.plantuml.preproc.ReadLineReader;
import net.sourceforge.plantuml.preproc.StartDiagramExtractReader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class PreprocessorInclude
implements ReadLine {
    private static final Pattern includePattern = MyPattern.cmpile("^[%s]*!include[%s]+[%g]?([^%g]+)[%g]?$");
    private static final Pattern includeURLPattern = MyPattern.cmpile("^[%s]*!includeurl[%s]+[%g]?([^%g]+)[%g]?$");
    private final ReadLine reader2;
    private final String charset;
    private final Defines defines;
    private int numLine = 0;
    private PreprocessorInclude included = null;
    private final File oldCurrentDir;
    private final Set<File> filesUsed;

    public PreprocessorInclude(ReadLine readLine, Defines defines, String string, Set<File> set, File file) {
        this.defines = defines;
        this.charset = string;
        this.reader2 = readLine;
        this.filesUsed = set;
        if (file == null) {
            this.oldCurrentDir = null;
        } else {
            this.oldCurrentDir = FileSystem.getInstance().getCurrentDir();
            FileSystem.getInstance().setCurrentDir(file);
        }
    }

    private void restoreCurrentDir() {
        if (this.oldCurrentDir != null) {
            FileSystem.getInstance().setCurrentDir(this.oldCurrentDir);
        }
    }

    @Override
    public String readLine() throws IOException {
        Matcher matcher;
        String string;
        if (this.included != null) {
            string = this.included.readLine();
            if (string != null) {
                return string;
            }
            this.included.close();
            this.included = null;
        }
        string = this.reader2.readLine();
        ++this.numLine;
        if (string == null) {
            return null;
        }
        if (OptionFlags.ALLOW_INCLUDE) {
            matcher = includePattern.matcher(string);
            assert (this.included == null);
            if (matcher.find()) {
                return this.manageFileInclude(matcher);
            }
        }
        if ((matcher = includeURLPattern.matcher(string)).find()) {
            return this.manageUrlInclude(matcher);
        }
        return string;
    }

    private String manageUrlInclude(Matcher matcher) throws IOException {
        String string = matcher.group(1);
        string = this.defines.applyDefines(string).get(0);
        int n = string.lastIndexOf(33);
        String string2 = null;
        if (n != -1) {
            string2 = string.substring(n + 1);
            string = string.substring(0, n);
        }
        try {
            URL uRL = new URL(string);
            this.included = new PreprocessorInclude(this.getReaderInclude(uRL, string2), this.defines, this.charset, this.filesUsed, null);
        }
        catch (MalformedURLException malformedURLException) {
            return "Cannot include url " + string;
        }
        return this.readLine();
    }

    private String manageFileInclude(Matcher matcher) throws IOException {
        File file;
        String string = matcher.group(1);
        string = this.defines.applyDefines(string).get(0);
        int n = string.lastIndexOf(33);
        String string2 = null;
        if (n != -1) {
            string2 = string.substring(n + 1);
            string = string.substring(0, n);
        }
        if (!(file = FileSystem.getInstance().getFile(PreprocessorInclude.withEnvironmentVariable(string))).exists()) {
            return "Cannot include " + file.getAbsolutePath();
        }
        this.filesUsed.add(file);
        this.included = new PreprocessorInclude(this.getReaderInclude(file, string2), this.defines, this.charset, this.filesUsed, file.getParentFile());
        return this.readLine();
    }

    static String withEnvironmentVariable(String string) {
        Pattern pattern = Pattern.compile("%(\\w+)%");
        Matcher matcher = pattern.matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            String string2 = matcher.group(1);
            String string3 = PreprocessorInclude.getenv(string2);
            if (string3 == null) continue;
            matcher.appendReplacement(stringBuffer, Matcher.quoteReplacement(string3));
        }
        matcher.appendTail(stringBuffer);
        string = stringBuffer.toString();
        return string;
    }

    private static String getenv(String string) {
        String string2 = System.getProperty(string);
        if (StringUtils.isNotEmpty(string2)) {
            return StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(string2);
        }
        String string3 = System.getenv(string);
        if (StringUtils.isNotEmpty(string3)) {
            return StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(string3);
        }
        return null;
    }

    private ReadLine getReaderInclude(File file, String string) throws IOException {
        if (StartDiagramExtractReader.containsStartDiagram(file, this.charset)) {
            int n = 0;
            if (string != null && string.matches("\\d+")) {
                n = Integer.parseInt(string);
            }
            return new StartDiagramExtractReader(file, n, this.charset);
        }
        if (this.charset == null) {
            Log.info("Using default charset");
            return new ReadLineReader(new FileReader(file));
        }
        Log.info("Using charset " + this.charset);
        return new ReadLineReader(new InputStreamReader((InputStream)new FileInputStream(file), this.charset));
    }

    private ReadLine getReaderInclude(URL uRL, String string) throws IOException {
        if (StartDiagramExtractReader.containsStartDiagram(uRL, this.charset)) {
            int n = 0;
            if (string != null && string.matches("\\d+")) {
                n = Integer.parseInt(string);
            }
            return new StartDiagramExtractReader(uRL, n, this.charset);
        }
        InputStream inputStream = uRL.openStream();
        if (this.charset == null) {
            Log.info("Using default charset");
            return new ReadLineReader(new InputStreamReader(inputStream));
        }
        Log.info("Using charset " + this.charset);
        return new ReadLineReader(new InputStreamReader(inputStream, this.charset));
    }

    public int getLineNumber() {
        return this.numLine;
    }

    @Override
    public void close() throws IOException {
        this.restoreCurrentDir();
        this.reader2.close();
    }
}

