/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.preproc;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.preproc.ReadLine;
import net.sourceforge.plantuml.preproc.ReadLineReader;
import net.sourceforge.plantuml.preproc.UncommentReadLine;
import net.sourceforge.plantuml.utils.StartUtils;

public class StartDiagramExtractReader
implements ReadLine {
    private final ReadLine raw;
    private boolean finished = false;

    public StartDiagramExtractReader(File file, int n, String string) throws IOException {
        this(StartDiagramExtractReader.getReadLine(file, string), n, string);
    }

    public StartDiagramExtractReader(URL uRL, int n, String string) throws IOException {
        this(StartDiagramExtractReader.getReadLine(uRL, string), n, string);
    }

    private StartDiagramExtractReader(ReadLine readLine, int n, String string) throws IOException {
        if (n < 0) {
            throw new IllegalArgumentException();
        }
        this.raw = readLine;
        String string2 = null;
        while ((string2 = readLine.readLine()) != null) {
            if (!StartUtils.isArobaseStartDiagram(string2)) continue;
            if (n == 0) {
                return;
            }
            --n;
        }
        this.finished = true;
    }

    private static ReadLine getReadLine(File file, String string) throws IOException {
        if (string == null) {
            Log.info("Using default charset");
            return new UncommentReadLine(new ReadLineReader(new FileReader(file)));
        }
        Log.info("Using charset " + string);
        return new UncommentReadLine(new ReadLineReader(new InputStreamReader((InputStream)new FileInputStream(file), string)));
    }

    private static ReadLine getReadLine(URL uRL, String string) throws IOException {
        if (string == null) {
            Log.info("Using default charset");
            return new UncommentReadLine(new ReadLineReader(new InputStreamReader(uRL.openStream())));
        }
        Log.info("Using charset " + string);
        return new UncommentReadLine(new ReadLineReader(new InputStreamReader(uRL.openStream(), string)));
    }

    public static boolean containsStartDiagram(File file, String string) throws IOException {
        ReadLine readLine = StartDiagramExtractReader.getReadLine(file, string);
        return StartDiagramExtractReader.containsStartDiagram(readLine);
    }

    public static boolean containsStartDiagram(URL uRL, String string) throws IOException {
        ReadLine readLine = StartDiagramExtractReader.getReadLine(uRL, string);
        return StartDiagramExtractReader.containsStartDiagram(readLine);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static boolean containsStartDiagram(ReadLine readLine) throws IOException {
        boolean bl;
        try {
            String string = null;
            while ((string = readLine.readLine()) != null) {
                if (!StartUtils.isArobaseStartDiagram(string)) continue;
                bl = true;
                Object var4_3 = null;
                if (readLine == null) return bl;
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            if (readLine == null) throw throwable;
            readLine.close();
            throw throwable;
        }
        {
            readLine.close();
            return bl;
        }
        Object var4_4 = null;
        if (readLine == null) return false;
        readLine.close();
        return false;
    }

    public String readLine() throws IOException {
        if (this.finished) {
            return null;
        }
        String string = this.raw.readLine();
        if (string != null && StartUtils.isArobaseEndDiagram(string)) {
            this.finished = true;
            return null;
        }
        return string;
    }

    public void close() throws IOException {
        this.raw.close();
    }
}

