/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import java.util.Iterator;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.sequencediagram.graphic.Stairs;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.SimpleContext2D;
import net.sourceforge.plantuml.skin.Skin;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class LiveBoxes
implements UDrawable {
    private final Stairs stairs;
    private final Skin skin;
    private final ISkinParam skinParam;
    private final double totalHeight;

    public LiveBoxes(Stairs stairs, Skin skin, ISkinParam iSkinParam, double d) {
        this.stairs = stairs;
        this.skin = skin;
        this.skinParam = iSkinParam;
        this.totalHeight = d;
    }

    public void drawU(UGraphic uGraphic) {
        this.stairs.addStep(this.totalHeight, this.stairs.getLastValue());
        System.err.println("stairs=" + this.stairs);
        for (Double d : this.stairs.getYs()) {
            System.err.println("LiveBoxes y=" + d + " " + this.stairs.getValue(d));
        }
        int n = this.stairs.getMaxValue();
        for (int i = 1; i <= n; ++i) {
            this.drawOneLevel(uGraphic, i);
        }
    }

    private void drawOneLevel(UGraphic uGraphic, int n) {
        Component component = this.skin.createComponent(ComponentType.ALIVE_BOX_CLOSE_CLOSE, null, this.skinParam, null);
        double d = component.getPreferredWidth(uGraphic.getStringBounder());
        uGraphic = uGraphic.apply(new UTranslate((double)(n - 1) * d / 2.0, 0.0));
        double d2 = Double.MAX_VALUE;
        Iterator<Double> iterator = this.stairs.getYs().iterator();
        while (iterator.hasNext()) {
            double d3 = iterator.next();
            int n2 = this.stairs.getValue(d3);
            if (d2 == Double.MAX_VALUE && n2 == n) {
                d2 = d3;
                continue;
            }
            if (d2 == Double.MAX_VALUE || iterator.hasNext() && n2 >= n) continue;
            double d4 = d3;
            Area area = new Area(d, d4 - d2);
            component.drawU(uGraphic.apply(new UTranslate(-d / 2.0, d2)), area, new SimpleContext2D(false));
            d2 = Double.MAX_VALUE;
        }
    }
}

