/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.sequencediagram.teoz;

import java.awt.geom.Dimension2D;
import java.util.List;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.sequencediagram.Delay;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.skin.Component;
import net.sourceforge.plantuml.skin.ComponentType;
import net.sourceforge.plantuml.skin.SimpleContext2D;
import net.sourceforge.plantuml.skin.Skin;
import net.sourceforge.plantuml.ugraphic.UGraphic;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MutingLine {
    private final Skin skin;
    private final ISkinParam skinParam;
    private final boolean useContinueLineBecauseOfDelay;

    public MutingLine(Skin skin, ISkinParam iSkinParam, List<Event> list) {
        this.skin = skin;
        this.skinParam = iSkinParam;
        this.useContinueLineBecauseOfDelay = this.useContinueLineBecauseOfDelay(list);
    }

    private boolean useContinueLineBecauseOfDelay(List<Event> list) {
        String string = this.skinParam.getValue("lifelineStrategy");
        if ("nosolid".equalsIgnoreCase(string)) {
            return false;
        }
        for (Event event : list) {
            if (!(event instanceof Delay)) continue;
            return true;
        }
        return false;
    }

    public void drawLine(UGraphic uGraphic, double d) {
        ComponentType componentType = this.useContinueLineBecauseOfDelay ? ComponentType.CONTINUE_LINE : ComponentType.PARTICIPANT_LINE;
        Component component = this.skin.createComponent(componentType, null, this.skinParam, null);
        Dimension2D dimension2D = component.getPreferredDimension(uGraphic.getStringBounder());
        Area area = new Area(dimension2D.getWidth(), d);
        component.drawU(uGraphic, area, new SimpleContext2D(false));
    }
}

