/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.skin.rose;

import net.sourceforge.plantuml.ISkinSimple;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.StringBounder;
import net.sourceforge.plantuml.graphic.TextBlock;
import net.sourceforge.plantuml.skin.AbstractTextualComponent;
import net.sourceforge.plantuml.skin.Area;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UStroke;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class ComponentRoseParticipant
extends AbstractTextualComponent {
    private final HtmlColor back;
    private final HtmlColor foregroundColor;
    private final double deltaShadow;
    private final double roundCorner;
    private final UStroke stroke;

    public ComponentRoseParticipant(HtmlColor htmlColor, HtmlColor htmlColor2, HtmlColor htmlColor3, HtmlColor htmlColor4, boolean bl, UFont uFont, Display display, ISkinSimple iSkinSimple, double d, double d2, UStroke uStroke) {
        super(display, htmlColor3, htmlColor4, bl, uFont, HorizontalAlignment.CENTER, 7, 7, 7, iSkinSimple, 0.0, false);
        this.back = htmlColor;
        this.roundCorner = d2;
        this.deltaShadow = d;
        this.foregroundColor = htmlColor2;
        this.stroke = uStroke;
    }

    protected void drawInternalU(UGraphic uGraphic, Area area) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        uGraphic = uGraphic.apply(new UChangeBackColor(this.back)).apply(new UChangeColor(this.foregroundColor));
        uGraphic = uGraphic.apply(this.stroke);
        URectangle uRectangle = new URectangle(this.getTextWidth(stringBounder), this.getTextHeight(stringBounder), this.roundCorner, this.roundCorner);
        uRectangle.setDeltaShadow(this.deltaShadow);
        uGraphic.draw(uRectangle);
        uGraphic = uGraphic.apply(new UStroke());
        TextBlock textBlock = this.getTextBlock();
        textBlock.drawU(uGraphic.apply(new UTranslate(this.getMarginX1(), this.getMarginY())));
    }

    public double getPreferredHeight(StringBounder stringBounder) {
        return this.getTextHeight(stringBounder) + this.deltaShadow + 1.0;
    }

    public double getPreferredWidth(StringBounder stringBounder) {
        return this.getTextWidth(stringBounder) + this.deltaShadow;
    }
}

