/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.statediagram.command;

import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.UrlBuilder;
import net.sourceforge.plantuml.classdiagram.command.CommandCreateClassMultilines;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOr;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.LeafType;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.statediagram.StateDiagram;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandCreateState
extends SingleLineCommand2<StateDiagram> {
    public CommandCreateState() {
        super(CommandCreateState.getRegexConcat());
    }

    private static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^"), new RegexLeaf("(?:state[%s]+)"), new RegexOr(new RegexConcat(new RegexLeaf("CODE1", "([\\p{L}0-9_.]+)"), new RegexLeaf("[%s]+as[%s]+"), new RegexLeaf("DISPLAY1", "[%g]([^%g]+)[%g]")), new RegexConcat(new RegexLeaf("DISPLAY2", "[%g]([^%g]+)[%g]"), new RegexLeaf("[%s]+as[%s]+"), new RegexLeaf("CODE2", "([\\p{L}0-9_.]+)")), new RegexLeaf("CODE3", "([\\p{L}0-9_.]+)"), new RegexLeaf("CODE4", "[%g]([^%g]+)[%g]")), new RegexLeaf("[%s]*"), new RegexLeaf("STEREOTYPE", "(\\<\\<.*\\>\\>)?"), new RegexLeaf("[%s]*"), new RegexLeaf("URL", "(" + UrlBuilder.getRegexp() + ")?"), new RegexLeaf("[%s]*"), new RegexLeaf("COLOR", "(#\\w+[-\\\\|/]?\\w+)?"), new RegexLeaf("[%s]*"), new RegexLeaf("LINECOLOR", "(?:##(?:\\[(dotted|dashed|bold)\\])?(\\w+)?)?"), new RegexLeaf("[%s]*"), new RegexLeaf("ADDFIELD", "(?::[%s]*(.*))?"), new RegexLeaf("$"));
    }

    @Override
    protected CommandExecutionResult executeArg(StateDiagram stateDiagram, RegexResult regexResult) {
        Object object;
        String string;
        Code code = Code.of(regexResult.getLazzy("CODE", 0));
        String string2 = regexResult.getLazzy("DISPLAY", 0);
        if (string2 == null) {
            string2 = code.getFullName();
        }
        String string3 = regexResult.get("STEREOTYPE", 0);
        LeafType leafType = this.getTypeFromStereotype(string3);
        if (!stateDiagram.checkConcurrentStateOk(code)) {
            return CommandExecutionResult.error("The state " + code.getFullName() + " has been created in a concurrent state : it cannot be used here.");
        }
        IEntity iEntity = stateDiagram.getOrCreateLeaf(code, leafType, null);
        iEntity.setDisplay(Display.getWithNewlines(string2));
        if (string3 != null) {
            iEntity.setStereotype(new Stereotype(string3));
        }
        if ((string = regexResult.get("URL", 0)) != null) {
            object = new UrlBuilder(stateDiagram.getSkinParam().getValue("topurl"), UrlBuilder.ModeUrl.STRICT);
            Url url = ((UrlBuilder)object).getUrl(string);
            iEntity.addUrl(url);
        }
        iEntity.setSpecificBackcolor(stateDiagram.getSkinParam().getIHtmlColorSet().getColorIfValid(regexResult.get("COLOR", 0)));
        iEntity.setSpecificLineColor(stateDiagram.getSkinParam().getIHtmlColorSet().getColorIfValid(regexResult.get("LINECOLOR", 1)));
        CommandCreateClassMultilines.applyStroke(iEntity, regexResult.get("LINECOLOR", 0));
        object = regexResult.get("ADDFIELD", 0);
        if (object != null) {
            iEntity.addFieldOrMethod((String)object);
        }
        return CommandExecutionResult.ok();
    }

    private LeafType getTypeFromStereotype(String string) {
        if ("<<choice>>".equalsIgnoreCase(string)) {
            return LeafType.STATE_CHOICE;
        }
        if ("<<fork>>".equalsIgnoreCase(string)) {
            return LeafType.STATE_FORK_JOIN;
        }
        if ("<<join>>".equalsIgnoreCase(string)) {
            return LeafType.STATE_FORK_JOIN;
        }
        if ("<<end>>".equalsIgnoreCase(string)) {
            return LeafType.CIRCLE_END;
        }
        return null;
    }
}

