/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.sourceforge.plantuml.cucadiagram.IEntity;
import net.sourceforge.plantuml.cucadiagram.IGroup;
import net.sourceforge.plantuml.cucadiagram.ILeaf;
import net.sourceforge.plantuml.svek.Cluster;
import net.sourceforge.plantuml.svek.Line;
import net.sourceforge.plantuml.svek.Shape;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Bibliotekon {
    private final List<Cluster> allCluster = new ArrayList<Cluster>();
    private final Map<ILeaf, Shape> shapeMap = new LinkedHashMap<ILeaf, Shape>();
    private final List<Line> lines0 = new ArrayList<Line>();
    private final List<Line> lines1 = new ArrayList<Line>();
    private final List<Line> allLines = new ArrayList<Line>();

    public void putShape(ILeaf iLeaf, Shape shape) {
        this.shapeMap.put(iLeaf, shape);
    }

    public Cluster getCluster(IGroup iGroup) {
        for (Cluster cluster : this.allCluster) {
            if (cluster.getGroup() != iGroup) continue;
            return cluster;
        }
        throw new IllegalArgumentException();
    }

    public void addLine(Line line) {
        this.allLines.add(line);
        if (Bibliotekon.first(line)) {
            if (line.hasNoteLabelText()) {
                for (int i = 0; i < this.lines0.size(); ++i) {
                    Line line2 = this.lines0.get(i);
                    if (line2.hasNoteLabelText() || !line.sameConnections(line2)) continue;
                    this.lines0.add(i, line);
                    return;
                }
                this.lines0.add(line);
            } else {
                this.lines0.add(line);
            }
        } else {
            this.lines1.add(line);
        }
    }

    private static boolean first(Line line) {
        int n = line.getLength();
        return n == 1;
    }

    public void addCluster(Cluster cluster) {
        this.allCluster.add(cluster);
    }

    public Shape getShape(IEntity iEntity) {
        return this.shapeMap.get(iEntity);
    }

    public String getShapeUid(ILeaf iLeaf) {
        Shape shape = this.getShape(iLeaf);
        if (shape != null) {
            String string = shape.getUid();
            if (shape.isShielded()) {
                string = string + ":h";
            }
            return string;
        }
        assert (shape == null);
        if (iLeaf.isGroup()) {
            for (IEntity iEntity : this.shapeMap.keySet()) {
                if (!iLeaf.getCode().equals(iEntity.getCode())) continue;
                return this.getShape(iEntity).getUid();
            }
            return Cluster.getSpecialPointId(iLeaf);
        }
        throw new IllegalStateException();
    }

    public String getWarningOrError(int n) {
        StringBuilder stringBuilder = new StringBuilder();
        for (Map.Entry<ILeaf, Shape> entry : this.shapeMap.entrySet()) {
            Shape shape = entry.getValue();
            double d = shape.getMinX() + shape.getWidth();
            if (!(d > (double)n)) continue;
            IEntity iEntity = entry.getKey();
            stringBuilder.append(iEntity.getCode() + " is overpassing the width limit.");
            stringBuilder.append("\n");
        }
        return stringBuilder.length() == 0 ? "" : stringBuilder.toString();
    }

    public List<Line> allLines() {
        return Collections.unmodifiableList(this.allLines);
    }

    public List<Line> lines0() {
        return Collections.unmodifiableList(this.lines0);
    }

    public List<Line> lines1() {
        return Collections.unmodifiableList(this.lines1);
    }

    public List<Cluster> allCluster() {
        return Collections.unmodifiableList(this.allCluster);
    }

    public Collection<Shape> allShapes() {
        return Collections.unmodifiableCollection(this.shapeMap.values());
    }

    public List<Line> getAllLineConnectedTo(IEntity iEntity) {
        ArrayList<Line> arrayList = new ArrayList<Line>();
        for (Line line : this.allLines) {
            if (!line.isLinkFromOrTo(iEntity)) continue;
            arrayList.add(line);
        }
        return Collections.unmodifiableList(arrayList);
    }
}

