/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import java.awt.GraphicsEnvironment;
import java.awt.Shape;
import java.awt.font.TextLayout;
import java.awt.geom.PathIterator;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.xml.transform.TransformerException;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.graphic.FontConfiguration;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.svg.SvgGraphics;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.ImageBuilder;
import net.sourceforge.plantuml.ugraphic.UChangeColor;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UGraphic;
import net.sourceforge.plantuml.ugraphic.UGraphic2;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UText;
import net.sourceforge.plantuml.ugraphic.UTranslate;

public class FontChecker {
    private final UFont font;
    private static final Set<String> SQUARRE = new HashSet<String>(Arrays.asList("MI=I=XM=I=IX", "MI=I=XM=I=IXMI=I=XM=I=IX"));

    public FontChecker(UFont uFont) {
        this.font = uFont;
    }

    public boolean isCharOk(char c) {
        return !SQUARRE.contains(this.getCharDesc(c));
    }

    private static String getType(int n, double d, double d2, double d3, double d4) {
        if (n == 4) {
            return "X";
        }
        if (n == 1) {
            if (d == d3) {
                return "I";
            }
            if (d2 == d4) {
                return "=";
            }
            return "L";
        }
        if (n == 0) {
            return "M";
        }
        if (n == 2) {
            return "Q";
        }
        if (n == 3) {
            return "C";
        }
        throw new IllegalArgumentException();
    }

    public String getCharDesc(char c) {
        TextLayout textLayout = new TextLayout("" + c, this.font.getFont(), TextBlockUtils.getFontRenderContext());
        Shape shape = textLayout.getOutline(null);
        double[] dArray = new double[6];
        PathIterator pathIterator = shape.getPathIterator(null);
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder();
        while (!pathIterator.isDone()) {
            double d = dArray[0];
            double d2 = dArray[1];
            int n2 = pathIterator.currentSegment(dArray);
            n += n2;
            stringBuilder.append(FontChecker.getType(n2, d, d2, dArray[0], dArray[1]));
            pathIterator.next();
        }
        return stringBuilder.toString();
    }

    public String getCharDescVerbose(char c) {
        TextLayout textLayout = new TextLayout("" + c, this.font.getFont(), TextBlockUtils.getFontRenderContext());
        Shape shape = textLayout.getOutline(null);
        double[] dArray = new double[6];
        PathIterator pathIterator = shape.getPathIterator(null);
        int n = 0;
        StringBuilder stringBuilder = new StringBuilder();
        while (!pathIterator.isDone()) {
            double d = dArray[0];
            double d2 = dArray[1];
            int n2 = pathIterator.currentSegment(dArray);
            n += n2;
            stringBuilder.append(FontChecker.getType(n2, d, d2, dArray[0], dArray[1]));
            this.appendValue(stringBuilder, dArray);
            pathIterator.next();
        }
        return stringBuilder.toString();
    }

    private void appendValue(StringBuilder stringBuilder, double[] dArray) {
        for (double d : dArray) {
            int n = (int)(d * 100.0);
            stringBuilder.append(n);
            stringBuilder.append(":");
        }
    }

    protected void printChar(PrintWriter printWriter, char c) throws IOException, TransformerException {
        printWriter.println("<p>");
        char c2 = c;
        printWriter.println(c2 + " - " + Integer.toHexString(c2) + " - ");
        printWriter.println("&#" + c2 + ";");
        String string = this.getSvgImage(c);
        printWriter.println(string);
    }

    private String getSvgImage(char c) throws IOException, TransformerException {
        SvgGraphics svgGraphics = new SvgGraphics(1.0);
        svgGraphics.setStrokeColor("black");
        svgGraphics.svgImage(this.getBufferedImage(c), 0.0, 0.0);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        svgGraphics.createXml(byteArrayOutputStream);
        byteArrayOutputStream.close();
        return new String(byteArrayOutputStream.toByteArray());
    }

    public BufferedImage getBufferedImage(final char c) throws IOException {
        assert (c != '\t');
        ImageBuilder imageBuilder = new ImageBuilder(new ColorMapperIdentity(), 1.0, null, null, null, 0.0, 0.0, null);
        imageBuilder.addUDrawable(new UDrawable(){

            public void drawU(UGraphic uGraphic) {
                uGraphic = uGraphic.apply(new UChangeColor(HtmlColorUtils.BLACK));
                uGraphic.draw(new URectangle(19.0, 19.0));
                if (uGraphic instanceof UGraphic2) {
                    uGraphic = (UGraphic2)uGraphic.apply(new UTranslate(6.666666666666667, 13.333333333333334));
                    UText uText = new UText("" + c, new FontConfiguration(FontChecker.this.font, HtmlColorUtils.BLACK, HtmlColorUtils.BLUE, true));
                    uGraphic.draw(uText);
                }
            }
        });
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        imageBuilder.writeImageTOBEMOVED(FileFormat.PNG, byteArrayOutputStream);
        byteArrayOutputStream.close();
        return ImageIO.read(new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
    }

    public static void main(String[] stringArray) throws IOException, TransformerException {
        char c;
        int n;
        String string = stringArray[0];
        int n2 = Integer.parseInt(stringArray[1]);
        int n3 = Integer.parseInt(stringArray[2]);
        int n4 = Integer.parseInt(stringArray[3]);
        File file = new File("fontchecker-" + string + "-" + n3 + "-" + n4 + ".html");
        FontChecker fontChecker = new FontChecker(new UFont(string, 0, n2));
        PrintWriter printWriter = new PrintWriter(file);
        printWriter.println("<html>");
        printWriter.println("<h1>PROBLEM</h1>");
        for (int i = n3; i <= n4; ++i) {
            n = i;
            c = fontChecker.isCharOk((char)n);
            if (c != '\u0000') continue;
            fontChecker.printChar(printWriter, (char)n);
            printWriter.println("</p>");
        }
        printWriter.println("<h1>OK</h1>");
        String[] stringArray2 = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        for (n = n3; n <= n4; ++n) {
            c = (char)n;
            boolean bl = fontChecker.isCharOk(c);
            if (!bl) continue;
            fontChecker.printChar(printWriter, c);
            String string2 = fontChecker.getCharDescVerbose(c);
            for (String string3 : stringArray2) {
                FontChecker fontChecker2 = new FontChecker(new UFont(string3, 0, n2));
                String string4 = fontChecker2.getCharDescVerbose(c);
                if (!string2.equals(string4)) continue;
                printWriter.println("&nbsp;");
                printWriter.println(string3);
            }
            printWriter.println("</p>");
        }
        printWriter.println("</html>");
        printWriter.close();
    }
}

