/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Set;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import net.sourceforge.plantuml.AnimatedGifEncoder;
import net.sourceforge.plantuml.CMapData;
import net.sourceforge.plantuml.Dimension2DDouble;
import net.sourceforge.plantuml.EmptyImageBuilder;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileUtils;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.Url;
import net.sourceforge.plantuml.anim.AffineTransformation;
import net.sourceforge.plantuml.anim.Animation;
import net.sourceforge.plantuml.api.ImageDataComplex;
import net.sourceforge.plantuml.api.ImageDataSimple;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.eps.EpsStrategy;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorGradient;
import net.sourceforge.plantuml.graphic.HtmlColorSimple;
import net.sourceforge.plantuml.graphic.HtmlColorTransparent;
import net.sourceforge.plantuml.graphic.TextBlockUtils;
import net.sourceforge.plantuml.graphic.UDrawable;
import net.sourceforge.plantuml.mjpeg.MJPEGGenerator;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.LimitFinder;
import net.sourceforge.plantuml.ugraphic.MinMax;
import net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import net.sourceforge.plantuml.ugraphic.UGraphic2;
import net.sourceforge.plantuml.ugraphic.URectangle;
import net.sourceforge.plantuml.ugraphic.UTranslate;
import net.sourceforge.plantuml.ugraphic.eps.UGraphicEps;
import net.sourceforge.plantuml.ugraphic.g2d.UGraphicG2d;
import net.sourceforge.plantuml.ugraphic.html5.UGraphicHtml5;
import net.sourceforge.plantuml.ugraphic.svg.UGraphicSvg;
import net.sourceforge.plantuml.ugraphic.tikz.UGraphicTikz;
import net.sourceforge.plantuml.ugraphic.visio.UGraphicVdx;

public class ImageBuilder {
    private final ColorMapper colorMapper;
    private final double dpiFactor;
    private final HtmlColor mybackcolor;
    private final String metadata;
    private final String warningOrError;
    private final double margin1;
    private final double margin2;
    private final Animation affineTransformations;
    private UDrawable udrawable;

    public ImageBuilder(ColorMapper colorMapper, double d, HtmlColor htmlColor, String string, String string2, double d2, double d3, Animation animation) {
        this.colorMapper = colorMapper;
        this.dpiFactor = d;
        this.mybackcolor = htmlColor;
        this.metadata = string;
        this.warningOrError = string2;
        this.margin1 = d2;
        this.margin2 = d3;
        this.affineTransformations = animation;
    }

    public void addUDrawable(UDrawable uDrawable) {
        this.udrawable = uDrawable;
    }

    public ImageData writeImageTOBEMOVED(FileFormat fileFormat, OutputStream outputStream) throws IOException {
        if (fileFormat == FileFormat.MJPEG) {
            return this.writeImageMjpeg(outputStream);
        }
        if (fileFormat == FileFormat.ANIMATED_GIF) {
            return this.writeImageAnimatedGif(outputStream);
        }
        return this.writeImageTOBEMOVED(fileFormat, outputStream, this.affineTransformations);
    }

    private ImageData writeImageTOBEMOVED(FileFormat fileFormat, OutputStream outputStream, Animation animation) throws IOException {
        Set<Url> set;
        Object object;
        LimitFinder limitFinder = new LimitFinder(TextBlockUtils.getDummyStringBounder(), true);
        this.udrawable.drawU(limitFinder);
        Dimension2D dimension2D = new Dimension2DDouble(limitFinder.getMaxX() + 1.0 + this.margin1 + this.margin2, limitFinder.getMaxY() + 1.0 + this.margin1 + this.margin2);
        double d = 0.0;
        double d2 = 0.0;
        if (animation != null) {
            object = this.affineTransformations.getMinMax(dimension2D);
            animation.setDimension(dimension2D);
            dimension2D = ((MinMax)object).getDimension();
            d = -((MinMax)object).getMinX();
            d2 = -((MinMax)object).getMinY();
        }
        object = this.createUGraphic(fileFormat, dimension2D, animation, d, d2);
        this.udrawable.drawU(object.apply(new UTranslate(this.margin1, this.margin1)));
        object.writeImageTOBEMOVED(outputStream, this.metadata, 96);
        outputStream.flush();
        if (object instanceof UGraphicG2d && (set = ((UGraphicG2d)object).getAllUrlsEncountered()).size() > 0) {
            CMapData cMapData = CMapData.cmapString(set, this.dpiFactor);
            return new ImageDataComplex(dimension2D, cMapData, this.warningOrError);
        }
        return new ImageDataSimple(dimension2D);
    }

    private ImageData writeImageMjpeg(OutputStream outputStream) throws IOException {
        LimitFinder limitFinder = new LimitFinder(TextBlockUtils.getDummyStringBounder(), true);
        this.udrawable.drawU(limitFinder);
        Dimension2DDouble dimension2DDouble = new Dimension2DDouble(limitFinder.getMaxX() + 1.0 + this.margin1 + this.margin2, limitFinder.getMaxY() + 1.0 + this.margin1 + this.margin2);
        File file = new File("c:/tmp.avi");
        MJPEGGenerator mJPEGGenerator = new MJPEGGenerator(file, this.getAviImage(null).getWidth(null), this.getAviImage(null).getHeight(null), 12.0, 100);
        int n = 0;
        if (n < 100) {
            AffineTransform affineTransform = AffineTransform.getTranslateInstance(((Dimension2D)dimension2DDouble).getWidth() / 2.0, ((Dimension2D)dimension2DDouble).getHeight() / 2.0);
            affineTransform.rotate(1.5707963267948966 * (double)n / 100.0);
            affineTransform.translate(-((Dimension2D)dimension2DDouble).getWidth() / 2.0, -((Dimension2D)dimension2DDouble).getHeight() / 2.0);
            throw new UnsupportedOperationException();
        }
        mJPEGGenerator.finishAVI();
        FileUtils.copyToStream(file, outputStream);
        return new ImageDataSimple(dimension2DDouble);
    }

    private ImageData writeImageAnimatedGif(OutputStream outputStream) throws IOException {
        LimitFinder limitFinder = new LimitFinder(TextBlockUtils.getDummyStringBounder(), true);
        this.udrawable.drawU(limitFinder);
        Dimension2DDouble dimension2DDouble = new Dimension2DDouble(limitFinder.getMaxX() + 1.0 + this.margin1 + this.margin2, limitFinder.getMaxY() + 1.0 + this.margin1 + this.margin2);
        MinMax minMax = this.affineTransformations.getMinMax(dimension2DDouble);
        AnimatedGifEncoder animatedGifEncoder = new AnimatedGifEncoder();
        animatedGifEncoder.setRepeat(0);
        animatedGifEncoder.start(outputStream);
        animatedGifEncoder.setDelay(60);
        for (AffineTransformation affineTransformation : this.affineTransformations.getAll()) {
            ImageIcon imageIcon = new ImageIcon(this.getAviImage(affineTransformation));
            animatedGifEncoder.addFrame((BufferedImage)imageIcon.getImage());
        }
        animatedGifEncoder.finish();
        return new ImageDataSimple(dimension2DDouble);
    }

    private Image getAviImage(AffineTransformation affineTransformation) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.writeImageTOBEMOVED(FileFormat.PNG, byteArrayOutputStream, Animation.singleton(affineTransformation));
        byteArrayOutputStream.close();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byteArrayOutputStream.toByteArray());
        BufferedImage bufferedImage = ImageIO.read(byteArrayInputStream);
        byteArrayInputStream.close();
        return bufferedImage;
    }

    private UGraphic2 createUGraphic(FileFormat fileFormat, Dimension2D dimension2D, Animation animation, double d, double d2) {
        switch (fileFormat) {
            case PNG: {
                return this.createUGraphicPNG(this.colorMapper, this.dpiFactor, dimension2D, this.mybackcolor, animation, d, d2);
            }
            case SVG: {
                return this.createUGraphicSVG(this.colorMapper, this.dpiFactor, dimension2D, this.mybackcolor);
            }
            case EPS: {
                return new UGraphicEps(this.colorMapper, EpsStrategy.getDefault2());
            }
            case EPS_TEXT: {
                return new UGraphicEps(this.colorMapper, EpsStrategy.WITH_MACRO_AND_TEXT);
            }
            case HTML5: {
                return new UGraphicHtml5(this.colorMapper);
            }
            case VDX: {
                return new UGraphicVdx(this.colorMapper);
            }
            case LATEX: {
                return new UGraphicTikz(this.colorMapper);
            }
        }
        throw new UnsupportedOperationException(fileFormat.toString());
    }

    private UGraphic2 createUGraphicSVG(ColorMapper colorMapper, double d, Dimension2D dimension2D, HtmlColor htmlColor) {
        Color color = Color.WHITE;
        if (htmlColor instanceof HtmlColorSimple) {
            color = colorMapper.getMappedColor(htmlColor);
        }
        UGraphicSvg uGraphicSvg = htmlColor instanceof HtmlColorGradient ? new UGraphicSvg(colorMapper, (HtmlColorGradient)htmlColor, false, d) : (color == null || color.equals(Color.WHITE) ? new UGraphicSvg(colorMapper, false, d) : new UGraphicSvg(colorMapper, StringUtils.getAsHtml(color), false, d));
        return uGraphicSvg;
    }

    private UGraphic2 createUGraphicPNG(ColorMapper colorMapper, double d, Dimension2D dimension2D, HtmlColor htmlColor, Animation animation, double d2, double d3) {
        Color color = Color.WHITE;
        if (htmlColor instanceof HtmlColorSimple) {
            color = colorMapper.getMappedColor(htmlColor);
        } else if (htmlColor instanceof HtmlColorTransparent) {
            color = null;
        }
        EmptyImageBuilder emptyImageBuilder = new EmptyImageBuilder((int)(dimension2D.getWidth() * d), (int)(dimension2D.getHeight() * d), color);
        Graphics2D graphics2D = emptyImageBuilder.getGraphics2D();
        UGraphicG2d uGraphicG2d = new UGraphicG2d(colorMapper, graphics2D, d, animation == null ? null : animation.getFirst(), d2, d3);
        uGraphicG2d.setBufferedImage(emptyImageBuilder.getBufferedImage());
        BufferedImage bufferedImage = uGraphicG2d.getBufferedImage();
        if (htmlColor instanceof HtmlColorGradient) {
            uGraphicG2d.apply(new UChangeBackColor(htmlColor)).draw(new URectangle(bufferedImage.getWidth(), bufferedImage.getHeight()));
        }
        return uGraphicG2d;
    }
}

