/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic;

import java.awt.Color;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.code.AsciiEncoder;
import net.sourceforge.plantuml.code.CompressionZlib;
import net.sourceforge.plantuml.ugraphic.ColorChangerMonochrome;
import net.sourceforge.plantuml.ugraphic.Sprite;
import net.sourceforge.plantuml.ugraphic.SpriteMonochrome;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SpriteGrayLevel
extends Enum<SpriteGrayLevel> {
    public static final /* enum */ SpriteGrayLevel GRAY_16 = new SpriteGrayLevel(16);
    public static final /* enum */ SpriteGrayLevel GRAY_8 = new SpriteGrayLevel(8);
    public static final /* enum */ SpriteGrayLevel GRAY_4 = new SpriteGrayLevel(4);
    private final int nbColor;
    private static final ColorChangerMonochrome mono;
    private static final /* synthetic */ SpriteGrayLevel[] $VALUES;

    public static SpriteGrayLevel[] values() {
        return (SpriteGrayLevel[])$VALUES.clone();
    }

    public static SpriteGrayLevel valueOf(String string) {
        return Enum.valueOf(SpriteGrayLevel.class, string);
    }

    private SpriteGrayLevel(int n2) {
        this.nbColor = n2;
    }

    public static SpriteGrayLevel get(int n) {
        if (n == 4) {
            return GRAY_4;
        }
        if (n == 8) {
            return GRAY_8;
        }
        if (n == 16) {
            return GRAY_16;
        }
        throw new UnsupportedOperationException();
    }

    public int getNbColor() {
        return this.nbColor;
    }

    public List<String> encode(BufferedImage bufferedImage) {
        if (this == GRAY_16) {
            return this.encode16(bufferedImage);
        }
        if (this == GRAY_8) {
            return this.encode8(bufferedImage);
        }
        if (this == GRAY_4) {
            return this.encode4(bufferedImage);
        }
        throw new UnsupportedOperationException();
    }

    private List<String> encode16(BufferedImage bufferedImage) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < n2; ++i) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int j = 0; j < n; ++j) {
                int n3 = this.getGrayOn16(bufferedImage, j, i);
                char c = "0123456789ABCDEF".charAt(n3);
                stringBuilder.append(c);
            }
            arrayList.add(stringBuilder.toString());
        }
        return Collections.unmodifiableList(arrayList);
    }

    private List<String> encode8(BufferedImage bufferedImage) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        ArrayList<String> arrayList = new ArrayList<String>();
        AsciiEncoder asciiEncoder = new AsciiEncoder();
        for (int i = 0; i < n2; i += 2) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int j = 0; j < n; ++j) {
                int n3 = this.getGrayOn16(bufferedImage, j, i) / 2;
                assert (n3 >= 0 && n3 <= 7);
                int n4 = this.getGrayOn16(bufferedImage, j, i + 1) / 2;
                assert (n4 >= 0 && n4 <= 7);
                int n5 = n3 * 8 + n4;
                stringBuilder.append(asciiEncoder.encode6bit((byte)n5));
            }
            arrayList.add(stringBuilder.toString());
        }
        return Collections.unmodifiableList(arrayList);
    }

    private List<String> encode4(BufferedImage bufferedImage) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        ArrayList<String> arrayList = new ArrayList<String>();
        AsciiEncoder asciiEncoder = new AsciiEncoder();
        for (int i = 0; i < n2; i += 3) {
            StringBuilder stringBuilder = new StringBuilder();
            for (int j = 0; j < n; ++j) {
                int n3 = this.getGrayOn16(bufferedImage, j, i) / 4;
                assert (n3 >= 0 && n3 <= 3);
                int n4 = this.getGrayOn16(bufferedImage, j, i + 1) / 4;
                assert (n4 >= 0 && n4 <= 3);
                int n5 = this.getGrayOn16(bufferedImage, j, i + 2) / 4;
                assert (n5 >= 0 && n5 <= 3);
                int n6 = n3 * 16 + n4 * 4 + n5;
                stringBuilder.append(asciiEncoder.encode6bit((byte)n6));
            }
            arrayList.add(stringBuilder.toString());
        }
        return Collections.unmodifiableList(arrayList);
    }

    private int getGrayOn16(BufferedImage bufferedImage, int n, int n2) {
        if (n >= bufferedImage.getWidth()) {
            return 0;
        }
        if (n2 >= bufferedImage.getHeight()) {
            return 0;
        }
        Color color = mono.getChangedColor(new Color(bufferedImage.getRGB(n, n2)));
        int n3 = 255 - color.getRed();
        return n3 / 16;
    }

    public Sprite buildSprite(int n, int n2, List<String> list) {
        if (this == GRAY_16) {
            return this.buildSprite16(list);
        }
        if (this == GRAY_8) {
            return this.buildSprite8(n, n2, list);
        }
        if (this == GRAY_4) {
            return this.buildSprite4(n, n2, list);
        }
        throw new UnsupportedOperationException(this.toString());
    }

    private Sprite buildSprite16(List<String> list) {
        SpriteMonochrome spriteMonochrome = new SpriteMonochrome(list.get(0).length(), list.size(), 16);
        for (int i = 0; i < spriteMonochrome.getWidth(); ++i) {
            for (int j = 0; j < spriteMonochrome.getHeight(); ++j) {
                if (i >= list.get(j).length() || list.get(j).charAt(i) == '0') continue;
                String string = "" + list.get(j).charAt(i);
                int n = Integer.parseInt(StringUtils.goUpperCase(string), 16);
                spriteMonochrome.setPixel(i, j, n);
            }
        }
        return spriteMonochrome;
    }

    private Sprite buildSprite8(int n, int n2, List<String> list) {
        AsciiEncoder asciiEncoder = new AsciiEncoder();
        SpriteMonochrome spriteMonochrome = new SpriteMonochrome(n, n2, 8);
        for (int i = 0; i < spriteMonochrome.getWidth(); ++i) {
            for (int j = 0; j < list.size(); ++j) {
                if (i >= list.get(j).length()) continue;
                int n3 = asciiEncoder.decode6bit(list.get(j).charAt(i));
                int n4 = n3 / 8;
                int n5 = n3 % 8;
                spriteMonochrome.setPixel(i, j * 2, n4);
                spriteMonochrome.setPixel(i, j * 2 + 1, n5);
            }
        }
        return spriteMonochrome;
    }

    private Sprite buildSprite4(int n, int n2, List<String> list) {
        AsciiEncoder asciiEncoder = new AsciiEncoder();
        SpriteMonochrome spriteMonochrome = new SpriteMonochrome(n, n2, 4);
        for (int i = 0; i < spriteMonochrome.getWidth(); ++i) {
            for (int j = 0; j < list.size(); ++j) {
                if (i >= list.get(j).length()) continue;
                int n3 = asciiEncoder.decode6bit(list.get(j).charAt(i));
                int n4 = n3 / 16;
                int n5 = (n3 %= 16) / 4;
                int n6 = n3 % 4;
                spriteMonochrome.setPixel(i, j * 3, n4);
                spriteMonochrome.setPixel(i, j * 3 + 1, n5);
                spriteMonochrome.setPixel(i, j * 3 + 2, n6);
            }
        }
        return spriteMonochrome;
    }

    public List<String> encodeZ(BufferedImage bufferedImage) {
        int n = bufferedImage.getWidth();
        int n2 = bufferedImage.getHeight();
        byte[] byArray = new byte[n * n2];
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, 1);
        int n3 = 0;
        int n4 = 16 / this.nbColor;
        for (int i = 0; i < n2; ++i) {
            for (int j = 0; j < n; ++j) {
                int n5 = this.getGrayOn16(bufferedImage, j, i) / n4;
                byArray[n3++] = (byte)n5;
                bufferedImage2.setRGB(j, i, n5 * n4);
            }
        }
        byte[] byArray2 = new CompressionZlib().compress(byArray);
        return this.cut(new AsciiEncoder().encode(byArray2));
    }

    private List<String> cut(String string) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (int i = 0; i < string.length(); i += 120) {
            int n = Math.min(i + 120, string.length());
            arrayList.add(string.substring(i, n));
        }
        return Collections.unmodifiableList(arrayList);
    }

    public Sprite buildSpriteZ(int n, int n2, String string) throws IOException {
        byte[] byArray = new AsciiEncoder().decode(string);
        byte[] byArray2 = new CompressionZlib().decompress(byArray);
        SpriteMonochrome spriteMonochrome = new SpriteMonochrome(n, n2, this.nbColor);
        int n3 = 0;
        for (int i = 0; i < spriteMonochrome.getHeight(); ++i) {
            for (int j = 0; j < spriteMonochrome.getWidth(); ++j) {
                spriteMonochrome.setPixel(j, i, byArray2[n3++]);
            }
        }
        return spriteMonochrome;
    }

    static {
        $VALUES = new SpriteGrayLevel[]{GRAY_16, GRAY_8, GRAY_4};
        mono = new ColorChangerMonochrome();
    }
}

