/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ugraphic.eps;

import java.awt.geom.Point2D;
import net.sourceforge.plantuml.eps.EpsGraphics;
import net.sourceforge.plantuml.ugraphic.ClipContainer;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.UClip;
import net.sourceforge.plantuml.ugraphic.UDriver;
import net.sourceforge.plantuml.ugraphic.UParam;
import net.sourceforge.plantuml.ugraphic.UPolygon;
import net.sourceforge.plantuml.ugraphic.UShape;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DriverPolygonEps
implements UDriver<EpsGraphics> {
    private final ClipContainer clipContainer;

    public DriverPolygonEps(ClipContainer clipContainer) {
        this.clipContainer = clipContainer;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void draw(UShape uShape, double d, double d2, ColorMapper colorMapper, UParam uParam, EpsGraphics epsGraphics) {
        UPolygon uPolygon = (UPolygon)uShape;
        double[] dArray = new double[uPolygon.getPoints().size() * 2];
        int n = 0;
        for (Point2D point2D : uPolygon.getPoints()) {
            dArray[n++] = point2D.getX() + d;
            dArray[n++] = point2D.getY() + d2;
        }
        UClip uClip = this.clipContainer.getClip();
        if (uClip != null) {
            void var13_13;
            boolean i = false;
            while (var13_13 < dArray.length) {
                if (!uClip.isInside(dArray[var13_13], dArray[var13_13 + true])) {
                    return;
                }
                var13_13 += 2;
            }
        }
        if (uPolygon.getDeltaShadow() != 0.0) {
            epsGraphics.epsPolygonShadow(uPolygon.getDeltaShadow(), dArray);
        }
        epsGraphics.setFillColor(colorMapper.getMappedColor(uParam.getBackcolor()));
        epsGraphics.setStrokeColor(colorMapper.getMappedColor(uParam.getColor()));
        epsGraphics.epsPolygon(dArray);
    }
}

