/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.File;
import net.sourceforge.plantuml.BlockUml;
import net.sourceforge.plantuml.GeneratedImage;
import net.sourceforge.plantuml.PSystemError;
import net.sourceforge.plantuml.core.Diagram;

public class GeneratedImageImpl
implements GeneratedImage {
    private final File pngFile;
    private final String description;
    private final BlockUml blockUml;

    public GeneratedImageImpl(File file, String string, BlockUml blockUml) {
        this.blockUml = blockUml;
        this.pngFile = file;
        this.description = string;
    }

    public File getPngFile() {
        return this.pngFile;
    }

    public String getDescription() {
        return this.description;
    }

    public int lineErrorRaw() {
        Diagram diagram = this.blockUml.getDiagram();
        if (diagram instanceof PSystemError) {
            return ((PSystemError)diagram).getHigherErrorPosition() + this.blockUml.getStartLine();
        }
        return -1;
    }

    public String toString() {
        return this.pngFile.getAbsolutePath() + " " + this.description;
    }

    public int compareTo(GeneratedImage generatedImage) {
        int n = this.pngFile.compareTo(generatedImage.getPngFile());
        if (n != 0) {
            return n;
        }
        return this.description.compareTo(generatedImage.getDescription());
    }

    public int hashCode() {
        return this.pngFile.hashCode() + this.description.hashCode();
    }

    public boolean equals(Object object) {
        GeneratedImageImpl generatedImageImpl = (GeneratedImageImpl)object;
        return generatedImageImpl.pngFile.equals(this.pngFile) && generatedImageImpl.description.equals(this.description);
    }
}

