/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.AbstractPSystem;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.command.BlocLines;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.DiagramDescriptionImpl;
import net.sourceforge.plantuml.core.ImageData;

public class NewpagedDiagram
extends AbstractPSystem {
    private final List<Diagram> diagrams = new ArrayList<Diagram>();

    public NewpagedDiagram(AbstractPSystem abstractPSystem, AbstractPSystem abstractPSystem2) {
        if (abstractPSystem instanceof NewpagedDiagram) {
            throw new IllegalArgumentException();
        }
        if (abstractPSystem2 instanceof NewpagedDiagram) {
            throw new IllegalArgumentException();
        }
        this.diagrams.add(abstractPSystem);
        this.diagrams.add(abstractPSystem2);
    }

    public String toString() {
        return super.toString() + " SIZE=" + this.diagrams.size() + " " + this.diagrams;
    }

    public Diagram getLastDiagram() {
        return this.diagrams.get(this.diagrams.size() - 1);
    }

    public CommandExecutionResult executeCommand(Command command, BlocLines blocLines) {
        int n = this.diagrams.size();
        CommandExecutionResult commandExecutionResult = command.execute(this.diagrams.get(n - 1), blocLines);
        if (commandExecutionResult.getNewDiagram() instanceof NewpagedDiagram) {
            NewpagedDiagram newpagedDiagram = (NewpagedDiagram)commandExecutionResult.getNewDiagram();
            if (newpagedDiagram.size() != 2) {
                throw new IllegalStateException();
            }
            if (newpagedDiagram.diagrams.get(0) != this.diagrams.get(n - 1)) {
                throw new IllegalStateException();
            }
            this.diagrams.add(newpagedDiagram.diagrams.get(1));
            return commandExecutionResult.withDiagram(this);
        }
        return commandExecutionResult;
    }

    private int size() {
        return this.diagrams.size();
    }

    public ImageData exportDiagram(OutputStream outputStream, int n, FileFormatOption fileFormatOption) throws IOException {
        return this.diagrams.get(n).exportDiagram(outputStream, 0, fileFormatOption);
    }

    public int getNbImages() {
        int n = 0;
        for (Diagram diagram : this.diagrams) {
            n += diagram.getNbImages();
        }
        return n;
    }

    public DiagramDescription getDescription() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Diagram diagram : this.diagrams) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(diagram.getDescription());
        }
        return new DiagramDescriptionImpl(stringBuilder.toString(), this.getClass());
    }

    public String getWarningOrError() {
        StringBuilder stringBuilder = new StringBuilder();
        for (Diagram diagram : this.diagrams) {
            if (stringBuilder.length() > 0) {
                stringBuilder.append(" ");
            }
            stringBuilder.append(diagram.getWarningOrError());
        }
        return stringBuilder.toString();
    }

    public void makeDiagramReady() {
        super.makeDiagramReady();
        for (Diagram diagram : this.diagrams) {
            ((AbstractPSystem)diagram).makeDiagramReady();
        }
    }
}

