/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.plantuml.AlignParam;
import net.sourceforge.plantuml.ColorParam;
import net.sourceforge.plantuml.FontParam;
import net.sourceforge.plantuml.ISkinParam;
import net.sourceforge.plantuml.LineParam;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.UmlDiagramType;
import net.sourceforge.plantuml.command.regex.MyPattern;
import net.sourceforge.plantuml.cucadiagram.Rankdir;
import net.sourceforge.plantuml.cucadiagram.Stereotype;
import net.sourceforge.plantuml.cucadiagram.dot.DotSplines;
import net.sourceforge.plantuml.cucadiagram.dot.GraphvizLayoutStrategy;
import net.sourceforge.plantuml.graphic.HorizontalAlignment;
import net.sourceforge.plantuml.graphic.HtmlColor;
import net.sourceforge.plantuml.graphic.HtmlColorSetSimple;
import net.sourceforge.plantuml.graphic.HtmlColorUtils;
import net.sourceforge.plantuml.graphic.IHtmlColorSet;
import net.sourceforge.plantuml.graphic.SkinParameter;
import net.sourceforge.plantuml.graphic.color.Colors;
import net.sourceforge.plantuml.svek.ConditionStyle;
import net.sourceforge.plantuml.svek.PackageStyle;
import net.sourceforge.plantuml.ugraphic.ColorMapper;
import net.sourceforge.plantuml.ugraphic.ColorMapperIdentity;
import net.sourceforge.plantuml.ugraphic.ColorMapperMonochrome;
import net.sourceforge.plantuml.ugraphic.Sprite;
import net.sourceforge.plantuml.ugraphic.SpriteImage;
import net.sourceforge.plantuml.ugraphic.UFont;
import net.sourceforge.plantuml.ugraphic.UStroke;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SkinParam
implements ISkinParam {
    private final Map<String, String> params = new HashMap<String, String>();
    private Rankdir rankdir = Rankdir.TOP_TO_BOTTOM;
    private static final String stereoPatternString = "\\<\\<(.*?)\\>\\>";
    private static final Pattern stereoPattern = MyPattern.cmpile("\\<\\<(.*?)\\>\\>");
    private final Map<String, Sprite> sprites = new HashMap<String, Sprite>();
    private final IHtmlColorSet htmlColorSet = new HtmlColorSetSimple();

    public void setParam(String string, String string2) {
        this.params.put(SkinParam.cleanForKey(string), StringUtils.trin(string2));
    }

    public static SkinParam noShadowing() {
        SkinParam skinParam = new SkinParam();
        skinParam.setParam("shadowing", "false");
        return skinParam;
    }

    static String cleanForKey(String string) {
        Matcher matcher;
        string = StringUtils.trin(StringUtils.goLowerCase(string));
        string = string.replaceAll("_|\\.|\\s", "");
        string = SkinParam.replaceSmart(string, "partition", "package");
        string = SkinParam.replaceSmart(string, "sequenceparticipant", "participant");
        if ((string = SkinParam.replaceSmart(string, "sequenceactor", "actor")).contains("arrow")) {
            string = string.replaceAll("activityarrow|objectarrow|classarrow|componentarrow|statearrow|usecasearrow", "genericarrow");
        }
        if ((matcher = stereoPattern.matcher(string)).find()) {
            String string2 = matcher.group(1);
            string = string.replaceAll(stereoPatternString, "");
            string = string + "<<" + string2 + ">>";
        }
        return string;
    }

    private static String replaceSmart(String string, String string2, String string3) {
        if (!string.contains(string2)) {
            return string;
        }
        return string.replaceAll(string2, string3);
    }

    @Override
    public HtmlColor getHyperlinkColor() {
        HtmlColor htmlColor = this.getHtmlColor(ColorParam.hyperlink, null, false);
        if (htmlColor == null) {
            return HtmlColorUtils.BLUE;
        }
        return htmlColor;
    }

    @Override
    public HtmlColor getBackgroundColor() {
        HtmlColor htmlColor = this.getHtmlColor(ColorParam.background, null, false);
        if (htmlColor == null) {
            return HtmlColorUtils.WHITE;
        }
        return htmlColor;
    }

    @Override
    public String getValue(String string) {
        return this.params.get(SkinParam.cleanForKey(string));
    }

    static String humanName(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        boolean bl = true;
        for (int i = 0; i < string.length(); ++i) {
            char c = string.charAt(i);
            if (c == '_') {
                bl = true;
                continue;
            }
            stringBuilder.append(bl ? StringUtils.goUpperCase(c) : StringUtils.goLowerCase(c));
            bl = false;
        }
        return stringBuilder.toString();
    }

    @Override
    public HtmlColor getHtmlColor(ColorParam colorParam, Stereotype stereotype, boolean bl) {
        String string;
        if (stereotype != null) {
            this.checkStereotype(stereotype);
            string = this.getValue(colorParam.name() + "color" + stereotype.getLabel(false));
            if (string != null && this.getIHtmlColorSet().getColorIfValid(string) != null) {
                return this.getIHtmlColorSet().getColorIfValid(string);
            }
        }
        if ((string = this.getValue(this.getParamName(colorParam, bl))) == null) {
            return null;
        }
        boolean bl2 = colorParam == ColorParam.background;
        return this.getIHtmlColorSet().getColorIfValid(string, bl2);
    }

    @Override
    public Colors getColors(ColorParam colorParam, Stereotype stereotype) {
        String string;
        if (stereotype != null) {
            this.checkStereotype(stereotype);
            string = this.getValue(colorParam.name() + "color" + stereotype.getLabel(false));
            if (string != null && this.getIHtmlColorSet().getColorIfValid(string) != null) {
                return new Colors(string, this.getIHtmlColorSet(), colorParam.getColorType());
            }
        }
        if ((string = this.getValue(this.getParamName(colorParam, false))) == null) {
            return Colors.empty();
        }
        return new Colors(string, this.getIHtmlColorSet(), colorParam.getColorType());
    }

    private String getParamName(ColorParam colorParam, boolean bl) {
        String string = colorParam.name();
        if (bl && string.endsWith("Background")) {
            string = string.replaceAll("Background", "ClickableBackground");
        } else if (bl && string.endsWith("Border")) {
            string = string.replaceAll("Border", "ClickableBorder");
        }
        return string + "color";
    }

    private void checkStereotype(Stereotype stereotype) {
    }

    private int getFontSize(Stereotype stereotype, FontParam ... fontParamArray) {
        String string;
        if (stereotype != null) {
            this.checkStereotype(stereotype);
            string = this.getFirstValueNonNullWithSuffix("fontsize" + stereotype.getLabel(false), fontParamArray);
            if (string != null && string.matches("\\d+")) {
                return Integer.parseInt(string);
            }
        }
        if ((string = this.getFirstValueNonNullWithSuffix("fontsize", fontParamArray)) == null || !string.matches("\\d+")) {
            string = this.getValue("defaultfontsize");
        }
        if (string == null || !string.matches("\\d+")) {
            return fontParamArray[0].getDefaultSize(this);
        }
        return Integer.parseInt(string);
    }

    private String getFontFamily(Stereotype stereotype, FontParam ... fontParamArray) {
        String string;
        if (stereotype != null) {
            this.checkStereotype(stereotype);
            string = this.getFirstValueNonNullWithSuffix("fontname" + stereotype.getLabel(false), fontParamArray);
            if (string != null) {
                return StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(string);
            }
        }
        if ((string = this.getFirstValueNonNullWithSuffix("fontname", fontParamArray)) != null) {
            return StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(string);
        }
        if (fontParamArray[0] != FontParam.CIRCLED_CHARACTER && (string = this.getValue("defaultfontname")) != null) {
            return StringUtils.eventuallyRemoveStartingAndEndingDoubleQuote(string);
        }
        return fontParamArray[0].getDefaultFamily();
    }

    @Override
    public HtmlColor getFontHtmlColor(Stereotype stereotype, FontParam ... fontParamArray) {
        String string = null;
        if (stereotype != null) {
            this.checkStereotype(stereotype);
            string = this.getFirstValueNonNullWithSuffix("fontcolor" + stereotype.getLabel(false), fontParamArray);
        }
        if (string == null || this.getIHtmlColorSet().getColorIfValid(string) == null) {
            string = this.getFirstValueNonNullWithSuffix("fontcolor", fontParamArray);
        }
        if (string == null || this.getIHtmlColorSet().getColorIfValid(string) == null) {
            string = this.getValue("defaultfontcolor");
        }
        if (string == null || this.getIHtmlColorSet().getColorIfValid(string) == null) {
            string = fontParamArray[0].getDefaultColor();
        }
        return this.getIHtmlColorSet().getColorIfValid(string);
    }

    private String getFirstValueNonNullWithSuffix(String string, FontParam ... fontParamArray) {
        for (FontParam fontParam : fontParamArray) {
            String string2 = this.getValue(fontParam.name() + string);
            if (string2 == null) continue;
            return string2;
        }
        return null;
    }

    private int getFontStyle(Stereotype stereotype, boolean bl, FontParam ... fontParamArray) {
        String string = null;
        if (stereotype != null) {
            this.checkStereotype(stereotype);
            string = this.getFirstValueNonNullWithSuffix("fontstyle" + stereotype.getLabel(false), fontParamArray);
        }
        if (string == null) {
            string = this.getFirstValueNonNullWithSuffix("fontstyle", fontParamArray);
        }
        if (string == null) {
            string = this.getValue("defaultfontstyle");
        }
        if (string == null) {
            return fontParamArray[0].getDefaultFontStyle(this, bl);
        }
        int n = 0;
        if (StringUtils.goLowerCase(string).contains("bold")) {
            n |= 1;
        }
        if (StringUtils.goLowerCase(string).contains("italic")) {
            n |= 2;
        }
        return n;
    }

    @Override
    public UFont getFont(Stereotype stereotype, boolean bl, FontParam ... fontParamArray) {
        if (stereotype != null) {
            this.checkStereotype(stereotype);
        }
        String string = this.getFontFamily(stereotype, fontParamArray);
        int n = this.getFontStyle(stereotype, bl, fontParamArray);
        int n2 = this.getFontSize(stereotype, fontParamArray);
        return new UFont(string, n, n2);
    }

    @Override
    public int getCircledCharacterRadius() {
        String string = this.getValue("circledcharacterradius");
        if (string != null && string.matches("\\d+")) {
            return Integer.parseInt(string);
        }
        return this.getFontSize(null, FontParam.CIRCLED_CHARACTER) / 3 + 6;
    }

    @Override
    public int classAttributeIconSize() {
        String string = this.getValue("classAttributeIconSize");
        if (string != null && string.matches("\\d+")) {
            return Integer.parseInt(string);
        }
        return 10;
    }

    private boolean isMonochrome() {
        return "true".equals(this.getValue("monochrome"));
    }

    public static Collection<String> getPossibleValues() {
        String string;
        TreeSet<String> treeSet = new TreeSet<String>();
        treeSet.add("Monochrome");
        treeSet.add("CircledCharacterRadius");
        treeSet.add("ClassAttributeIconSize");
        treeSet.add("DefaultFontName");
        treeSet.add("DefaultFontStyle");
        treeSet.add("DefaultFontSize");
        treeSet.add("DefaultFontColor");
        for (FontParam enum_ : EnumSet.allOf(FontParam.class)) {
            string = SkinParam.humanName(enum_.name());
            treeSet.add(string + "FontStyle");
            treeSet.add(string + "FontName");
            treeSet.add(string + "FontSize");
            treeSet.add(string + "FontColor");
        }
        for (ColorParam colorParam : EnumSet.allOf(ColorParam.class)) {
            string = SkinParam.capitalize(colorParam.name());
            treeSet.add(string + "Color");
        }
        for (LineParam lineParam : EnumSet.allOf(LineParam.class)) {
            string = SkinParam.capitalize(lineParam.name());
            treeSet.add(string + "Thickness");
        }
        return Collections.unmodifiableSet(treeSet);
    }

    private static String capitalize(String string) {
        return StringUtils.goUpperCase(string.substring(0, 1)) + string.substring(1);
    }

    @Override
    public int getDpi() {
        String string = this.getValue("dpi");
        if (string != null && string.matches("\\d+")) {
            return Integer.parseInt(string);
        }
        return 96;
    }

    @Override
    public DotSplines getDotSplines() {
        String string = this.getValue("linetype");
        if ("polyline".equalsIgnoreCase(string)) {
            return DotSplines.POLYLINE;
        }
        if ("ortho".equalsIgnoreCase(string)) {
            return DotSplines.ORTHO;
        }
        return DotSplines.SPLINES;
    }

    @Override
    public GraphvizLayoutStrategy getStrategy() {
        String string = this.getValue("layout");
        if ("neato".equalsIgnoreCase(string)) {
            return GraphvizLayoutStrategy.NEATO;
        }
        if ("circo".equalsIgnoreCase(string)) {
            return GraphvizLayoutStrategy.CIRCO;
        }
        if ("fdp".equalsIgnoreCase(string)) {
            return GraphvizLayoutStrategy.FDP;
        }
        if ("twopi".equalsIgnoreCase(string)) {
            return GraphvizLayoutStrategy.TWOPI;
        }
        return GraphvizLayoutStrategy.DOT;
    }

    @Override
    public HorizontalAlignment getHorizontalAlignment(AlignParam alignParam) {
        String string;
        switch (alignParam) {
            case SEQUENCE_MESSAGE_ALIGN: {
                string = this.getArg(this.getValue(AlignParam.SEQUENCE_MESSAGE_ALIGN.name()), 0);
                break;
            }
            case SEQUENCE_MESSAGETEXT_ALIGN: {
                string = this.getArg(this.getValue(AlignParam.SEQUENCE_MESSAGE_ALIGN.name()), 1);
                break;
            }
            default: {
                string = this.getValue(alignParam.name());
            }
        }
        HorizontalAlignment horizontalAlignment = HorizontalAlignment.fromString(string);
        if (horizontalAlignment == null) {
            return alignParam.getDefaultValue();
        }
        return horizontalAlignment;
    }

    @Override
    public HorizontalAlignment getDefaultTextAlignment() {
        String string = this.getValue("defaulttextalignment");
        HorizontalAlignment horizontalAlignment = HorizontalAlignment.fromString(string);
        if (horizontalAlignment == null) {
            return HorizontalAlignment.CENTER;
        }
        return horizontalAlignment;
    }

    private String getArg(String string, int n) {
        if (string == null) {
            return null;
        }
        String[] stringArray = string.split(":");
        if (n >= stringArray.length) {
            return stringArray[0];
        }
        return stringArray[n];
    }

    @Override
    public ColorMapper getColorMapper() {
        if (this.isMonochrome()) {
            return new ColorMapperMonochrome();
        }
        return new ColorMapperIdentity();
    }

    @Override
    public boolean shadowing() {
        String string = this.getValue("shadowing");
        if ("false".equalsIgnoreCase(string)) {
            return false;
        }
        if ("true".equalsIgnoreCase(string)) {
            return true;
        }
        return !this.strictUmlStyle();
    }

    @Override
    public boolean shadowingForNote(Stereotype stereotype) {
        String string;
        if (stereotype != null) {
            this.checkStereotype(stereotype);
            string = this.getValue("noteshadowing" + stereotype.getLabel(false));
            if (string != null) {
                return string.equalsIgnoreCase("true");
            }
        }
        if ((string = this.getValue("noteshadowing")) != null) {
            return string.equalsIgnoreCase("true");
        }
        return this.shadowing();
    }

    @Override
    public boolean shadowing2(SkinParameter skinParameter) {
        if (skinParameter == null) {
            throw new IllegalArgumentException();
        }
        String string = skinParameter.getUpperCaseName();
        String string2 = this.getValue(string + "shadowing");
        if (string2 == null) {
            return this.shadowing();
        }
        if ("false".equalsIgnoreCase(string2)) {
            return false;
        }
        if ("true".equalsIgnoreCase(string2)) {
            return true;
        }
        return !this.strictUmlStyle();
    }

    @Override
    public PackageStyle getPackageStyle() {
        String string = this.getValue("packageStyle");
        PackageStyle packageStyle = PackageStyle.fromString(string);
        if (packageStyle == null) {
            return PackageStyle.FOLDER;
        }
        return packageStyle;
    }

    public void addSprite(String string, Sprite sprite) {
        this.sprites.put(string, sprite);
    }

    @Override
    public Sprite getSprite(String string) {
        Sprite sprite = this.sprites.get(string);
        if (sprite == null) {
            sprite = SpriteImage.fromInternal(string);
        }
        return sprite;
    }

    @Override
    public boolean useUml2ForComponent() {
        if (this.strictUmlStyle()) {
            return true;
        }
        String string = this.getValue("componentstyle");
        return "uml2".equalsIgnoreCase(string);
    }

    @Override
    public boolean stereotypePositionTop() {
        String string = this.getValue("stereotypePosition");
        return !"bottom".equalsIgnoreCase(string);
    }

    @Override
    public boolean useSwimlanes(UmlDiagramType umlDiagramType) {
        if (umlDiagramType != UmlDiagramType.ACTIVITY) {
            return false;
        }
        if ("true".equalsIgnoreCase(this.getValue("swimlane"))) {
            return true;
        }
        return "true".equalsIgnoreCase(this.getValue("swimlanes"));
    }

    @Override
    public double getNodesep() {
        String string = this.getValue("nodesep");
        if (string != null && string.matches("\\d+")) {
            return Double.parseDouble(string);
        }
        return 0.0;
    }

    @Override
    public double getRanksep() {
        String string = this.getValue("ranksep");
        if (string != null && string.matches("\\d+")) {
            return Double.parseDouble(string);
        }
        return 0.0;
    }

    @Override
    public double getRoundCorner() {
        String string = this.getValue("roundcorner");
        if (string != null && string.matches("\\d+")) {
            return Double.parseDouble(string);
        }
        return 0.0;
    }

    @Override
    public UStroke getThickness(LineParam lineParam, Stereotype stereotype) {
        String string;
        if (stereotype != null) {
            this.checkStereotype(stereotype);
            string = this.getValue(lineParam.name() + "thickness" + stereotype.getLabel(false));
            if (string != null && string.matches("[\\d.]+")) {
                return new UStroke(Double.parseDouble(string));
            }
        }
        if ((string = this.getValue(lineParam.name() + "thickness")) != null && string.matches("[\\d.]+")) {
            return new UStroke(Double.parseDouble(string));
        }
        return null;
    }

    @Override
    public double maxMessageSize() {
        String string = this.getValue("maxmessagesize");
        if (string != null && string.matches("-?\\d+")) {
            return Double.parseDouble(string);
        }
        return 0.0;
    }

    @Override
    public boolean strictUmlStyle() {
        String string = this.getValue("style");
        return "strictuml".equalsIgnoreCase(string);
    }

    @Override
    public boolean forceSequenceParticipantUnderlined() {
        String string = this.getValue("sequenceParticipant");
        return "underline".equalsIgnoreCase(string);
    }

    @Override
    public ConditionStyle getConditionStyle() {
        String string = this.getValue("conditionStyle");
        ConditionStyle conditionStyle = ConditionStyle.fromString(string);
        if (conditionStyle == null) {
            return ConditionStyle.INSIDE;
        }
        return conditionStyle;
    }

    @Override
    public double minClassWidth() {
        String string = this.getValue("minclasswidth");
        if (string != null && string.matches("\\d+")) {
            return Integer.parseInt(string);
        }
        return 0.0;
    }

    @Override
    public boolean sameClassWidth() {
        return "true".equals(this.getValue("sameclasswidth"));
    }

    @Override
    public final Rankdir getRankdir() {
        return this.rankdir;
    }

    public final void setRankdir(Rankdir rankdir) {
        this.rankdir = rankdir;
    }

    @Override
    public boolean useOctagonForActivity(Stereotype stereotype) {
        String string = this.getValue("activityshape");
        if (stereotype != null) {
            this.checkStereotype(stereotype);
            String string2 = this.getValue("activityshape" + stereotype.getLabel(false));
            if (string2 != null) {
                string = string2;
            }
        }
        if ("roundedbox".equalsIgnoreCase(string)) {
            return false;
        }
        return "octagon".equalsIgnoreCase(string);
    }

    @Override
    public IHtmlColorSet getIHtmlColorSet() {
        return this.htmlColorSet;
    }

    @Override
    public boolean useUnderlineForHyperlink() {
        String string = this.getValue("hyperlinkunderline");
        return !"false".equalsIgnoreCase(string);
    }

    @Override
    public double getPadding() {
        String string = this.getValue("padding");
        if (string != null && string.matches("\\d+(\\.\\d+)?")) {
            return Double.parseDouble(string);
        }
        return 0.0;
    }

    @Override
    public int groupInheritance() {
        String string = this.getValue("groupinheritance");
        int n = Integer.MAX_VALUE;
        if (string != null && string.matches("\\d+")) {
            n = Integer.parseInt(string);
        }
        if (n <= 1) {
            n = Integer.MAX_VALUE;
        }
        return n;
    }

    @Override
    public boolean useGuillemet() {
        String string = this.getValue("guillemet");
        return !"false".equalsIgnoreCase(string);
    }

    @Override
    public boolean handwritten() {
        String string = this.getValue("handwritten");
        return "true".equalsIgnoreCase(string);
    }

    @Override
    public String getSvgLinkTarget() {
        String string = this.getValue("svglinktarget");
        if (string == null) {
            return "_top";
        }
        return string;
    }

    @Override
    public String getMonospacedFamily() {
        String string = this.getValue("defaultMonospacedFontName");
        if (string == null) {
            return "monospaced";
        }
        return string;
    }

    @Override
    public int getTabSize() {
        String string = this.getValue("tabsize");
        if (string != null && string.matches("\\d+")) {
            return Integer.parseInt(string);
        }
        return 8;
    }
}

