/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.sourceforge.plantuml.BlockUml;
import net.sourceforge.plantuml.BlockUmlBuilder;
import net.sourceforge.plantuml.FileFormat;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.FileSystem;
import net.sourceforge.plantuml.GeneratedImage;
import net.sourceforge.plantuml.GeneratedImageImpl;
import net.sourceforge.plantuml.ISourceFileReader;
import net.sourceforge.plantuml.Log;
import net.sourceforge.plantuml.OptionFlags;
import net.sourceforge.plantuml.PSystemError;
import net.sourceforge.plantuml.PSystemUtils;
import net.sourceforge.plantuml.UmlDiagram;
import net.sourceforge.plantuml.code.Transcoder;
import net.sourceforge.plantuml.code.TranscoderUtil;
import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.preproc.Defines;
import net.sourceforge.plantuml.preproc.FileWithSuffix;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceFileReader
implements ISourceFileReader {
    private final File file;
    private final File outputDirectory;
    private final BlockUmlBuilder builder;
    private FileFormatOption fileFormatOption;

    public SourceFileReader(File file) throws IOException {
        this(file, file.getAbsoluteFile().getParentFile());
    }

    public SourceFileReader(File file, File file2, String string) throws IOException {
        this(new Defines(), file, file2, Collections.emptyList(), string, new FileFormatOption(FileFormat.PNG));
    }

    public SourceFileReader(File file, File file2) throws IOException {
        this(new Defines(), file, file2, Collections.emptyList(), null, new FileFormatOption(FileFormat.PNG));
    }

    public SourceFileReader(File file, File file2, FileFormatOption fileFormatOption) throws IOException {
        this(new Defines(), file, file2, Collections.emptyList(), null, fileFormatOption);
    }

    public SourceFileReader(Defines defines, File file, File file2, List<String> list, String string, FileFormatOption fileFormatOption) throws IOException {
        this.file = file;
        this.fileFormatOption = fileFormatOption;
        if (!file.exists()) {
            throw new IllegalArgumentException();
        }
        FileSystem.getInstance().setCurrentDir(file.getAbsoluteFile().getParentFile());
        if (file2 == null) {
            file2 = file.getAbsoluteFile().getParentFile();
        } else if (!file2.isAbsolute()) {
            file2 = FileSystem.getInstance().getFile(file2.getPath());
        }
        if (!file2.exists()) {
            file2.mkdirs();
        }
        this.outputDirectory = file2;
        this.builder = new BlockUmlBuilder(list, string, defines, this.getReader(string), file.getAbsoluteFile().getParentFile(), file.getAbsolutePath());
    }

    @Override
    public boolean hasError() {
        for (BlockUml blockUml : this.builder.getBlockUmls()) {
            if (!(blockUml.getDiagram() instanceof PSystemError)) continue;
            return true;
        }
        return false;
    }

    private File getDirIfDirectory(String string) {
        Log.info("Checking=" + string);
        if (this.endsWithSlashOrAntislash(string)) {
            Log.info("It ends with / so it looks like a directory");
            string = string.substring(0, string.length() - 1);
            File file = new File(string);
            Log.info("f=" + file);
            if (!file.isAbsolute()) {
                Log.info("It's relative, so let's change it");
                file = new File(this.outputDirectory, string);
                Log.info("f=" + file);
            }
            if (!file.exists()) {
                Log.info("It does not exist: let's create it");
                try {
                    file.mkdirs();
                }
                catch (Exception exception) {
                    Log.info("Error " + exception);
                }
                if (file.exists() && file.isDirectory()) {
                    Log.info("Creation ok");
                    return file;
                }
                Log.info("We cannot create it");
            } else if (!file.isDirectory()) {
                Log.info("It exists, but is not a directory: we ignore it");
                return null;
            }
            return file;
        }
        File file = new File(string);
        Log.info("f=" + file);
        if (!file.isAbsolute()) {
            Log.info("Relative, so let's change it");
            file = new File(this.outputDirectory, string);
            Log.info("f=" + file);
        }
        if (file.exists() && file.isDirectory()) {
            Log.info("It's an existing directory");
            return file;
        }
        Log.info("It's not a directory");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<GeneratedImage> getGeneratedImages() throws IOException {
        Log.info("Reading file: " + this.file);
        int n = 0;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (BlockUml blockUml : this.builder.getBlockUmls()) {
            Object object;
            String string = blockUml.getFileOrDirname();
            Log.info("name from block=" + string);
            File file = null;
            if (string != null) {
                object = this.getDirIfDirectory(string);
                if (object == null) {
                    Log.info(string + " is not taken as a directory");
                    file = new File(this.outputDirectory, string);
                } else {
                    Log.info("We are going to create files in directory " + object);
                    string = this.fileFormatOption.getFileFormat().changeName(this.file.getName(), n++);
                    file = new File((File)object, string);
                }
                Log.info("We are going to put data in " + file);
            }
            if (file == null) {
                string = this.fileFormatOption.getFileFormat().changeName(this.file.getName(), n++);
                file = new File(this.outputDirectory, string);
            }
            file.getParentFile().mkdirs();
            try {
                object = blockUml.getDiagram();
            }
            catch (Throwable throwable) {
                BufferedOutputStream bufferedOutputStream;
                GeneratedImageImpl generatedImageImpl = new GeneratedImageImpl(file, "Crash Error", blockUml);
                OutputStream outputStream = null;
                try {
                    bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
                    UmlDiagram.exportDiagramError2(bufferedOutputStream, throwable, this.fileFormatOption, null, blockUml.getFlashData(), UmlDiagram.getFailureText2(throwable));
                    if (bufferedOutputStream == null) return Collections.singletonList(generatedImageImpl);
                }
                catch (Throwable throwable2) {
                    if (outputStream == null) throw throwable2;
                    outputStream.close();
                    throw throwable2;
                }
                ((OutputStream)bufferedOutputStream).close();
                return Collections.singletonList(generatedImageImpl);
            }
            List<File> list = PSystemUtils.exportDiagrams((Diagram)object, file, this.fileFormatOption);
            OptionFlags.getInstance().logData(this.file, (Diagram)object);
            for (File object2 : list) {
                Object object3;
                String string2 = "[" + this.file.getName() + "] " + object.getDescription();
                if (OptionFlags.getInstance().isWord() && (object3 = object.getWarningOrError()) != null) {
                    String string3 = object2.getName().substring(0, object2.getName().length() - 4) + ".err";
                    File file2 = new File(object2.getParentFile(), string3);
                    PrintStream printStream = new PrintStream(new FileOutputStream(file2));
                    printStream.print((String)object3);
                    printStream.close();
                }
                object3 = new GeneratedImageImpl(object2, string2, blockUml);
                arrayList.add(object3);
            }
        }
        Log.info("Number of image(s): " + arrayList.size());
        return Collections.unmodifiableList(arrayList);
    }

    private boolean endsWithSlashOrAntislash(String string) {
        return string.endsWith("/") || string.endsWith("\\");
    }

    @Override
    public List<String> getEncodedUrl() throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        Transcoder transcoder = TranscoderUtil.getDefaultTranscoder();
        for (BlockUml blockUml : this.builder.getBlockUmls()) {
            String string = blockUml.getDiagram().getSource().getPlainString();
            String string2 = transcoder.encode(string);
            arrayList.add(string2);
        }
        return Collections.unmodifiableList(arrayList);
    }

    private Reader getReader(String string) throws FileNotFoundException, UnsupportedEncodingException {
        if (string == null) {
            Log.info("Using default charset");
            return new InputStreamReader(new FileInputStream(this.file));
        }
        Log.info("Using charset " + string);
        return new InputStreamReader((InputStream)new FileInputStream(this.file), string);
    }

    @Override
    public final void setFileFormatOption(FileFormatOption fileFormatOption) {
        this.fileFormatOption = fileFormatOption;
    }

    public final Set<FileWithSuffix> getIncludedFiles() {
        return this.builder.getIncludedFiles();
    }
}

